/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.w3c.dom.Node;

public class DBGpStringValue
extends DBGpValue {
    private boolean complete = false;
    private int requiredBytes;

    public DBGpStringValue(DBGpVariable owningVariable, Node property, int strByteLen) {
        super(owningVariable);
        this.setModifiable(true);
        this.simpleParseNode(property);
        int actualLength = 0;
        DBGpTarget target = (DBGpTarget)this.getDebugTarget();
        String valueString = "";
        try {
            valueString = this.getValueString();
            actualLength = valueString.getBytes(target.getSessionEncoding()).length;
        }
        catch (Exception exception) {
            actualLength = valueString.length();
        }
        this.complete = actualLength >= strByteLen;
        this.requiredBytes = strByteLen;
    }

    public String getReferenceTypeName() throws DebugException {
        return "string";
    }

    void genValueString(String data) {
        if (data != null && data.trim().length() > 0) {
            this.setValueString(data);
        } else {
            this.setValueString("");
        }
    }

    public void setValue(String expression) throws DebugException {
        if (expression != null) {
            this.setValueString(expression.trim());
        } else {
            this.setValueString("<Invalid>");
        }
    }

    boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getRequiredBytes() {
        return this.requiredBytes;
    }
}

