/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.session;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpCommand;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.EngineTypes;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.Event;
import org.w3c.dom.Node;

public class DBGpSession {
    public static final String DEFAULT_SESSION_ENCODING = "ISO-8859-1";
    private Socket DBGpSocket;
    private AsyncResponseHandlerJob responseHandler;
    private DBGpCommand DBGpCmd;
    private DataInputStream DBGpReader;
    private boolean sessionActive = false;
    private DBGpTarget debugTarget;
    private Hashtable savedResponses = new Hashtable();
    private String ideKey;
    private String sessionId;
    private String initialScript;
    private EngineTypes engineType;
    private String engineVersion;
    private long creationTime = System.currentTimeMillis();
    private String sessionEncoding;

    public long getCreationTime() {
        return this.creationTime;
    }

    public DBGpSession(Socket connection) {
        this.DBGpSocket = connection;
        this.sessionEncoding = DEFAULT_SESSION_ENCODING;
        boolean isGood = false;
        try {
            this.DBGpCmd = new DBGpCommand(this.DBGpSocket);
            this.DBGpReader = new DataInputStream(this.DBGpSocket.getInputStream());
            this.sessionActive = true;
            byte[] response = this.readResponse();
            if (response != null) {
                DBGpResponse parsedResponse = new DBGpResponse();
                parsedResponse.parseResponse(response);
                if (1 == parsedResponse.getType()) {
                    this.ideKey = parsedResponse.getIdekey();
                    this.sessionId = parsedResponse.getSession();
                    this.initialScript = DBGpUtils.getFilenameFromURIString(parsedResponse.getFileUri());
                    this.engineVersion = parsedResponse.getEngineVersion();
                    this.engineType = parsedResponse.getEngineType();
                    isGood = true;
                } else {
                    DBGpLogger.logError("Init response not received. XML=" + parsedResponse.getRawXML(), this, null);
                }
            } else {
                DBGpLogger.logError("Unexpected null from readResponse waiting for Init", this, null);
            }
            if (!isGood) {
                this.endSession();
            }
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("UnsupportedEncodingException - 1", this, e);
            this.endSession();
        }
        catch (IOException e) {
            DBGpLogger.logException("IOException - 1", this, e);
            this.endSession();
        }
    }

    public void startSession() {
        this.responseHandler = new AsyncResponseHandlerJob();
        this.responseHandler.schedule();
    }

    public void sendAsyncCmd(String cmd) {
        this.sendAsyncCmd(cmd, null);
    }

    public DBGpResponse sendSyncCmd(String cmd) {
        return this.sendSyncCmd(cmd, null);
    }

    public void sendAsyncCmd(String cmd, String arguments) {
        if (this.sessionActive) {
            int id = DBGpCommand.getNextId();
            try {
                this.DBGpCmd.send(cmd, arguments, id, this.sessionEncoding);
            }
            catch (IOException iOException) {
                this.endSession();
            }
        }
    }

    public DBGpResponse sendSyncCmd(String cmd, String arguments) {
        if (this.sessionActive) {
            int id = DBGpCommand.getNextId();
            Event idev = new Event();
            Integer idObj = new Integer(id);
            this.savedResponses.put(idObj, idev);
            try {
                this.DBGpCmd.send(cmd, arguments, id, this.sessionEncoding);
                idev.waitForEvent();
                return (DBGpResponse)this.savedResponses.remove(idObj);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            catch (IOException iOException) {
                this.endSession();
                return null;
            }
        }
        return null;
    }

    public DBGpResponse sendSyncCmdOnResponseThread(String cmd, String args) {
        this.sendAsyncCmd(cmd, args);
        byte[] response = this.readResponse();
        DBGpResponse parsedResponse = null;
        if (response != null) {
            parsedResponse = new DBGpResponse();
            parsedResponse.parseResponse(response);
        }
        return parsedResponse;
    }

    private byte[] readResponse() {
        byte[] byteArray;
        int remainingBytesToRead = 0;
        try {
            byte receivedByte;
            while ((receivedByte = this.DBGpReader.readByte()) != 0) {
                remainingBytesToRead = remainingBytesToRead * 10 + receivedByte - 48;
            }
            byteArray = new byte[remainingBytesToRead];
            int totalBytesSoFar = 0;
            while (remainingBytesToRead > 0) {
                int bytesReceived = this.DBGpReader.read(byteArray, totalBytesSoFar, remainingBytesToRead);
                remainingBytesToRead -= bytesReceived;
                totalBytesSoFar += bytesReceived;
            }
            if (this.DBGpReader.readByte() != 0) {
                this.endSession();
                return null;
            }
        }
        catch (IOException iOException) {
            this.endSession();
            return null;
        }
        try {
            if (DBGpLogger.debugResp()) {
                DBGpLogger.debug("Response: " + new String(byteArray, this.sessionEncoding));
            }
            return byteArray;
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("UnsupportedEncodingException - 2", this, e);
            this.endSession();
            return null;
        }
    }

    public synchronized void endSession() {
        if (this.sessionActive) {
            this.sessionActive = false;
            try {
                this.DBGpSocket.shutdownInput();
            }
            catch (IOException iOException) {}
            try {
                this.DBGpSocket.shutdownOutput();
            }
            catch (IOException iOException) {}
            try {
                this.DBGpSocket.close();
            }
            catch (IOException e) {
                DBGpLogger.debugException(e);
            }
        }
        if (this.debugTarget != null) {
            this.debugTarget.sessionEnded();
            this.debugTarget = null;
        }
    }

    public String getIdeKey() {
        return this.ideKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isActive() {
        return this.sessionActive;
    }

    public String getInitialScript() {
        return this.initialScript;
    }

    public DBGpTarget getDebugTarget() {
        return this.debugTarget;
    }

    public void setDebugTarget(DBGpTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(this.getIdeKey());
        if (this.getSessionId() != null) {
            strBuf.append(" - Session:");
            strBuf.append(this.getSessionId());
        } else {
            strBuf.append(" - Web Server Session");
        }
        return strBuf.toString();
    }

    public String getSessionEncoding() {
        return this.sessionEncoding;
    }

    public void setSessionEncoding(String sessionEncoding) {
        this.sessionEncoding = sessionEncoding;
    }

    public EngineTypes getEngineType() {
        return this.engineType;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    private class AsyncResponseHandlerJob
    extends Job {
        public AsyncResponseHandlerJob() {
            super("DBGp Response Handler");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            byte[] response = null;
            while (DBGpSession.this.sessionActive) {
                try {
                    response = DBGpSession.this.readResponse();
                    if (response == null) continue;
                    DBGpResponse parsedResponse = new DBGpResponse();
                    parsedResponse.parseResponse(response);
                    int respErrorCode = parsedResponse.getErrorCode();
                    if (respErrorCode == 0 || respErrorCode == 10003) {
                        int respType = parsedResponse.getType();
                        if (respType == 2) {
                            if (parsedResponse.getStatus().equals("stopped")) {
                                this.handleStopStatus(parsedResponse);
                            } else if (parsedResponse.getStatus().equals("break")) {
                                this.handleBreakStatus(parsedResponse);
                            } else if (parsedResponse.getStatus().equals("stopping")) {
                                this.handleStoppingStatus(parsedResponse);
                            }
                        } else if (respType == 3 && respErrorCode != 10003) {
                            this.handleStreamData(parsedResponse);
                        } else {
                            DBGpLogger.logWarning("Unknown type of XML: " + response, DBGpSession.this, null);
                        }
                    }
                    this.unblockSyncCaller(parsedResponse);
                }
                catch (Throwable t) {
                    DBGpLogger.logException("Unexpected exception. Terminating the debug session", (Object)this, t);
                    DBGpSession.this.endSession();
                    DBGpResponse dummy = new DBGpResponse();
                    dummy.parseResponse((byte[])null);
                    this.unblockSyncCaller(dummy);
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            DBGpSession.this.endSession();
            return Status.OK_STATUS;
        }

        private void unblockSyncCaller(DBGpResponse parsedResponse) {
            Integer idObj = null;
            try {
                idObj = new Integer(parsedResponse.getId());
            }
            catch (NumberFormatException numberFormatException) {
                idObj = new Integer(DBGpSession.this.DBGpCmd.getLastIdSent());
            }
            if (DBGpSession.this.savedResponses.containsKey(idObj)) {
                this.postAndSignalCaller(idObj, parsedResponse);
            } else {
                DBGpUtils.isGoodDBGpResponse((Object)this, parsedResponse);
            }
        }

        private void postAndSignalCaller(Integer idObj, DBGpResponse parsedResponse) {
            Object responder = DBGpSession.this.savedResponses.get(idObj);
            if (responder instanceof Event) {
                Event idev = (Event)responder;
                DBGpSession.this.savedResponses.put(idObj, parsedResponse);
                idev.signalEvent();
            }
        }

        private void unblockAllCallers(DBGpResponse parsedResponse) {
            Set keys = DBGpSession.this.savedResponses.keySet();
            for (Integer idObj : keys) {
                this.postAndSignalCaller(idObj, parsedResponse);
            }
        }

        private void handleStreamData(DBGpResponse parsedResponse) {
        }

        private void handleStoppingStatus(DBGpResponse parsedResponse) {
            DBGpResponse stoppedResponse = DBGpSession.this.sendSyncCmdOnResponseThread("stop", null);
            if (parsedResponse.getStatus().equals("stopped")) {
                this.handleStopStatus(stoppedResponse);
            } else {
                this.handleStopStatus(stoppedResponse);
            }
        }

        private void handleStopStatus(DBGpResponse parsedResponse) {
            DBGpSession.this.endSession();
            this.unblockAllCallers(parsedResponse);
        }

        private void handleBreakStatus(DBGpResponse parsedResponse) {
            if (parsedResponse.getStatus().equals("break") && parsedResponse.getReason().equals("ok")) {
                String cmd = parsedResponse.getCommand();
                if (cmd.equals("run")) {
                    this.processBreakpointHit();
                } else if (cmd.equals("step_into") || cmd.equals("step_out") || cmd.equals("step_over")) {
                    DBGpSession.this.debugTarget.suspended(8);
                }
            }
        }

        private void processBreakpointHit() {
            DBGpResponse parsedResponse = DBGpSession.this.sendSyncCmdOnResponseThread("stack_get", null);
            if (parsedResponse != null) {
                if (parsedResponse.getStatus().equals("stopped")) {
                    this.handleStopStatus(parsedResponse);
                } else {
                    Node stackData = parsedResponse.getParentNode().getFirstChild();
                    String line = DBGpResponse.getAttribute(stackData, "lineno");
                    int lineno = 0;
                    try {
                        lineno = Integer.parseInt(line);
                        String filename = DBGpUtils.getFilenameFromURIString(DBGpResponse.getAttribute(stackData, "filename"));
                        filename = DBGpSession.this.debugTarget.mapToWorkspaceFileIfRequired(filename);
                        DBGpSession.this.debugTarget.breakpointHit(filename, lineno);
                    }
                    catch (NumberFormatException nfe) {
                        DBGpLogger.logException("Unexpected number format exception", (Object)this, nfe);
                    }
                }
            }
        }
    }
}

