/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.sourcelookup.containers;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPDirectorySourceContainer;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPExternalArchiveSourceContainer;
import org.eclipse.php.internal.debug.core.sourcelookup.containers.PHPFileSourceContainer;

public class PHPVariableSourceContainer
extends CompositeSourceContainer {
    private IPath fPath;
    private String[] validExtensions;
    private IProject project;

    public PHPVariableSourceContainer(IPath path, IProject project) {
        this.fPath = path;
        this.project = project;
        this.updateExtentionList();
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        String variableName = this.fPath.toOSString();
        File file = this.getVariableFile(variableName);
        ISourceContainer[] container = new ISourceContainer[1];
        if (file.isDirectory()) {
            container[0] = new PHPDirectorySourceContainer(file, false, this.project);
        } else {
            String fileName = file.getName();
            if (fileName.toLowerCase().endsWith(".zip")) {
                container[0] = new PHPExternalArchiveSourceContainer(file.getPath(), false, this.project);
            } else if (this.isPhpFile(fileName)) {
                container[0] = new PHPFileSourceContainer(file, this.project);
            }
        }
        return container;
    }

    public String getName() {
        return this.fPath.toString();
    }

    public ISourceContainerType getType() {
        return null;
    }

    private File getVariableFile(String variableName) {
        int index = variableName.indexOf(47);
        String extention = "";
        if (index != -1) {
            if (index + 1 < variableName.length()) {
                extention = variableName.substring(index + 1);
            }
            variableName = variableName.substring(0, index);
        }
        IPath path = PHPProjectOptions.getIncludePathVariable((String)variableName);
        path = path.append(extention);
        return path.toFile();
    }

    private boolean isPhpFile(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return false;
        }
        String ext = fileName.substring(index + 1);
        int i = 0;
        while (i < this.validExtensions.length) {
            if (ext.equals(this.validExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateExtentionList() {
        IContentType type = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        this.validExtensions = type.getFileSpecs(8);
    }
}

