/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsValueDeserializer;
import org.eclipse.php.internal.debug.core.zend.debugger.StackVariable;

public class StackLayer {
    private int depth;
    private String callerFileName;
    private int callerLineNumber;
    private String callerFunctionName;
    private String resolvedCalledFileName;
    private String calledFileName;
    private int calledLineNumber;
    private String calledFunctionName;
    private Expression[] variables;
    private Map<String, byte[]> unresolvedVariables = new HashMap<String, byte[]>();
    private ExpressionsValueDeserializer expressionValueDeserializer;

    public StackLayer(String transferEncoding) {
        this.expressionValueDeserializer = new ExpressionsValueDeserializer(transferEncoding);
    }

    public StackLayer(int depth, String callerFileName, int callerLineNumber, String callerFunctionName, String calledFileName, int calledLineNumber, String calledFunctionName, String transferEncoding) {
        this(transferEncoding);
        this.depth = depth;
        this.setCallerFileName(callerFileName);
        this.setCallerLineNumber(callerLineNumber);
        this.setCallerFunctionName(callerFunctionName);
        this.setCalledFileName(calledFileName);
        this.setCalledLineNumber(calledLineNumber);
        this.setCalledFunctionName(calledFunctionName);
    }

    public final int getDepth() {
        return this.depth;
    }

    public final String getCallerFileName() {
        return this.callerFileName;
    }

    public final void setCallerFileName(String callerFileName) {
        this.callerFileName = callerFileName;
    }

    public final int getCallerLineNumber() {
        return this.callerLineNumber;
    }

    public final void setCallerLineNumber(int callerLineNumber) {
        this.callerLineNumber = callerLineNumber;
    }

    public final String getCallerFunctionName() {
        return this.callerFunctionName;
    }

    public final void setCallerFunctionName(String callerFunctionName) {
        this.callerFunctionName = callerFunctionName;
    }

    public final String getCalledFileName() {
        return this.calledFileName;
    }

    public final void setCalledFileName(String calledFileName) {
        this.calledFileName = calledFileName;
    }

    public final String getResolvedCalledFileName() {
        return this.resolvedCalledFileName;
    }

    public final void setResolvedCalledFileName(String resolvedCalledFileName) {
        this.resolvedCalledFileName = resolvedCalledFileName;
    }

    public final int getCalledLineNumber() {
        return this.calledLineNumber;
    }

    public final void setCalledLineNumber(int calledLineNumber) {
        this.calledLineNumber = calledLineNumber;
    }

    public final String getCalledFunctionName() {
        return this.calledFunctionName;
    }

    public final void setCalledFunctionName(String calledFunctionName) {
        this.calledFunctionName = calledFunctionName;
    }

    public void addVariable(String variableName, byte[] value) {
        this.unresolvedVariables.put(variableName, value);
    }

    public Expression[] getVariables() {
        if (this.variables == null) {
            this.variables = new Expression[this.unresolvedVariables.size()];
            int i = 0;
            for (String variableName : this.unresolvedVariables.keySet()) {
                DefaultStackVariable variable = new DefaultStackVariable(variableName, this.depth);
                variable.setValue(this.expressionValueDeserializer.deserializer(variable, this.unresolvedVariables.get(variableName)));
                this.variables[i++] = variable;
            }
        }
        return this.variables;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append(this.toStringCalledFunctionLine());
        buffer.append("  " + this.callerFileName + " line " + (this.callerLineNumber + 1));
        return buffer.toString();
    }

    public String toStringCalledFunctionLine() {
        if (this.getCallerFunctionName() == null || this.getCallerFunctionName().equals("")) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getCallerFunctionName()) + '(');
        Expression[] variables = this.getVariables();
        int i = 0;
        while (i < variables.length) {
            Expression expression = variables[i];
            buffer.append(" $");
            buffer.append(expression.getLastName());
            if (i != variables.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        buffer.append(" )");
        return buffer.toString();
    }

    private static class DefaultStackVariable
    extends DefaultExpression
    implements StackVariable {
        private int stackDepth;

        DefaultStackVariable(String name, int stackDepth) {
            super(name);
            this.stackDepth = stackDepth;
        }

        public int getStackDepth() {
            return this.stackDepth;
        }

        public Expression createChildExpression(String endName, String endRepresentation) {
            return new DefaultStackVariable(this, endName, this.stackDepth, endRepresentation);
        }

        private DefaultStackVariable(StackVariable parent, String name, int stackDepth, String representation) {
            super(parent, name, representation);
            this.stackDepth = stackDepth;
        }
    }
}

