/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.documentModel.dom.TextImplForPhp;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPElementContainmentAdapter;
import org.eclipse.php.internal.ui.PHPElementProperties;
import org.eclipse.php.internal.ui.PHPElementResourceMapping;
import org.eclipse.php.internal.ui.PHPWorkbenchAdapter;
import org.eclipse.php.internal.ui.search.PHPSearchPage;
import org.eclipse.php.internal.ui.search.SearchUtil;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public class PHPElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter,
IContributorResourceAdapter2 {
    private static Class[] PROPERTIES = new Class[]{IPropertySource.class, IResource.class, IWorkbenchAdapter.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class};
    private Object fSearchPageScoreComputer;
    private static PHPWorkbenchAdapter fgJavaWorkbenchAdapter;
    private static ITaskListResourceAdapter fgTaskListAdapter;
    private static PHPElementContainmentAdapter fgJavaElementContainmentAdapter;

    public Class[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        if ((element instanceof ElementImplForPhp || element instanceof TextImplForPhp) && key == ISearchPageScoreComputer.class) {
            if (this.fSearchPageScoreComputer == null) {
                this.createSearchPageScoreComputer();
            }
            return this.fSearchPageScoreComputer;
        }
        Object phpElement = this.getPHPElement(element);
        if (IPropertySource.class.equals((Object)key)) {
            return this.getProperties(phpElement);
        }
        if (IResource.class.equals((Object)key)) {
            return this.getResource(phpElement);
        }
        if (IWorkbenchAdapter.class.equals((Object)key)) {
            return PHPElementAdapterFactory.getJavaWorkbenchAdapter();
        }
        if (IContributorResourceAdapter.class.equals((Object)key)) {
            return this;
        }
        if (IContributorResourceAdapter2.class.equals((Object)key)) {
            return this;
        }
        if (IContainmentAdapter.class.equals((Object)key)) {
            return PHPElementAdapterFactory.getJavaElementContainmentAdapter();
        }
        return null;
    }

    private IResource getResource(Object element) {
        return PHPModelUtil.getResource((Object)element);
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        Object je = this.getPHPElement(adaptable);
        if (je instanceof PHPFileData) {
            return this.getResource(je);
        }
        return null;
    }

    public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
        Object je = this.getPHPElement(adaptable);
        if (je != null) {
            return PHPElementResourceMapping.create(je);
        }
        return null;
    }

    private Object getPHPElement(Object element) {
        if (element instanceof PHPCodeData || element instanceof PHPProjectModel || element instanceof PHPWorkspaceModelManager) {
            return element;
        }
        return null;
    }

    private IPropertySource getProperties(Object element) {
        IResource resource = this.getResource(element);
        if (resource == null && element instanceof PHPCodeData) {
            return new PHPElementProperties((PHPCodeData)element);
        }
        if (resource.getType() == 1) {
            return new FilePropertySource((IFile)resource);
        }
        return new ResourcePropertySource(resource);
    }

    private static PHPWorkbenchAdapter getJavaWorkbenchAdapter() {
        if (fgJavaWorkbenchAdapter == null) {
            fgJavaWorkbenchAdapter = new PHPWorkbenchAdapter();
        }
        return fgJavaWorkbenchAdapter;
    }

    private static PHPElementContainmentAdapter getJavaElementContainmentAdapter() {
        if (fgJavaElementContainmentAdapter == null) {
            fgJavaElementContainmentAdapter = new PHPElementContainmentAdapter();
        }
        return fgJavaElementContainmentAdapter;
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new PHPSearchPageScoreComputer();
    }

    public static class PHPSearchPageScoreComputer
    implements ISearchPageScoreComputer {
        public int computeScore(String id, Object element) {
            if (!PHPSearchPage.EXTENSION_POINT_ID.equals(id)) {
                return -1;
            }
            if (element instanceof ElementImplForPhp || element instanceof TextImplForPhp) {
                return 90;
            }
            return 0;
        }
    }
}

