/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.ui.IContainmentAdapter;

public class PHPElementContainmentAdapter
implements IContainmentAdapter {
    private PHPWorkspaceModelManager fModel = PHPWorkspaceModelManager.getInstance();

    public boolean contains(Object workingSetElement, Object element, int flags) {
        if (!(workingSetElement instanceof PHPCodeData) && !(workingSetElement instanceof PHPWorkspaceModelManager) && !(workingSetElement instanceof PHPProjectModel) || element == null) {
            return false;
        }
        IResource resource = null;
        Object jElement = null;
        if (workingSetElement instanceof PHPCodeData || workingSetElement instanceof PHPWorkspaceModelManager || workingSetElement instanceof PHPProjectModel) {
            jElement = element;
            resource = PHPModelUtil.getResource((Object)element);
        } else if (element instanceof IAdaptable) {
            resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        if (jElement != null) {
            if (this.containsElement(workingSetElement, jElement, flags)) {
                return true;
            }
        } else if (resource != null) {
            return this.containsResource(workingSetElement, resource, flags);
        }
        return false;
    }

    private boolean containsElement(Object workingSetElement, Object element, int flags) {
        if (this.checkContext(flags) && workingSetElement.equals(element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetElement.equals(PHPModelUtil.getParent((Object)element))) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetElement, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetElement);
    }

    private boolean check(Object ancestor, Object descendent) {
        descendent = PHPModelUtil.getParent((Object)descendent);
        while (descendent != null) {
            if (ancestor.equals(descendent)) {
                return true;
            }
            descendent = PHPModelUtil.getParent((Object)descendent);
        }
        return false;
    }

    private boolean isChild(Object workingSetElement, IResource element) {
        IResource resource = PHPModelUtil.getResource((Object)workingSetElement);
        if (resource == null) {
            return false;
        }
        return this.check(element, resource);
    }

    private boolean containsResource(Object workingSetElement, IResource element, int flags) {
        IResource workingSetResource = PHPModelUtil.getResource((Object)workingSetElement);
        if (workingSetResource == null) {
            return false;
        }
        if (this.checkContext(flags) && workingSetResource.equals((Object)element)) {
            return true;
        }
        if (this.checkIfChild(flags) && workingSetResource.equals((Object)element.getParent())) {
            return true;
        }
        if (this.checkIfDescendant(flags) && this.check(workingSetResource, element)) {
            return true;
        }
        return this.checkIfAncestor(flags) && this.check(element, workingSetResource);
    }

    private boolean check(IResource ancestor, IResource descendent) {
        descendent = descendent.getParent();
        while (descendent != null) {
            if (ancestor.equals((Object)descendent)) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    private boolean checkIfDescendant(int flags) {
        return (flags & 8) != 0;
    }

    private boolean checkIfAncestor(int flags) {
        return (flags & 4) != 0;
    }

    private boolean checkIfChild(int flags) {
        return (flags & 2) != 0;
    }

    private boolean checkContext(int flags) {
        return (flags & 1) != 0;
    }
}

