/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;

public class StandardPHPElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected IPHPTreeContentProvider[] treeProviders;

    public StandardPHPElementContentProvider() {
        this(false);
    }

    public StandardPHPElementContentProvider(boolean provideMembers) {
        this.fProvideMembers = provideMembers;
    }

    public final Object[] getChildren(Object parentElement) {
        Object[] children = this.getChildrenInternal(parentElement);
        if (this.treeProviders != null) {
            int i = 0;
            while (i < this.treeProviders.length) {
                Object[] subChildren = this.treeProviders[i].getChildren(parentElement);
                if (subChildren != null && subChildren.length > 0) {
                    children = StandardPHPElementContentProvider.concatenate(children, subChildren);
                }
                ++i;
            }
        }
        return children;
    }

    public void setTreeProviders(IPHPTreeContentProvider[] providers) {
        this.treeProviders = providers;
    }

    protected Object[] getChildrenInternal(Object parentElement) {
        if (!this.exists(parentElement)) {
            return NO_CHILDREN;
        }
        if (parentElement instanceof PHPWorkspaceModelManager) {
            return this.getPHPProjects((PHPWorkspaceModelManager)parentElement);
        }
        if (parentElement instanceof IProject) {
            return this.getProjectChildren((IProject)parentElement);
        }
        if (parentElement instanceof PHPProjectModel) {
            return this.getProjectChildren((PHPProjectModel)parentElement);
        }
        if (parentElement instanceof IContainer) {
            return this.getFolderChildren((IContainer)parentElement, null);
        }
        if (parentElement instanceof IFile) {
            return this.getFileChildren((IFile)parentElement);
        }
        if (parentElement instanceof PHPFileData) {
            return this.getFileChildren((PHPFileData)parentElement);
        }
        if (parentElement instanceof PHPClassData) {
            return this.getClassChildren((PHPClassData)parentElement);
        }
        return NO_CHILDREN;
    }

    protected Object[] getFileChildren(IFile parentElement) {
        PHPFileData fileData;
        IFile file = parentElement;
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(file.getProject());
        if (projectModel != null && (fileData = projectModel.getFileData(file.getFullPath().toString())) != null) {
            return this.getFileChildren(fileData);
        }
        return NO_CHILDREN;
    }

    protected Object[] getFileChildren(PHPFileData fileData) {
        PHPFunctionData[] functions;
        PHPClassData[] classData;
        PHPConstantData[] consts;
        ArrayList<Object> list = new ArrayList<Object>();
        PHPIncludeFileData[] includes = fileData.getIncludeFiles();
        if (includes != null) {
            int i = 0;
            while (i < includes.length) {
                list.add(includes[i]);
                ++i;
            }
        }
        if ((consts = fileData.getConstants()) != null) {
            int i = 0;
            while (i < consts.length) {
                list.add(consts[i]);
                ++i;
            }
        }
        if ((classData = fileData.getClasses()) != null) {
            int i = 0;
            while (i < classData.length) {
                list.add(classData[i]);
                ++i;
            }
        }
        if ((functions = fileData.getFunctions()) != null) {
            int i = 0;
            while (i < functions.length) {
                list.add(functions[i]);
                ++i;
            }
        }
        return list.toArray();
    }

    protected Object[] getClassChildren(PHPClassData classData) {
        PHPClassConstData[] consts;
        PHPClassVarData[] vars;
        ArrayList<Object> list = new ArrayList<Object>();
        PHPFunctionData[] functions = classData.getFunctions();
        if (functions != null) {
            int i = 0;
            while (i < functions.length) {
                list.add(functions[i]);
                ++i;
            }
        }
        if ((vars = classData.getVars()) != null) {
            int i = 0;
            while (i < vars.length) {
                list.add(vars[i]);
                ++i;
            }
        }
        if ((consts = classData.getConsts()) != null) {
            int i = 0;
            while (i < consts.length) {
                list.add(consts[i]);
                ++i;
            }
        }
        return list.toArray();
    }

    public final Object getParent(Object element) {
        Object parent = null;
        if (this.exists(element)) {
            parent = this.internalGetParent(element);
        }
        if (this.treeProviders != null) {
            int i = 0;
            while (i < this.treeProviders.length && parent == null) {
                parent = this.treeProviders[i].getParent(element);
                ++i;
            }
        }
        return parent;
    }

    public final boolean hasChildren(Object element) {
        boolean hasChildren = this.hasChildrenInternal(element);
        if (hasChildren) {
            return true;
        }
        if (this.treeProviders != null) {
            int i = 0;
            while (i < this.treeProviders.length) {
                hasChildren = this.treeProviders[i].hasChildren(element);
                if (hasChildren) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean hasChildrenInternal(Object element) {
        if (this.getProvideMembers()) {
            if (element instanceof PHPFileData) {
                return true;
            }
        } else if (element instanceof PHPFileData || element instanceof IFile) {
            return false;
        }
        if (element instanceof PHPProjectModel) {
            PHPProjectModel sp = (PHPProjectModel)element;
            IProject project = PHPWorkspaceModelManager.getInstance().getProjectForModel(sp);
            if (!project.isOpen()) {
                return false;
            }
        }
        if (element instanceof PHPCodeData) {
            PHPCodeData codeData = (PHPCodeData)element;
            return PHPModelUtil.hasChildren((PHPCodeData)codeData);
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.treeProviders != null) {
            int i = 0;
            while (i < this.treeProviders.length) {
                this.treeProviders[i].inputChanged(viewer, oldInput, newInput);
                ++i;
            }
        }
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        return true;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    protected Object[] getPHPProjects(PHPWorkspaceModelManager modelManager) {
        return modelManager.listProjects();
    }

    protected Object[] getProjectChildren(PHPProjectModel model) {
        IProject project = PHPWorkspaceModelManager.getInstance().getProjectForModel(model);
        return this.getProjectChildren(project);
    }

    protected Object[] getProjectChildren(PHPProjectModel model, String[] filterNames) {
        IProject project = PHPWorkspaceModelManager.getInstance().getProjectForModel(model);
        return this.getProjectChildren(project, filterNames);
    }

    protected Object[] getProjectChildren(IProject project) {
        String[] filterNames = new String[]{};
        return this.getProjectChildren(project, filterNames);
    }

    protected Object[] getProjectChildren(IProject project, String[] filterNames) {
        if (!project.isOpen()) {
            return NO_CHILDREN;
        }
        Object[] children = this.getFolderChildren((IContainer)project, filterNames);
        return children;
    }

    protected boolean isProjectRoot(IContainer root) {
        return root instanceof IProject;
    }

    protected Object[] getFolderChildren(IContainer folder, String[] filterNames) {
        try {
            Object[] members = folder.members();
            IProject project = folder.getProject();
            PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
            if (projectModel == null) {
                return members;
            }
            if (!project.exists()) {
                return members;
            }
            ArrayList<Object> folderList = new ArrayList<Object>();
            ArrayList<Object> fileList = new ArrayList<Object>();
            int i = 0;
            while (i < members.length) {
                Object member = members[i];
                boolean filterOut = false;
                if (filterNames != null) {
                    int j = 0;
                    while (j < filterNames.length) {
                        if (filterNames[j].equals(member.getName())) {
                            filterOut = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!filterOut) {
                    if (member instanceof IFolder) {
                        folderList.add(member);
                    } else if (member instanceof IFile) {
                        fileList.add(members[i]);
                    }
                }
                ++i;
            }
            folderList.addAll(fileList);
            return folderList.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected Object internalGetParent(Object element) {
        return PHPModelUtil.getParent((Object)element);
    }

    protected Object skipProjectRoot(IFolder root) {
        if (this.isProjectRoot((IContainer)root)) {
            return root.getParent();
        }
        return root;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }

    protected boolean isSourceFolderEmpty(Object element) {
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            try {
                if (folder.exists() && folder.members().length == 0) {
                    return true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }
}

