/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.LinkedList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.ui.IWorkbenchSite;

public class ConvertToPDTProjectAction
extends SelectionDispatchAction {
    private static final String PHPECLIPSE_NATURE = "net.sourceforge.phpeclipse.phpnature";
    private static final String PHPECLIPSE_BUILDER = "net.sourceforge.phpeclipse.parserbuilder";
    private IProject[] selectedProjects;

    public ConvertToPDTProjectAction(IWorkbenchSite site) {
        super(site);
        this.setText(PHPUIMessages.getString("ConvertToPDTProjectAction_convert_to_PDT_project_title"));
        this.setToolTipText(PHPUIMessages.getString("ConvertToPDTProjectAction_convert_to_PDT_project_tooltip"));
        this.setDescription(PHPUIMessages.getString("ConvertToPDTProjectAction_convert_to_PDT_project_description"));
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectedProjects = this.getProjectsFromSelection(selection);
        this.setEnabled(this.selectedProjects.length > 0);
    }

    private IProject[] getProjectsFromSelection(IStructuredSelection selection) {
        LinkedList<IProject> phpEclipseProjects = new LinkedList<IProject>();
        for (Object element : selection) {
            if (!(element instanceof IProject)) continue;
            IProject project = (IProject)element;
            try {
                if (!project.isOpen() || !project.hasNature(PHPECLIPSE_NATURE)) continue;
                phpEclipseProjects.add(project);
            }
            catch (CoreException coreException) {}
        }
        return phpEclipseProjects.toArray(new IProject[phpEclipseProjects.size()]);
    }

    public void run(IStructuredSelection selection) {
        final IProject[] projects = this.getProjectsFromSelection(selection);
        if (projects.length > 0) {
            WorkspaceJob convertJob = new WorkspaceJob(PHPUIMessages.getString("ConvertToPDTProjectAction_converting_project_job_title")){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < projects.length) {
                        IProject project = projects[i];
                        IProjectDescription projectDescription = project.getDescription();
                        LinkedList<ICommand> newBuildSpec = new LinkedList<ICommand>();
                        ICommand[] buildSpec = projectDescription.getBuildSpec();
                        int c = 0;
                        while (c < buildSpec.length) {
                            if (!buildSpec[c].getBuilderName().equals(ConvertToPDTProjectAction.PHPECLIPSE_BUILDER)) {
                                newBuildSpec.add(buildSpec[c]);
                            }
                            ++c;
                        }
                        ICommand command = projectDescription.newCommand();
                        command.setBuilderName("org.eclipse.php.core.ValidationManagerWrapper");
                        newBuildSpec.add(command);
                        command = projectDescription.newCommand();
                        command.setBuilderName("org.eclipse.php.core.PhpIncrementalProjectBuilder");
                        newBuildSpec.add(command);
                        projectDescription.setBuildSpec(newBuildSpec.toArray(new ICommand[newBuildSpec.size()]));
                        LinkedList<String> newNatures = new LinkedList<String>();
                        String[] natures = projectDescription.getNatureIds();
                        int c2 = 0;
                        while (c2 < natures.length) {
                            if (!natures[c2].equals(ConvertToPDTProjectAction.PHPECLIPSE_NATURE)) {
                                newNatures.add(natures[c2]);
                            }
                            ++c2;
                        }
                        newNatures.add("org.eclipse.php.core.PHPNature");
                        projectDescription.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
                        project.setDescription(projectDescription, monitor);
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            convertJob.setUser(true);
            convertJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            convertJob.schedule();
        }
    }
}

