/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.NewWizardMenu;

public class NewWizardsActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;

    public NewWizardsActionGroup(IWorkbenchSite site) {
        this.fSite = site;
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection sel;
        super.fillContextMenu(menu);
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() <= 1 && this.isNewTarget(sel.getFirstElement())) {
            MenuManager newMenu = new MenuManager(PHPUIMessages.getString("NewWizardsActionGroup_new"));
            menu.appendToGroup("group.new", (IContributionItem)newMenu);
            newMenu.add((IContributionItem)new NewWizardMenu(this.fSite.getWorkbenchWindow()));
        }
    }

    private boolean isNewTarget(Object element) {
        if (element == null) {
            return true;
        }
        if (element instanceof IResource) {
            return true;
        }
        if (element instanceof IFolder || element instanceof PHPProjectModel || element instanceof PHPClassData || element instanceof PHPFileData) {
            return true;
        }
        return element instanceof PHPFunctionData && ((PHPFunctionData)element).getContainer() instanceof PHPFileData;
    }
}

