/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.util.CodeDataResolver;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class PHPEditorResolvingAction
extends TextEditorAction {
    private CodeData[] fCodeDatas;

    public PHPEditorResolvingAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setEnabled(true);
    }

    public void run() {
        if (this.isValid()) {
            this.doRun();
        }
    }

    protected abstract void doRun();

    protected ITextSelection getCurrentSelection() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return null;
        }
        ISelectionProvider provider = editor.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection selection = provider.getSelection();
        if (selection instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected boolean isValid() {
        String partitionType;
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return false;
        }
        IDocumentProvider docProvider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        if (docProvider == null || input == null) {
            return false;
        }
        IDocument document = docProvider.getDocument((Object)input);
        if (document == null) {
            return false;
        }
        if (!(document instanceof IStructuredDocument)) {
            return false;
        }
        ITextSelection currentSelection = this.getCurrentSelection();
        int offset = currentSelection.getOffset();
        IStructuredDocument structuredDocument = (IStructuredDocument)document;
        try {
            partitionType = structuredDocument.getPartition(offset).getType();
        }
        catch (BadLocationException e1) {
            Logger.logException(e1);
            return false;
        }
        if (!partitionType.equals("org.eclipse.php.PHP_DEFAULT")) {
            return false;
        }
        IStructuredDocumentRegion structuredDocumentRegion = structuredDocument.getRegionAtCharacterOffset(offset);
        ITextRegion textRegion = structuredDocumentRegion.getRegionAtCharacterOffset(offset);
        if (textRegion == null) {
            return false;
        }
        if (textRegion.getType() == "PHP_CONTENT") {
            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)textRegion;
            try {
                textRegion = phpScriptRegion.getPhpToken(offset - structuredDocumentRegion.getStartOffset() - phpScriptRegion.getStart());
            }
            catch (BadLocationException badLocationException) {
                textRegion = null;
            }
        }
        if (textRegion == null) {
            return false;
        }
        CodeData[] codeDatas = CodeDataResolver.getInstance().resolve(structuredDocument, offset);
        this.fCodeDatas = this.filterCodeDatas(codeDatas);
        return this.fCodeDatas.length > 0;
    }

    protected abstract CodeData[] filterCodeDatas(CodeData[] var1);

    protected CodeData[] getCodeDatas() {
        return this.fCodeDatas;
    }
}

