/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.util.CollectionUtils;
import org.eclipse.php.internal.ui.util.ParentChecker;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.part.ResourceTransfer;

public class PasteAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;
    private Text fSelectedText;

    public PasteAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.setText(PHPUIMessages.getString("PasteAction_text"));
        this.setDescription(PHPUIMessages.getString("PasteAction_desc"));
        ISharedImages workbenchImages = PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.update(this.getSelection());
    }

    public void selectionChanged(IStructuredSelection selection) {
        boolean enabled = true;
        Object[] sels = selection.toArray();
        int i = 0;
        while (i < sels.length) {
            if (sels[i] instanceof PHPCodeData && !(sels[i] instanceof PHPFileData)) {
                enabled = false;
            }
            ++i;
        }
        this.setEnabled(enabled);
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] result = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = clipboard.getContents(transfer);
            }
        });
        return result[0];
    }

    private static boolean isAvailable(Transfer transfer, TransferData[] availableDataTypes) {
        int i = 0;
        while (i < availableDataTypes.length) {
            if (transfer.isSupportedType(availableDataTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
        try {
            TransferData[] availableTypes = this.fClipboard.getAvailableTypes();
            List elements = selection.toList();
            IResource[] resources = ActionUtils.getResources(elements, true);
            Object[] phpElements = ActionUtils.getPHPElements(elements, true);
            Paster[] pasters = this.createEnabledPasters(availableTypes);
            int i = 0;
            while (i < pasters.length) {
                if (pasters[i].canPasteOn(phpElements, resources)) {
                    pasters[i].paste(phpElements, resources, availableTypes);
                    return;
                }
                ++i;
            }
            MessageDialog.openError((Shell)PHPUiPlugin.getActiveWorkbenchShell(), (String)PHPUIMessages.getString("RefactoringAction_refactoring"), (String)PHPUIMessages.getString("RefactoringAction_disabled"));
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e);
        }
        catch (InvocationTargetException e) {
            PHPUiPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private Paster[] createEnabledPasters(TransferData[] availableDataTypes) throws CoreException {
        Shell shell = this.getShell();
        ArrayList<Paster> result = new ArrayList<Paster>(2);
        Paster paster = new ProjectPaster(shell, this.fClipboard);
        if (paster.canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new PHPElementAndResourcePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new FilePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if (this.fSelectedText != null && (paster = new ResourceNameTextPaster(shell, this.fClipboard, this.fSelectedText)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        return result.toArray(new Paster[result.size()]);
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof Text) {
            Text text;
            this.fSelectedText = text = (Text)event.widget;
        }
        this.run();
    }

    private static class FilePaster
    extends Paster {
        protected FilePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(Object[] phpElements, IResource[] resources, TransferData[] availableTypes) throws CoreException {
            ResourceTransfer.getInstance();
            IResource[] resourceData = this.getClipboardResources(availableTypes);
            if (resourceData != null && resourceData.length > 0) {
                if (resourceData[0].getType() == 4) {
                    int i = 0;
                    while (i < resourceData.length) {
                        CopyProjectOperation operation = new CopyProjectOperation(this.getShell());
                        operation.copyProject((IProject)resourceData[i]);
                        ++i;
                    }
                } else {
                    IContainer container = this.getAsContainer(this.getTarget(phpElements, resources));
                    CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
                    operation.copyResources(resourceData, container);
                }
                return;
            }
            FileTransfer.getInstance();
            String[] fileData = this.getClipboardFiles(availableTypes);
            if (fileData != null) {
                IContainer container = this.getAsContainer(this.getTarget(phpElements, resources));
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
                operation.copyFiles(fileData, container);
            }
        }

        private String[] getClipboardFiles(TransferData[] availableDataTypes) {
            FileTransfer transfer = FileTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (String[])PasteAction.getContents(this.getClipboard(), (Transfer)transfer, this.getShell());
            }
            return null;
        }

        private Object getTarget(Object[] phpElements, IResource[] resources) {
            if (phpElements.length + resources.length == 1) {
                if (phpElements.length == 1) {
                    return phpElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(phpElements, resources);
        }

        public boolean canPasteOn(Object[] phpElements, IResource[] resources) throws CoreException {
            Object target = this.getTarget(phpElements, resources);
            return target != null && this.canPasteFilesOn(this.getAsContainer(target));
        }

        public boolean canEnable(TransferData[] availableDataTypes) throws CoreException {
            return PasteAction.isAvailable((Transfer)FileTransfer.getInstance(), availableDataTypes);
        }

        private boolean canPasteFilesOn(Object target) {
            return target instanceof IContainer;
        }

        private IContainer getAsContainer(Object target) throws CoreException {
            if (target == null) {
                return null;
            }
            if (target instanceof IContainer) {
                return (IContainer)target;
            }
            if (target instanceof IFile) {
                return ((IFile)target).getParent();
            }
            return null;
        }

        private Object getCommonParent(Object[] phpElements, IResource[] resources) {
            return new ParentChecker(resources, (PHPCodeData[])phpElements).getCommonParent();
        }
    }

    private static class PHPElementAndResourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected PHPElementAndResourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(Object[] phpElements, IResource[] resources, TransferData[] availableTypes) throws CoreException, InterruptedException, InvocationTargetException {
            Object destination;
            Object[] clipboardPHPElements;
            IResource[] clipboardResources = this.getClipboardResources(availableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardPHPElements = this.getClipboardPHPElements(availableTypes)) == null) {
                clipboardPHPElements = new Object[]{};
            }
            if ((destination = this.getTarget(phpElements, resources)) instanceof PHPCodeData) {
                this.pasteToPHP(clipboardPHPElements, clipboardResources, (PHPCodeData)destination);
            } else if (destination instanceof IResource) {
                this.pasteToResource(clipboardPHPElements, clipboardResources, (IResource)destination);
            }
        }

        private void pasteToResource(Object[] clipboardPHPElements, IResource[] clipboardResources, IResource resource) {
            new CopyFilesAndFoldersOperation(this.getShell()).copyResources(clipboardResources, (IContainer)resource);
        }

        private void pasteToPHP(Object[] clipboardPHPElements, IResource[] clipboardResources, PHPCodeData data) {
        }

        private Object getTarget(Object[] phpElements, IResource[] resources) {
            if (phpElements.length + resources.length == 1) {
                if (phpElements.length == 1) {
                    return phpElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(phpElements, resources);
        }

        private Object getCommonParent(Object[] phpElements, IResource[] resources) {
            return new ParentChecker(resources, (PHPCodeData[])phpElements).getCommonParent();
        }

        public boolean canPasteOn(Object[] phpElements, IResource[] resources) throws CoreException {
            Object destination;
            Object[] clipboardPHPElements;
            IResource[] clipboardResources = this.getClipboardResources(this.fAvailableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardPHPElements = this.getClipboardPHPElements(this.fAvailableTypes)) == null) {
                clipboardPHPElements = new Object[]{};
            }
            if ((destination = this.getTarget(phpElements, resources)) instanceof PHPCodeData) {
                return this.canPasteElement(clipboardPHPElements, clipboardResources, (PHPCodeData)destination);
            }
            if (destination instanceof IResource) {
                return this.canPasteResource(clipboardPHPElements, clipboardResources, (IResource)destination);
            }
            return false;
        }

        public boolean canPasteResource(Object[] clipboardPHPElements, IResource[] clipboardResources, IResource resource) {
            if (!(resource instanceof IContainer)) {
                return false;
            }
            int i = 0;
            while (i < clipboardResources.length) {
                if (!(clipboardResources[i] instanceof IFile) && !(clipboardResources[i] instanceof IFolder)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean canPasteElement(Object[] clipboardPHPElements, IResource[] clipboardResources, PHPCodeData data) {
            return false;
        }

        public boolean canEnable(TransferData[] availableTypes) {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableTypes);
        }
    }

    private static abstract class Paster {
        private final Shell fShell;
        private final Clipboard fClipboard2;
        static final PHPCodeData[] EMPTY_PHPELEMENTS = new PHPCodeData[0];

        protected Paster(Shell shell, Clipboard clipboard) {
            this.fShell = shell;
            this.fClipboard2 = clipboard;
        }

        protected final Shell getShell() {
            return this.fShell;
        }

        protected final Clipboard getClipboard() {
            return this.fClipboard2;
        }

        protected final IResource[] getClipboardResources(TransferData[] availableDataTypes) {
            ResourceTransfer transfer = ResourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IResource[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final PHPCodeData[] getClipboardPHPElements(TransferData[] availableDataTypes) {
            return EMPTY_PHPELEMENTS;
        }

        public abstract void paste(Object[] var1, IResource[] var2, TransferData[] var3) throws CoreException, InterruptedException, InvocationTargetException;

        public abstract boolean canEnable(TransferData[] var1) throws CoreException;

        public abstract boolean canPasteOn(Object[] var1, IResource[] var2) throws CoreException;
    }

    private static class ProjectPaster
    extends Paster {
        protected ProjectPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] availableDataTypes) {
            boolean resourceTransfer = PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableDataTypes);
            boolean phpElementTransfer = false;
            if (!phpElementTransfer) {
                return this.canPasteSimpleProjects(availableDataTypes);
            }
            if (!resourceTransfer) {
                return false;
            }
            return this.canPasteSimpleProjects(availableDataTypes);
        }

        public void paste(Object[] phpElements, IResource[] resources, TransferData[] availableTypes) {
            this.pasteProjects(availableTypes);
        }

        private void pasteProjects(TransferData[] availableTypes) {
            this.pasteProjects(this.getProjectsToPaste(availableTypes));
        }

        private void pasteProjects(IProject[] projects) {
            Shell shell = this.getShell();
            int i = 0;
            while (i < projects.length) {
                new CopyProjectOperation(shell).copyProject(projects[i]);
                ++i;
            }
        }

        private IProject[] getProjectsToPaste(TransferData[] availableTypes) {
            IResource[] resources = this.getClipboardResources(availableTypes);
            PHPCodeData[] phpElements = this.getClipboardPHPElements(availableTypes);
            HashSet result = new HashSet();
            if (resources != null) {
                result.addAll(Arrays.asList(resources));
            }
            if (phpElements != null) {
                result.addAll(Arrays.asList(CollectionUtils.getNotNulls(CollectionUtils.getResources(phpElements))));
            }
            Assert.isTrue((result.size() > 0 ? 1 : 0) != 0);
            return result.toArray(new IProject[result.size()]);
        }

        public boolean canPasteOn(Object[] phpElements, IResource[] resources) {
            return true;
        }

        private boolean canPasteSimpleProjects(TransferData[] availableDataTypes) {
            IResource[] resources = this.getClipboardResources(availableDataTypes);
            if (resources == null || resources.length == 0) {
                return false;
            }
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() != 4 || !((IProject)resources[i]).isOpen()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class ResourceNameTextPaster
    extends Paster {
        private final Text textWidget;

        protected ResourceNameTextPaster(Shell shell, Clipboard clipboard, Text textWidget) {
            super(shell, clipboard);
            this.textWidget = textWidget;
        }

        public void paste(Object[] phpElements, IResource[] resources, TransferData[] availableTypes) throws CoreException {
            this.textWidget.paste();
        }

        public boolean canPasteOn(Object[] phpElements, IResource[] resources) throws CoreException {
            return true;
        }

        public boolean canEnable(TransferData[] availableDataTypes) throws CoreException {
            return PasteAction.isAvailable((Transfer)TextTransfer.getInstance(), availableDataTypes);
        }
    }
}

