/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.ui.IWorkbenchSite;

public class RemoveFromIncludePathAction
extends SelectionDispatchAction {
    public RemoveFromIncludePathAction(IWorkbenchSite site) {
        super(site);
        this.setText(PHPUIMessages.getString("RemoveFromIncludePathAction_remove_from_include_path_title"));
        this.setToolTipText(PHPUIMessages.getString("RemoveFromIncludePathAction_remove_from_include_path_tooltip"));
        this.setDescription(PHPUIMessages.getString("RemoveFromIncludePathAction_remove_from_include_path_desc"));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Object obj = selection.getFirstElement();
        return obj instanceof PHPIncludePathModel;
    }

    public void run(IStructuredSelection selection) {
        Object obj = selection.getFirstElement();
        if (obj instanceof PHPIncludePathModel) {
            IProject project = null;
            final PHPIncludePathModel includePathModel = (PHPIncludePathModel)obj;
            PHPProjectModel[] projectModels = PHPWorkspaceModelManager.getInstance().listModels();
            int i = 0;
            while (project == null && i < projectModels.length) {
                PHPIncludePathModelManager includePathModelManager = (PHPIncludePathModelManager)projectModels[i].getModel("CompositeIncludePathModel");
                if (includePathModelManager != null) {
                    IPhpModel[] models = includePathModelManager.listModels();
                    int j = 0;
                    while (project == null && j < models.length) {
                        if (models[j] == includePathModel) {
                            project = PHPWorkspaceModelManager.getInstance().getProjectForModel(projectModels[i]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (project != null) {
                final PHPProjectOptions options = PHPProjectOptions.forProject(project);
                WorkspaceJob configureIncludePathJob = new WorkspaceJob(PHPUIMessages.getString("RemoveFromIncludePathAction_remove_from_include_path_job")){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        IIncludePathEntry[] includePathEntries = options.readRawIncludePath();
                        LinkedList<IIncludePathEntry> newIncludePathEntries = new LinkedList<IIncludePathEntry>();
                        int i = 0;
                        while (i < includePathEntries.length) {
                            if (!includePathEntries[i].getPath().equals((Object)new Path(includePathModel.getID()))) {
                                newIncludePathEntries.add(includePathEntries[i]);
                            }
                            ++i;
                        }
                        options.setRawIncludePath(newIncludePathEntries.toArray(new IIncludePathEntry[newIncludePathEntries.size()]), new SubProgressMonitor(monitor, 1));
                        return Status.OK_STATUS;
                    }
                };
                configureIncludePathJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(project));
                configureIncludePathJob.schedule();
            }
        }
    }
}

