/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.openType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeFilter;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeFilterComposite;
import org.eclipse.php.internal.ui.dialogs.openType.PhpTypeTableLabelProvider;
import org.eclipse.php.internal.ui.dialogs.openType.generic.BasicSelector;
import org.eclipse.php.internal.ui.dialogs.openType.generic.CompositeFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenPhpElementDialog
extends Dialog {
    private PHPCodeData selectedElement = null;
    private BasicSelector basicSelector;
    private CodeData[] initialElements;
    private String initFilterText;
    private final PhpTypeFilter phpTypeFilter = new PhpTypeFilter();
    private String title;

    public OpenPhpElementDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public OpenPhpElementDialog(Shell parentShell, String title) {
        this(parentShell);
        this.title = title;
    }

    protected Point getInitialSize() {
        return this.getShell().computeSize(500, 400, true);
    }

    public void setInitialElements(CodeData[] initialElements) {
        this.initialElements = initialElements;
    }

    public void setInitFilterText(String initFilterText) {
        this.initFilterText = initFilterText;
    }

    public PhpTypeFilter getFilter() {
        return this.phpTypeFilter;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.opening_php_elements");
        Composite composite = (Composite)super.createDialogArea(parent);
        CompositeFactory phpTypeFilterCompositeFactory = new CompositeFactory(){

            public Composite createComposite(Composite parent) {
                return new PhpTypeFilterComposite(parent, OpenPhpElementDialog.this.phpTypeFilter, OpenPhpElementDialog.this.phpTypeFilter);
            }
        };
        this.basicSelector = new BasicSelector(composite, phpTypeFilterCompositeFactory);
        if (this.initFilterText != null) {
            this.basicSelector.setInitFilterText(this.initFilterText);
        }
        this.basicSelector.setLayoutData(new GridData(1808));
        this.basicSelector.addFilter(this.phpTypeFilter);
        this.basicSelector.setLabelProvider(new PhpTypeTableLabelProvider());
        this.basicSelector.setElements(this.getElements());
        this.basicSelector.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OpenPhpElementDialog.this.okPressed();
            }
        });
        this.basicSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    OpenPhpElementDialog.this.getButton(0).setEnabled(false);
                    return;
                }
                OpenPhpElementDialog.this.getButton(0).setEnabled(true);
            }
        });
        return composite;
    }

    private Object[] getElements() {
        CodeData[] elements;
        block9: {
            IProject[] projects;
            elements = this.initialElements;
            if (elements != null) break block9;
            LinkedHashSet arrayList = new LinkedHashSet();
            IProject[] iProjectArray = projects = PHPUiPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    IProject project;
                    block8: {
                        project = iProjectArray[n2];
                        try {
                            if (!project.exists() || !project.isOpen()) break block7;
                            if (!project.hasNature("org.eclipse.php.core.PHPNature")) {
                            }
                            break block8;
                        }
                        catch (CoreException ce) {
                            ce.printStackTrace();
                        }
                        break block7;
                    }
                    PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
                    if (projectModel != null) {
                        IPhpModel[] models = projectModel.getModels();
                        IPHPLanguageModel languageModel = projectModel.getPHPLanguageModel();
                        int j = 0;
                        while (j < models.length) {
                            IPhpModel model = models[j];
                            if (model != languageModel) {
                                this.addData(model.getClasses(), arrayList);
                                this.addData(model.getFunctions(), arrayList);
                                this.addData(model.getConstants(), arrayList);
                            }
                            ++j;
                        }
                    }
                }
                ++n2;
            }
            elements = arrayList.toArray(new CodeData[arrayList.size()]);
        }
        return this.sortAndremoveDuplicates(elements);
    }

    private Object[] sortAndremoveDuplicates(CodeData[] elements) {
        if (elements.length == 0) {
            return new Object[0];
        }
        Comparator<CodeData> comparator = new Comparator<CodeData>(){

            @Override
            public int compare(CodeData arg0, CodeData arg1) {
                return arg0.toString().compareToIgnoreCase(arg1.toString());
            }
        };
        Arrays.sort(elements, comparator);
        CodeData last = elements[0];
        ArrayList<CodeData> result = new ArrayList<CodeData>();
        result.add(last);
        CodeData[] codeDataArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData codeData = codeDataArray[n2];
            if (!this.equals(last, codeData)) {
                result.add(codeData);
            }
            last = codeData;
            ++n2;
        }
        return result.toArray();
    }

    private boolean equals(CodeData o1, CodeData o2) {
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (!o1.getName().equalsIgnoreCase(o1.getName())) {
            return false;
        }
        String fileName1 = PHPModelUtil.getPHPFileContainer((PHPCodeData)((PHPCodeData)o1)).getName();
        String fileName2 = PHPModelUtil.getPHPFileContainer((PHPCodeData)((PHPCodeData)o2)).getName();
        return fileName1.equals(fileName2);
    }

    private void addData(CodeData[] classes, Collection arrayList) {
        CodeData[] codeDataArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData codeData = codeDataArray[n2];
            arrayList.add(codeData);
            ++n2;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title != null ? this.title : PHPUIMessages.getString("OpenType_DialogTitle"));
    }

    public PHPCodeData getSelectedElement() {
        return this.selectedElement;
    }

    protected void okPressed() {
        this.selectedElement = (PHPCodeData)this.basicSelector.getSelectedElement();
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public boolean close() {
        this.basicSelector.close();
        return super.close();
    }
}

