/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.openType;

import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.dialogs.openType.filter.IPhpTypeFilterReadModel;
import org.eclipse.php.internal.ui.dialogs.openType.filter.IPhpTypeFilterWriteModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PhpTypeFilterComposite
extends Composite {
    private Button classesButton;
    private Button functionsButton;
    private Button constantsButton;
    private IPhpTypeFilterWriteModel phpTypeFilterWriteModel;
    private IPhpTypeFilterReadModel phpTypeFilterReadModel;

    private PhpTypeFilterComposite(Composite parent, int style, IPhpTypeFilterWriteModel typeFilterWriteModel, IPhpTypeFilterReadModel phpTypeFilterReadModel) {
        super(parent, style);
        this.setWriteModel(typeFilterWriteModel);
        this.setReadModel(phpTypeFilterReadModel);
        this.initialize();
    }

    public PhpTypeFilterComposite(Composite parent, IPhpTypeFilterWriteModel phpTypeFilterWriteModel, IPhpTypeFilterReadModel phpTypeFilterReadModel) {
        this(parent, 0, phpTypeFilterWriteModel, phpTypeFilterReadModel);
    }

    private void initialize() {
        FillLayout fillLayout = new FillLayout(512);
        this.setLayout((Layout)fillLayout);
        this.initControls();
        this.initActions();
    }

    private void initActions() {
        this.classesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PhpTypeFilterComposite.this.phpTypeFilterWriteModel.setSelectClasses(PhpTypeFilterComposite.this.classesButton.getSelection());
            }
        });
        this.functionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PhpTypeFilterComposite.this.phpTypeFilterWriteModel.setSelectFunctions(PhpTypeFilterComposite.this.functionsButton.getSelection());
            }
        });
        this.constantsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PhpTypeFilterComposite.this.phpTypeFilterWriteModel.setSelectConstants(PhpTypeFilterComposite.this.constantsButton.getSelection());
            }
        });
    }

    private void initControls() {
        Group group = new Group((Composite)this, 0);
        group.setText(PHPUIMessages.getString("OpenType_GroupFilterTitle"));
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginBottom = 0;
        rowLayout.marginHeight = 3;
        rowLayout.marginLeft = 5;
        rowLayout.marginRight = 0;
        rowLayout.marginTop = 0;
        rowLayout.marginWidth = 0;
        group.setLayout((Layout)rowLayout);
        rowLayout.wrap = false;
        this.createClassCheckBox((Composite)group);
        this.createFunctionsCheckBox((Composite)group);
        this.createConstantsCheckBox((Composite)group);
    }

    private void createConstantsCheckBox(Composite composite) {
        composite = this.createbuttonComposite(composite);
        this.constantsButton = new Button(composite, 32);
        this.constantsButton.setText(PHPUIMessages.getString("OpenType_ConstantsFilterCheckboxName"));
        this.constantsButton.setSelection(this.phpTypeFilterReadModel.getSelectConstants());
    }

    private void createFunctionsCheckBox(Composite composite) {
        composite = this.createbuttonComposite(composite);
        this.functionsButton = new Button(composite, 32);
        this.functionsButton.setText(PHPUIMessages.getString("OpenType_FunctionsFilterCheckboxName"));
        this.functionsButton.setSelection(this.phpTypeFilterReadModel.getSelectFunctions());
    }

    private void createClassCheckBox(Composite composite) {
        composite = this.createbuttonComposite(composite);
        this.classesButton = new Button(composite, 32);
        this.classesButton.setText(PHPUIMessages.getString("OpenType_ClassesFilterCheckboxName"));
        this.classesButton.setSelection(this.phpTypeFilterReadModel.getSelectClasss());
    }

    private Composite createbuttonComposite(Composite composite) {
        composite = new Composite(composite, 0);
        RowLayout rowLayout = new RowLayout();
        composite.setLayout((Layout)rowLayout);
        rowLayout.marginRight = 5;
        rowLayout.marginBottom = 0;
        rowLayout.marginHeight = 8;
        rowLayout.marginLeft = 5;
        rowLayout.marginTop = 0;
        rowLayout.marginWidth = 0;
        return composite;
    }

    public void setWriteModel(IPhpTypeFilterWriteModel phpTypeFilterWriteModel) {
        this.phpTypeFilterWriteModel = phpTypeFilterWriteModel;
    }

    private void setReadModel(IPhpTypeFilterReadModel phpTypeFilterReadModel) {
        this.phpTypeFilterReadModel = phpTypeFilterReadModel;
    }
}

