/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.dom.Utils;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class LinkingSelectionListener
implements ISelectionListener {
    private boolean resetEmptySelection;
    private TreeViewer viewer;

    protected ISelection createSelection(Object element) {
        StructuredSelection selection = new StructuredSelection(element);
        return selection;
    }

    protected Object computeSelectedElement(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
            return null;
        }
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() > 0) {
            Object firstElement = structuredSelection.getFirstElement();
            PHPCodeData codeData = null;
            if (firstElement instanceof NodeImpl) {
                IDOMDocument doc = (IDOMDocument)((NodeImpl)firstElement).getOwnerDocument();
                if (doc == null) {
                    return null;
                }
                IDOMModel model = doc.getModel();
                if (!(model instanceof DOMModelForPHP)) {
                    return null;
                }
                if (selection instanceof TextSelection) {
                    codeData = Utils.getPHPCodeData((NodeImpl)((NodeImpl)firstElement), (int)((TextSelection)selection).getOffset());
                }
            } else if (firstElement instanceof PHPCodeData) {
                codeData = (PHPCodeData)firstElement;
            }
            Object selectedElement = null;
            if (codeData != null) {
                IResource res;
                selectedElement = codeData instanceof PHPFileData ? ((res = PHPModelUtil.getResource((Object)codeData)) != null && res.getProject() != null && res.getProject().isAccessible() ? res : codeData) : codeData;
            }
            return selectedElement;
        }
        return null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object selectedElement = this.computeSelectedElement(part, selection);
        if (selectedElement != null) {
            UserData userData;
            if (selectedElement instanceof PHPCodeData && (userData = ((PHPCodeData)selectedElement).getUserData()) != null && ExternalFilesRegistry.getInstance().isEntryExist(new Path(userData.getFileName()).toOSString())) {
                return;
            }
            Object oldSelectedElement = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (selectedElement.equals(oldSelectedElement)) {
                return;
            }
            if (selectedElement instanceof IResource && selectedElement.equals(PHPModelUtil.getResource((Object)oldSelectedElement))) {
                return;
            }
            this.viewer.setSelection(this.createSelection(selectedElement), true);
        } else if (this.resetEmptySelection && !this.viewer.getSelection().isEmpty()) {
            this.viewer.setSelection(null);
        }
    }

    public void setResetEmptySelection(boolean resetEmptySelection) {
        this.resetEmptySelection = resetEmptySelection;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }
}

