/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.php.internal.core.phpModel.parser.CodeDataFilter;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.editor.contentassist.CodeDataCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.ContentAssistSupport;
import org.eclipse.php.internal.ui.editor.contentassist.PartialProposal;
import org.eclipse.php.internal.ui.editor.contentassist.TemporaryCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompletionProposalGroup {
    public static final String ELEMENT_NAME_SEPARATOR = "_";
    public static final String COLLAPSED_PREFIX = "...";
    public static final String COLLAPSED_SUFFIX = "*";
    public static final String PATH_SEPARATOR = Character.toString('/');
    private static final Path COMPLETION_TREE_ROOT = new Path("ROOT");
    protected int offset;
    protected CodeData[] codeDataProposals;
    protected ICompletionProposal[] completionProposals;
    protected String key;
    protected int segmentsToCut;
    protected int selectionLength;
    protected PHPProjectModel projectModel;
    protected boolean groupOptions;
    protected boolean cutCommonPrefix;

    public CompletionProposalGroup() {
        this.setData(0, null, null, this.selectionLength);
        this.setOffset(0);
    }

    public void setData(int offset, CodeData[] data, String key, int selectionLength, boolean isKeyStrict) {
        this.setOffset(offset);
        if (isKeyStrict) {
            ArrayList<CodeData> strictData = new ArrayList<CodeData>(1);
            int i = 0;
            while (i < data.length) {
                if (key.equalsIgnoreCase(data[i].getName())) {
                    strictData.add(data[i]);
                }
                ++i;
            }
            data = strictData.toArray(new CodeData[strictData.size()]);
        }
        this.setCodeDataProposals(data);
        this.key = key;
        if (key != null) {
            Path keyPath = CompletionProposalGroup.elementNameToPath(key);
            if (this.cutCommonPrefix) {
                this.segmentsToCut = keyPath.segmentCount();
                if (this.segmentsToCut > 0 && !keyPath.hasTrailingSeparator()) {
                    --this.segmentsToCut;
                }
            }
        }
        this.selectionLength = selectionLength;
    }

    public void setData(int offset, CodeData[] data, String key, int selectionLength) {
        this.setData(offset, data, key, selectionLength, false);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public CodeData[] getCodeDataProposals() {
        return this.codeDataProposals;
    }

    private void setCodeDataProposals(CodeData[] newProposals) {
        this.completionProposals = null;
        this.codeDataProposals = newProposals;
    }

    public ICompletionProposal[] getCompletionProposals(PHPProjectModel projectModel) {
        this.projectModel = projectModel;
        if (this.completionProposals == null) {
            ICompletionProposal[] iCompletionProposalArray = this.completionProposals = this.calcCompletionProposals(projectModel);
            int n = this.completionProposals.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionProposal proposal = iCompletionProposalArray[n2];
                if (proposal instanceof CodeDataCompletionProposal) {
                    ((CodeDataCompletionProposal)proposal).setOffset(this.offset);
                }
                ++n2;
            }
        }
        return this.completionProposals;
    }

    private ElementTree buildCompletionTree(PHPProjectModel model, CodeData[] codeDatas) {
        ElementTree tree = new ElementTree();
        CodeData[] codeDataArray = codeDatas;
        int n = codeDatas.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData element = codeDataArray[n2];
            String elementName = element.getName();
            Path namePath = CompletionProposalGroup.elementNameToPath(elementName);
            this.treeRecursiveCreateElement(model, tree, COMPLETION_TREE_ROOT.append((IPath)namePath), element);
            ++n2;
        }
        return tree;
    }

    private void treeRecursiveCreateElement(PHPProjectModel model, ElementTree tree, IPath path, CodeData data) {
        if (path.segmentCount() == 1 && !tree.includes(path)) {
            tree.createElement(path, (Object)data);
            return;
        }
        IPath parentPath = path.removeLastSegments(1);
        parentPath.removeLastSegments(1);
        if (!tree.includes(parentPath)) {
            this.treeRecursiveCreateElement(model, tree, parentPath, null);
        }
        if (!tree.includes(path)) {
            if (data != null) {
                tree.createElement(path, (Object)data);
            } else {
                tree.createElement(path, null);
            }
        } else if (data != null) {
            Object oldData = tree.getElementData(path);
            if (oldData instanceof LinkedHashSet) {
                ((LinkedHashSet)oldData).add(data);
            } else {
                LinkedHashSet<CodeData> newData = new LinkedHashSet<CodeData>(2);
                newData.add((CodeData)oldData);
                newData.add(data);
                tree.setElementData(path, newData);
            }
        }
    }

    private Collection<IPath> calculateProposalPaths(ElementTree completionTree, IPath root, boolean hasBrothers) {
        boolean allEqual;
        if (completionTree == null) {
            return null;
        }
        Collection originalPath = Arrays.asList(root);
        int childCount = completionTree.getChildCount(root);
        if (childCount == 0) {
            if (completionTree.getElementData(root) != null) {
                return originalPath;
            }
            return null;
        }
        IPath[] childrenRoots = completionTree.getChildren(root);
        boolean bl = allEqual = childCount > 1;
        if (allEqual) {
            int i = 0;
            while (i < childrenRoots.length) {
                if (i + 1 < childrenRoots.length && !childrenRoots[i].lastSegment().equalsIgnoreCase(childrenRoots[i + 1].lastSegment())) {
                    allEqual = false;
                    break;
                }
                ++i;
            }
        }
        if (childCount > 1 && hasBrothers) {
            return originalPath;
        }
        ArrayList<IPath> childCompletions = new ArrayList<IPath>();
        boolean childHasBrothers = childCount > 1 && !allEqual;
        IPath[] iPathArray = childrenRoots;
        int n = childrenRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPath childRoot = iPathArray[n2];
            Collection<IPath> childCompletionProposal = this.calculateProposalPaths(completionTree, childRoot, hasBrothers || childHasBrothers);
            if (childCompletionProposal != null) {
                childCompletions.addAll(childCompletionProposal);
            }
            ++n2;
        }
        return childCompletions;
    }

    protected ICompletionProposal[] calcCompletionProposals(PHPProjectModel projectModel) {
        if (this.codeDataProposals == null || this.codeDataProposals.length == 0) {
            return ContentAssistSupport.EMPTY_CodeDataCompletionProposal_ARRAY;
        }
        CodeData[] codeDatas = ModelSupport.getCodeDataStartingWith((CodeData[])this.codeDataProposals, (String)this.key);
        codeDatas = ModelSupport.removeFilteredCodeData((CodeData[])codeDatas, (CodeDataFilter)ModelSupport.INTERNAL_CODEDATA_FILTER);
        if (!this.groupOptions) {
            ICompletionProposal[] results = new ICompletionProposal[codeDatas.length];
            int i = 0;
            while (i < results.length) {
                results[i] = this.createElementProposal(projectModel, codeDatas[i]);
                ++i;
            }
            return results;
        }
        ElementTree completionTree = this.buildCompletionTree(projectModel, codeDatas);
        ArrayList<Object> proposals = new ArrayList<Object>(codeDatas.length);
        if (completionTree.getChildCount(completionTree.getRoot()) > 0) {
            Path root = COMPLETION_TREE_ROOT;
            Collection<IPath> completionProposalPaths = this.calculateProposalPaths(completionTree, (IPath)root, false);
            for (IPath completionProposalPath : completionProposalPaths) {
                Object elementData = completionTree.getElementData(completionProposalPath);
                Collection elementDatas = !(elementData instanceof Collection) ? (Collection)Arrays.asList((CodeData)elementData) : (Collection)elementData;
                for (CodeData currentData : elementDatas) {
                    if (currentData != null) {
                        proposals.add(this.createElementProposal(projectModel, currentData));
                        continue;
                    }
                    IPath replacementPath = completionProposalPath.removeFirstSegments(1);
                    String replacement = String.valueOf(CompletionProposalGroup.elementPathToName(replacementPath)) + ELEMENT_NAME_SEPARATOR;
                    proposals.add(this.createGroupProposal(completionProposalPath, replacement));
                }
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private CodeDataCompletionProposal createElementProposal(PHPProjectModel projectModel, Object elementData) {
        if (!this.cutCommonPrefix) {
            return this.createProposal(projectModel, (CodeData)elementData);
        }
        return new PartialProposal(this.createProposal(projectModel, (CodeData)elementData), this.segmentsToCut);
    }

    static String elementPathToName(IPath replacementPath) {
        return replacementPath.toString().replaceAll(PATH_SEPARATOR, ELEMENT_NAME_SEPARATOR);
    }

    static Path elementNameToPath(String elementName) {
        return new Path(elementName.replaceAll(ELEMENT_NAME_SEPARATOR, PATH_SEPARATOR));
    }

    private TemporaryCompletionProposal createGroupProposal(IPath completionProposalPath, String replacement) {
        return new TemporaryCompletionProposal((ICompletionProposal)new CompletionProposal(replacement, this.getOffset() - this.key.length(), this.key.length(), replacement.length(), null, String.valueOf(this.segmentsToCut > 0 ? "..._" : "") + CompletionProposalGroup.elementPathToName(completionProposalPath.removeFirstSegments(this.segmentsToCut + 1)) + ELEMENT_NAME_SEPARATOR + COLLAPSED_SUFFIX, null, null));
    }

    protected abstract CodeDataCompletionProposal createProposal(PHPProjectModel var1, CodeData var2);

    public void setGroupOptions(boolean groupCompletionOptions) {
        this.groupOptions = groupCompletionOptions;
    }

    public void setCutCommonPrefix(boolean cutCommonPrefix) {
        this.cutCommonPrefix = cutCommonPrefix;
    }
}

