/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.dom.Utils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.CodeDataFilter;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.util.Visitor;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.contentassist.CodeDataCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.CompletionProposalGroup;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionRendererVisitor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPProposalComperator;
import org.eclipse.php.internal.ui.editor.templates.PHPTemplateCompletionProcessor;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.editor.contentassist.IContentAssistSupport;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public class ContentAssistSupport
implements IContentAssistSupport {
    protected static final char[] phpDelimiters = new char[]{'?', ':', ';', '|', '^', '&', '<', '>', '+', '-', '.', '*', '/', '%', '!', '~', '[', ']', '(', ')', '{', '}', '@', '\n', '\t', ' ', ',', '$', '\'', '\"'};
    protected static final String CLASS_FUNCTIONS_TRIGGER = "::";
    protected static final String OBJECT_FUNCTIONS_TRIGGER = "->";
    private static final Pattern extendsPattern = Pattern.compile("\\Wextends\\W", 2);
    private static final Pattern implementsPattern = Pattern.compile("\\Wimplements", 2);
    private static final Pattern catchPattern = Pattern.compile("catch\\s[^{]*", 2);
    private static final Pattern globalPattern = Pattern.compile("\\$GLOBALS[\\s]*\\[[\\s]*[\\'\\\"][\\w]+[\\'\\\"][\\s]*\\]");
    public static final ICompletionProposal[] EMPTY_CompletionProposal_ARRAY = new ICompletionProposal[0];
    public static final CodeDataCompletionProposal[] EMPTY_CodeDataCompletionProposal_ARRAY = new CodeDataCompletionProposal[0];
    private static final PHPProposalComperator proposalsComperator = new PHPProposalComperator();
    private static final String[] CLASS_KEYWORDS = new String[]{"abstract", "const", "function", "final", "private", "protected", "public", "static", "var"};
    private static final Set<String> CLASS_KEYWORDS_SET = new HashSet<String>((Collection)Arrays.asList(CLASS_KEYWORDS));
    protected boolean showVariablesFromOtherFiles;
    protected boolean groupCompletionOptions;
    protected boolean cutCommonPrefix;
    public boolean determineObjectTypeFromOtherFile;
    protected boolean disableConstants;
    protected boolean showClassNamesInGlobalList;
    protected boolean showNonStrictOptions;
    protected boolean constantCaseSensitive;
    protected boolean autoShowVariables;
    protected boolean autoShowFunctionsKeywordsConstants;
    protected boolean autoShowClassNames;
    protected char[] autoActivationTriggers;
    private PHPTemplateCompletionProcessor templateCompletionProcessor;
    protected CompletionProposalGroup completionProposalGroup;
    protected ICompletionProposal[] templateProposals;
    protected CompletionProposalGroup phpCompletionProposalGroup = new PHPCompletionProposalGroup();
    protected CompletionProposalGroup regularPHPCompletionProposalGroup = new RegularPHPCompletionProposalGroup();
    protected CompletionProposalGroup classConstructorCompletionProposalGroup = new ClassConstructorCompletionProposalGroup();
    protected CompletionProposalGroup newStatementCompletionProposalGroup = new NewStatementCompletionProposalGroup();
    protected CompletionProposalGroup arrayCompletionProposalGroup = new ArrayCompletionProposalGroup();
    protected CompletionProposalGroup classStaticCallCompletionProposalGroup = new ClassStaticCallCompletionProposalGroup();
    protected CompletionProposalGroup classVariableCallCompletionProposalGroup = new ClassVariableCallCompletionProposalGroup();
    private static final PHPTagData[] phpTagDataArray = new PHPTagData[]{new PHPTagData()};
    protected CodeData[] extendedImplementCodeData;
    protected static CodeData[] implementCodeData;
    private static CodeData[] extendsCodeData;

    protected void initPreferences(String prefKey) {
        if (prefKey == null || "contentAssistShowVariablesFromOtherFiles".equals(prefKey) || "contentAssistShowConstantsAssist".equals(prefKey) || "contentAssistShowNonStrictOptions".equals(prefKey) || "contentAssistShowClassNamesInGlobalCompletion".equals(prefKey) || "contentAssistConstantsCaseSensitive".equals(prefKey) || "contentAssistDetermineObjTypeFromOtherFiles".equals(prefKey) || "contentAssistAutoactivationForClassNames".equals(prefKey) || "contentAssistAutoactivationForFunctionsKeyWordsConstants".equals(prefKey) || "contentAssistAutoactivationForVariables".equals(prefKey) || "contentAssistCutPrefix".equals(prefKey) || "contentAssistGroupOptions".equals(prefKey) || "contentAssistAutoactivationTriggersPHP".equals(prefKey)) {
            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
            this.showVariablesFromOtherFiles = preferenceStore.getBoolean("contentAssistShowVariablesFromOtherFiles");
            this.groupCompletionOptions = preferenceStore.getBoolean("contentAssistGroupOptions");
            this.cutCommonPrefix = preferenceStore.getBoolean("contentAssistCutPrefix");
            this.disableConstants = !preferenceStore.getBoolean("contentAssistShowConstantsAssist");
            this.showClassNamesInGlobalList = preferenceStore.getBoolean("contentAssistShowClassNamesInGlobalCompletion");
            this.showNonStrictOptions = preferenceStore.getBoolean("contentAssistShowNonStrictOptions");
            this.constantCaseSensitive = preferenceStore.getBoolean("contentAssistConstantsCaseSensitive");
            this.determineObjectTypeFromOtherFile = preferenceStore.getBoolean("contentAssistDetermineObjTypeFromOtherFiles");
            this.autoShowClassNames = preferenceStore.getBoolean("contentAssistAutoactivationForClassNames");
            this.autoShowFunctionsKeywordsConstants = preferenceStore.getBoolean("contentAssistAutoactivationForFunctionsKeyWordsConstants");
            this.autoShowVariables = preferenceStore.getBoolean("contentAssistAutoactivationForVariables");
            this.autoActivationTriggers = preferenceStore.getString("contentAssistAutoactivationTriggersPHP").trim().toCharArray();
        }
    }

    public ContentAssistSupport() {
        this.initPreferences(null);
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.initPreferences(event.getProperty());
    }

    public ICompletionProposal[] getCompletionOption(ITextViewer viewer, DOMModelForPHP phpDOMModel, int offset, boolean explicit) throws BadLocationException {
        ICompletionProposal[] codeCompletionOptions = this.getCodeCompletionOptions(viewer, phpDOMModel, offset, explicit);
        if (codeCompletionOptions == null) {
            return new ICompletionProposal[0];
        }
        return codeCompletionOptions;
    }

    private ICompletionProposal[] getCodeCompletionOptions(ITextViewer viewer, DOMModelForPHP phpEditorModel, int offset, boolean explicit) throws BadLocationException {
        this.completionProposalGroup = null;
        this.templateProposals = null;
        this.calcCompletionOption(phpEditorModel, offset, viewer, explicit);
        if (this.completionProposalGroup == null) {
            return this.templateProposals;
        }
        this.completionProposalGroup.setGroupOptions(this.groupCompletionOptions);
        this.completionProposalGroup.setCutCommonPrefix(this.cutCommonPrefix);
        return this.merg(this.completionProposalGroup.getCompletionProposals(this.getProjectModel(phpEditorModel)), this.templateProposals);
    }

    protected ICompletionProposal[] getTemplates(ITextViewer viewer, int offset) {
        PHPTemplateCompletionProcessor templateCompletionProcessor = this.getTemplateCompletionProcessor();
        ICompletionProposal[] templatesCompletionProposals = templateCompletionProcessor.computeCompletionProposals(viewer, offset);
        return templatesCompletionProposals;
    }

    private PHPTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.templateCompletionProcessor == null) {
            this.templateCompletionProcessor = new PHPTemplateCompletionProcessor();
            String context = this.getTemplateContext();
            this.templateCompletionProcessor.setContextTypeId(context);
        }
        return this.templateCompletionProcessor;
    }

    protected String getTemplateContext() {
        return "php";
    }

    public char[] getAutoactivationTriggers() {
        return this.autoActivationTriggers;
    }

    protected void calcCompletionOption(DOMModelForPHP editorModel, int offset, ITextViewer viewer, boolean explicit) throws BadLocationException {
        boolean haveSpacesAtEnd;
        int startOffset;
        int originalOffset = viewer.getSelectedRange().x;
        boolean isStrict = originalOffset != offset;
        PHPProjectModel projectModel = this.getProjectModel(editorModel);
        String fileName = null;
        PHPFileData fileData = editorModel.getFileData(true);
        if (fileData == null) {
            return;
        }
        fileName = fileData.getName();
        int selectionLength = ((TextSelection)viewer.getSelectionProvider().getSelection()).getLength();
        IStructuredDocumentRegion sdRegion = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)viewer, (int)offset);
        ITextRegion textRegion = null;
        textRegion = offset == editorModel.getStructuredDocument().getLength() ? sdRegion.getLastRegion() : sdRegion.getRegionAtCharacterOffset(offset);
        if (textRegion == null) {
            return;
        }
        IStructuredDocumentRegion container = sdRegion;
        if (textRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)textRegion;
            textRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (textRegion.getType() == "PHP_OPEN") {
            return;
        }
        if (textRegion.getType() == "PHP_CLOSE") {
            if (container.getStartOffset(textRegion) == offset) {
                ITextRegion regionBefore = container.getRegionAtCharacterOffset(offset - 1);
                if (regionBefore instanceof IPhpScriptRegion) {
                    textRegion = regionBefore;
                }
            } else {
                return;
            }
        }
        if ((startOffset = container.getStartOffset(textRegion)) == offset) {
            ITextRegion preTextRegion = container.getRegionAtCharacterOffset(offset - 1);
            IStructuredDocumentRegion preSdRegion = null;
            if (preTextRegion != null || (preSdRegion = sdRegion.getPrevious()) != null && (preTextRegion = preSdRegion.getRegionAtCharacterOffset(offset - 1)) != null) {
                preTextRegion.getType();
            }
            startOffset = sdRegion.getStartOffset(textRegion);
        }
        IPhpScriptRegion phpScriptRegion = null;
        String partitionType = null;
        int internalOffset = 0;
        ContextRegion internalPHPRegion = null;
        if (textRegion instanceof IPhpScriptRegion) {
            String regionType;
            phpScriptRegion = (IPhpScriptRegion)textRegion;
            internalOffset = offset - container.getStartOffset() - phpScriptRegion.getStart();
            partitionType = phpScriptRegion.getPartition(internalOffset);
            if (!(partitionType != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && partitionType != "org.eclipse.php.PHP_DOC" || (regionType = phpScriptRegion.getPhpToken(internalOffset).getType()) != "PHP_COMMENT_START" && regionType != "PHPDOC_COMMENT_START" || phpScriptRegion.getPhpToken(internalOffset).getStart() != internalOffset)) {
                partitionType = phpScriptRegion.getPartition(internalOffset - 1);
            }
            if (partitionType != "org.eclipse.php.PHP_DEFAULT" && partitionType != "org.eclipse.php.PHP_QUOTED_STRING" && partitionType != "org.eclipse.php.PHP_SINGLE_LINE_COMMENT") {
                return;
            }
            internalPHPRegion = (ContextRegion)phpScriptRegion.getPhpToken(internalOffset);
        }
        IStructuredDocument document = sdRegion.getParentDocument();
        if (fileData == null || phpScriptRegion == null) {
            this.getRegularCompletion(viewer, projectModel, "", "", offset, selectionLength, explicit, (ITextRegionCollection)container, (ITextRegion)phpScriptRegion, internalPHPRegion, document, isStrict);
            return;
        }
        TextSequence statementText = PHPTextSequenceUtilities.getStatement((int)offset, (IStructuredDocumentRegion)sdRegion, (boolean)true);
        String type = internalPHPRegion.getType();
        if (this.isInArrayOptionQuotes(projectModel, fileName, type, offset, selectionLength, statementText)) {
            return;
        }
        if (this.isPHPSingleQuote((ITextRegionCollection)container, phpScriptRegion, internalPHPRegion, document, offset) || this.isLineComment((ITextRegionCollection)container, phpScriptRegion, offset)) {
            return;
        }
        if (this.isInFunctionDeclaration(projectModel, fileName, statementText, offset, selectionLength, explicit)) {
            return;
        }
        if (this.isInCatchStatement(projectModel, fileData, statementText, offset, selectionLength, explicit)) {
            return;
        }
        int totalLength = statementText.length();
        int endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)statementText, (int)totalLength);
        int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)statementText, (int)endPosition, (boolean)true);
        String lastWord = statementText.subSequence(startPosition, endPosition).toString();
        boolean bl = haveSpacesAtEnd = totalLength != endPosition;
        if (haveSpacesAtEnd && this.isNewOrInstanceofStatement(projectModel, fileData, lastWord, "", offset, selectionLength, explicit, type)) {
            return;
        }
        int line = document.getLineOfOffset(offset);
        if (this.isClassFunctionCompletion(projectModel, fileName, statementText, offset, line, selectionLength, lastWord, startPosition, haveSpacesAtEnd, explicit, isStrict)) {
            return;
        }
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)statementText, (int)startPosition);
        startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)statementText, (int)endPosition, (boolean)true);
        String firstWord = statementText.subSequence(startPosition, endPosition).toString();
        if (!haveSpacesAtEnd && this.isNewOrInstanceofStatement(projectModel, fileData, firstWord, lastWord, offset, selectionLength, explicit, type)) {
            if (lastWord.startsWith("$")) {
                if (haveSpacesAtEnd) {
                    this.getRegularCompletion(viewer, projectModel, fileName, "", offset, selectionLength, explicit, (ITextRegionCollection)container, (ITextRegion)phpScriptRegion, internalPHPRegion, document, isStrict);
                } else {
                    this.getRegularCompletion(viewer, projectModel, fileName, lastWord, offset, selectionLength, explicit, (ITextRegionCollection)container, (ITextRegion)phpScriptRegion, internalPHPRegion, document, isStrict);
                }
            }
            return;
        }
        if (haveSpacesAtEnd && ContentAssistSupport.isFunctionCall(projectModel, lastWord)) {
            return;
        }
        if (this.isInArrayOption(projectModel, fileName, haveSpacesAtEnd, firstWord, lastWord, startPosition, offset, selectionLength, statementText, type)) {
            return;
        }
        if (this.isInClassDeclaration(projectModel, statementText, offset, selectionLength, explicit)) {
            return;
        }
        if (haveSpacesAtEnd) {
            this.getRegularCompletion(viewer, projectModel, fileName, "", offset, selectionLength, explicit, (ITextRegionCollection)container, (ITextRegion)phpScriptRegion, internalPHPRegion, document, isStrict);
        } else {
            this.getRegularCompletion(viewer, projectModel, fileName, lastWord, offset, selectionLength, explicit, (ITextRegionCollection)container, (ITextRegion)phpScriptRegion, internalPHPRegion, document, isStrict);
        }
    }

    private PHPProjectModel getProjectModel(DOMModelForPHP editorModel) {
        PHPProjectModel projectModel = editorModel.getProjectModel();
        if (projectModel == null) {
            projectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        return projectModel;
    }

    protected static boolean isFunctionCall(PHPProjectModel projectModel, String functionName) {
        CodeData[] functionsData = projectModel.getFunction(functionName);
        return functionsData != null && functionsData.length > 0;
    }

    protected boolean isLineComment(ITextRegionCollection sdRegion, IPhpScriptRegion phpScriptRegion, int offset) {
        int relativeOffset = offset - sdRegion.getStartOffset((ITextRegion)phpScriptRegion);
        try {
            return phpScriptRegion.isLineComment(relativeOffset);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return false;
        }
    }

    protected boolean isPHPSingleQuote(ITextRegionCollection sdRegion, IPhpScriptRegion phpScriptRegion, ContextRegion internalRegion, IStructuredDocument document, int documentOffset) {
        if (PHPPartitionTypes.isPHPQuotesState((String)internalRegion.getType())) {
            char firstChar;
            int endOffset;
            int startOffset;
            try {
                startOffset = internalRegion.getStart() + sdRegion.getStartOffset((ITextRegion)phpScriptRegion);
                endOffset = startOffset + internalRegion.getTextLength();
                firstChar = document.get(startOffset, internalRegion.getTextLength()).charAt(0);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
                return false;
            }
            return firstChar == '\'' && documentOffset <= endOffset - 1 && startOffset < documentOffset;
        }
        return false;
    }

    protected boolean isInArrayOptionQuotes(PHPProjectModel projectModel, String fileName, String type, int offset, int selectionLength, TextSequence text) {
        if (!PHPPartitionTypes.isPHPQuotesState((String)type)) {
            return false;
        }
        int length = text.length();
        int endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)text, (int)length);
        int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)text, (int)endPosition, (boolean)false);
        if (endPosition != length && startPosition != endPosition) {
            return false;
        }
        String startWith = text.subSequence(startPosition, endPosition).toString();
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)text, (int)startPosition);
        if (endPosition == 0) {
            return false;
        }
        char c = text.charAt(endPosition - 1);
        if (c != '\"' && c != '\'') {
            return false;
        }
        --endPosition;
        if ((endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)text, (int)endPosition)) == 0 || text.charAt(endPosition - 1) != '[') {
            return false;
        }
        --endPosition;
        startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)text, (int)(endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)text, (int)endPosition)), (boolean)true);
        String variableName = text.subSequence(startPosition, endPosition).toString();
        if (variableName.startsWith("$")) {
            variableName = variableName.substring(1);
        }
        CodeData[] result = projectModel.getArrayVariables(fileName, variableName, startWith, this.determineObjectTypeFromOtherFile);
        this.completionProposalGroup = this.arrayCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, result, startWith, selectionLength);
        return true;
    }

    protected void getRegularCompletion(ITextViewer viewer, PHPProjectModel projectModel, String fileName, String startsWith, int offset, int selectionLength, boolean explicit, ITextRegionCollection sdRegion, ITextRegion tRegion, ContextRegion internalPhpRegion, IStructuredDocument document, boolean isStrict) {
        if (!explicit && startsWith.length() == 0) {
            return;
        }
        boolean inClass = false;
        PHPCodeData codeData = Utils.getCodeData((PHPFileData)projectModel.getFileData(fileName), (int)offset);
        if (codeData.getUserData().getStopPosition() > offset) {
            codeData = codeData.getContainer();
        }
        if (codeData instanceof PHPClassData) {
            inClass = true;
        }
        if (internalPhpRegion != null) {
            String type = internalPhpRegion.getType();
            if (startsWith.startsWith("$") && !inClass) {
                if (!explicit && !this.autoShowVariables) {
                    return;
                }
                try {
                    if (!explicit && startsWith.equals("$") && document.getLength() != offset && Character.isLetter(document.getChar(offset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {}
                if (PHPPartitionTypes.isPHPQuotesState((String)type)) {
                    IStructuredDocument doc = document;
                    try {
                        char charBefore = doc.get(offset - 2, 1).charAt(0);
                        if (charBefore == '\\') {
                            return;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.logException(badLocationException);
                    }
                }
                PHPCodeContext context = this.getContext(projectModel, fileName, offset - startsWith.length());
                startsWith = startsWith.substring(1);
                CodeData[] variables = projectModel.getVariables(fileName, context, startsWith, this.showVariablesFromOtherFiles);
                this.completionProposalGroup = this.phpCompletionProposalGroup;
                this.completionProposalGroup.setData(offset, variables, startsWith, selectionLength, isStrict);
                return;
            }
            if (PHPPartitionTypes.isPHPQuotesState((String)type) || type.equals("PHP_HEREDOC_TAG") && sdRegion.getStartOffset(tRegion) + tRegion.getLength() <= offset) {
                this.completionProposalGroup = this.regularPHPCompletionProposalGroup;
                this.completionProposalGroup.setData(offset, new CodeData[0], startsWith, selectionLength, isStrict);
                return;
            }
        }
        CodeData[] functions = null;
        CodeData[] constants = null;
        CodeData[] keywords = null;
        if ((explicit || this.autoShowFunctionsKeywordsConstants) && !inClass) {
            functions = startsWith.length() == 0 ? projectModel.getFunctions() : projectModel.getFunctions(startsWith);
            if (!this.disableConstants) {
                constants = startsWith.length() == 0 ? projectModel.getConstants() : projectModel.getConstants(startsWith, this.constantCaseSensitive);
            }
        }
        keywords = projectModel.getKeywordData();
        if (inClass) {
            keywords = this.filterClassKeywords(keywords);
        }
        CodeData[] classes = null;
        if (!inClass && this.showClassNamesInGlobalList && (explicit || this.autoShowClassNames)) {
            classes = projectModel.getClasses();
        }
        Object[] mergeData = null;
        if (this.shouldAddPHPTag(document, offset, startsWith)) {
            mergeData = phpTagDataArray;
        }
        mergeData = ModelSupport.merge((CodeData[])keywords, (CodeData[])mergeData);
        mergeData = ModelSupport.merge((CodeData[])classes, (CodeData[])mergeData);
        mergeData = ModelSupport.merge((CodeData[])constants, (CodeData[])mergeData);
        mergeData = ModelSupport.merge((CodeData[])functions, (CodeData[])mergeData);
        this.completionProposalGroup = this.regularPHPCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, (CodeData[])mergeData, startsWith, selectionLength, isStrict);
        this.templateProposals = this.getTemplates(viewer, offset);
    }

    private CodeData[] filterClassKeywords(CodeData[] keywords) {
        ArrayList<CodeData> filteredKeywords = new ArrayList<CodeData>();
        int i = 0;
        while (i < keywords.length) {
            if (CLASS_KEYWORDS_SET.contains(keywords[i].toString())) {
                filteredKeywords.add(keywords[i]);
            }
            ++i;
        }
        return filteredKeywords.toArray(new CodeData[filteredKeywords.size()]);
    }

    private boolean shouldAddPHPTag(IStructuredDocument doc, int offset, String startsWith) {
        offset -= startsWith.length() + 2;
        try {
            String text = doc.get(offset, 2);
            if (text.equals("<?")) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean isClassFunctionCompletion(PHPProjectModel projectModel, String fileName, TextSequence statementText, int offset, int line, int selectionLength, String functionName, int startFunctionPosition, boolean haveSpacesAtEnd, boolean explicit, boolean isStrict) {
        String className;
        if ((startFunctionPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)statementText, (int)startFunctionPosition)) <= 2) {
            return false;
        }
        boolean isClassTriger = false;
        boolean isParent = false;
        String triggerText = statementText.subSequence(startFunctionPosition - 2, startFunctionPosition).toString();
        if (!triggerText.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (triggerText.equals(CLASS_FUNCTIONS_TRIGGER)) {
                String parentText;
                isClassTriger = true;
                if (startFunctionPosition >= 8 && (parentText = statementText.subSequence(startFunctionPosition - 8, startFunctionPosition - 2).toString()).equals("parent")) {
                    isParent = true;
                }
            } else {
                return false;
            }
        }
        if ((className = this.getClassName(projectModel, fileName, statementText, startFunctionPosition, offset, line)) == null) {
            className = "";
        }
        if (haveSpacesAtEnd && functionName.length() > 0) {
            return this.isClassFunctionCall(projectModel, fileName, className, functionName);
        }
        if (isClassTriger) {
            if (isParent) {
                if (className != "") {
                    this.showClassStaticCall(projectModel, fileName, offset, className, functionName, selectionLength, explicit);
                }
            } else {
                this.showClassStaticCall(projectModel, fileName, offset, className, functionName, selectionLength, explicit);
            }
        } else {
            String parent = statementText.toString().substring(0, statementText.toString().lastIndexOf(OBJECT_FUNCTIONS_TRIGGER)).trim();
            boolean isInstanceOf = !parent.equals("$this");
            boolean addVariableDollar = false;
            this.showClassCall(projectModel, fileName, offset, className, functionName, selectionLength, isInstanceOf, addVariableDollar, explicit, isStrict);
        }
        return true;
    }

    protected String getClassName(PHPProjectModel projectModel, String fileName, TextSequence statementText, int endPosition, int offset, int line) {
        int propertyEndPosition;
        int lastObjectOperator;
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)statementText, (int)endPosition);
        boolean isClassTriger = false;
        String triggerText = statementText.subSequence(endPosition - 2, endPosition).toString();
        if (!triggerText.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (triggerText.equals(CLASS_FUNCTIONS_TRIGGER)) {
                isClassTriger = true;
            } else {
                return null;
            }
        }
        if ((lastObjectOperator = PHPTextSequenceUtilities.getPrivousTriggerIndex((TextSequence)statementText, (int)(propertyEndPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)statementText, (int)(endPosition - 2))))) == -1) {
            return this.innerGetClassName(projectModel, fileName, statementText, propertyEndPosition, isClassTriger, offset, line);
        }
        int propertyStartPosition = PHPTextSequenceUtilities.readForwardSpaces((TextSequence)statementText, (int)(lastObjectOperator + 2));
        String propertyName = statementText.subSequence(propertyStartPosition, propertyEndPosition).toString();
        String className = this.getClassName(projectModel, fileName, statementText, propertyStartPosition, offset, line);
        int bracketIndex = propertyName.indexOf(40);
        if (bracketIndex == -1) {
            return PHPModelUtil.getVarType((PHPProjectModel)projectModel, (String)fileName, (String)className, (String)propertyName, (int)offset, (int)line, (boolean)this.determineObjectTypeFromOtherFile);
        }
        String functionName = propertyName.substring(0, bracketIndex).trim();
        return PHPModelUtil.getFunctionReturnType((PHPProjectModel)projectModel, (String)fileName, (String)className, (String)functionName);
    }

    protected String getFunctionReturnType(PHPProjectModel projectModel, String fileName, String className, String functionName) {
        return PHPModelUtil.getFunctionReturnType((PHPProjectModel)projectModel, (String)fileName, (String)className, (String)functionName);
    }

    protected String innerGetClassName(PHPProjectModel projectModel, String fileName, TextSequence statementText, int propertyEndPosition, boolean isClassTriger, int offset, int line) {
        String testedVar;
        Matcher m;
        int classNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)statementText, (int)propertyEndPosition, (boolean)true);
        String className = statementText.subSequence(classNameStart, propertyEndPosition).toString();
        if (isClassTriger) {
            PHPClassData classData;
            if (className.equals("self")) {
                PHPClassData classData2 = this.getContainerClassData(projectModel, fileName, offset - 6);
                if (classData2 != null) {
                    return classData2.getName();
                }
            } else if (className.equals("parent") && (classData = this.getContainerClassData(projectModel, fileName, offset - 8)) != null) {
                return projectModel.getSuperClassName(fileName, classData.getName());
            }
            return className;
        }
        if (className.length() == 0 && (m = globalPattern.matcher(testedVar = statementText.subSequence(0, propertyEndPosition).toString().trim())).matches()) {
            String quotedVarName = testedVar.substring(testedVar.indexOf(91) + 1, testedVar.indexOf(93)).trim();
            className = "$" + quotedVarName.substring(1, quotedVarName.length() - 1);
        }
        if (className.length() > 0 && className.charAt(0) == '$') {
            int statementStart = offset - statementText.length();
            return PHPFileDataUtilities.getVariableType((String)fileName, (String)className, (int)statementStart, (int)line, (IPhpModel)projectModel.getPHPUserModel(), (boolean)this.determineObjectTypeFromOtherFile);
        }
        if (statementText.charAt(propertyEndPosition - 1) == ')') {
            PHPFunctionData[] functions;
            int functionNameEnd = this.getFunctionNameEndOffset(statementText, propertyEndPosition - 1);
            int functionNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)statementText, (int)functionNameEnd, (boolean)false);
            String functionName = statementText.subSequence(functionNameStart, functionNameEnd).toString();
            PHPClassData classData = this.getContainerClassData(projectModel, fileName, offset);
            if (classData != null) {
                return PHPModelUtil.getFunctionReturnType((PHPProjectModel)projectModel, (String)fileName, (String)classData.getName(), (String)functionName);
            }
            PHPFileData fileData = projectModel.getFileData(fileName);
            PHPFunctionData[] pHPFunctionDataArray = functions = fileData.getFunctions();
            int n = functions.length;
            int n2 = 0;
            while (n2 < n) {
                PHPFunctionData function = pHPFunctionDataArray[n2];
                if (function.getName().equals(functionName)) {
                    return function.getReturnType();
                }
                ++n2;
            }
        }
        return null;
    }

    protected boolean isClassFunctionCall(PHPProjectModel projectModel, String fileName, String className, String functionName) {
        CodeData functionData = projectModel.getClassFunctionData(fileName, className, functionName);
        return functionData != null;
    }

    protected void showClassCall(PHPProjectModel projectModel, String fileName, int offset, String className, String startWith, int selectionLength, boolean isInstanceOf, boolean addVariableDollar, boolean explicit, boolean isStrict) {
        String[] classNames;
        CodeData[] allFunctions = null;
        CodeData[] allClassVariables = null;
        String[] stringArray = classNames = className.split("\\|");
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String realClassName = stringArray[n2];
            realClassName = realClassName.trim();
            if (explicit || this.autoShowFunctionsKeywordsConstants) {
                CodeData[] functions = projectModel.getClassFunctions(fileName, realClassName, startWith.length() == 0 ? "" : startWith);
                allFunctions = ModelSupport.merge((CodeData[])allFunctions, (CodeData[])functions);
            }
            if (explicit || this.autoShowVariables) {
                CodeData[] classVariables = ModelSupport.getFilteredCodeData((CodeData[])projectModel.getClassVariables(fileName, realClassName, ""), (CodeDataFilter)ModelSupport.NOT_STATIC_VARIABLES_FILTER);
                allClassVariables = ModelSupport.merge((CodeData[])allClassVariables, (CodeData[])classVariables);
            }
            ++n2;
        }
        CodeData[] result = ModelSupport.getFilteredCodeData((CodeData[])ModelSupport.merge((CodeData[])allFunctions, (CodeData[])allClassVariables), (CodeDataFilter)this.getAccessLevelFilter(projectModel, fileName, className, offset, isInstanceOf));
        this.completionProposalGroup = addVariableDollar ? this.classVariableCallCompletionProposalGroup : this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, result, startWith, selectionLength, isStrict);
    }

    protected void showClassStaticCall(PHPProjectModel projectModel, String fileName, int offset, String className, String startWith, int selectionLength, boolean explicit) {
        CodeData[] functions = null;
        if (explicit || this.autoShowFunctionsKeywordsConstants) {
            functions = projectModel.getClassFunctions(fileName, className, "");
            String phpVersion = projectModel.getPHPLanguageModel().getPHPVersion();
            boolean isPHP5 = phpVersion.equals("php5");
            if (isPHP5 && !this.showNonStrictOptions) {
                functions = ModelSupport.getFilteredCodeData((CodeData[])functions, (CodeDataFilter)ModelSupport.STATIC_FUNCTIONS_FILTER);
            }
        }
        CodeData[] classVariables = null;
        if (explicit || this.autoShowVariables) {
            classVariables = ModelSupport.merge((CodeData[])projectModel.getClassVariables(fileName, className, ""), (CodeData[])projectModel.getClassConsts(fileName, className, ""));
        }
        CodeData[] result = ModelSupport.getFilteredCodeData((CodeData[])ModelSupport.merge((CodeData[])functions, (CodeData[])classVariables), (CodeDataFilter)this.getAccessLevelFilter(projectModel, fileName, className, offset, false));
        this.completionProposalGroup = this.classStaticCallCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, result, startWith, selectionLength);
    }

    protected void showParentCall(PHPProjectModel projectModel, String fileName, int offset, String className, String startWith, int selectionLength, boolean explicit, boolean isStrict) {
        CodeData[] functions = null;
        if (explicit || this.autoShowFunctionsKeywordsConstants) {
            functions = projectModel.getClassFunctions(fileName, className, startWith.length() == 0 ? "" : startWith);
        }
        projectModel.getClass(fileName, className);
        functions = ModelSupport.getFilteredCodeData((CodeData[])functions, (CodeDataFilter)ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, functions, startWith, selectionLength, isStrict);
    }

    protected PHPClassData getContainerClassData(PHPProjectModel projectModel, String fileName, int offset) {
        PHPFileData fileData = projectModel.getFileData(fileName);
        return PHPFileDataUtilities.getContainerClassData((PHPFileData)fileData, (int)offset);
    }

    protected int getFunctionNameEndOffset(TextSequence statementText, int offset) {
        if (statementText.charAt(offset) != ')') {
            return 0;
        }
        int currChar = offset;
        int bracketsNum = 1;
        char inStringMode = '\u0000';
        while (bracketsNum != 0 && currChar >= 0) {
            char charAt;
            if ((charAt = statementText.charAt(--currChar)) == '\'' || charAt == '\"') {
                char c = inStringMode == '\u0000' ? charAt : (inStringMode = inStringMode == charAt ? (char)'\u0000' : inStringMode);
            }
            if (inStringMode != '\u0000') continue;
            if (charAt == ')') {
                ++bracketsNum;
                continue;
            }
            if (charAt != '(') continue;
            --bracketsNum;
        }
        return currChar;
    }

    protected CodeDataFilter getAccessLevelFilter(PHPProjectModel projectModel, String fileName, String className, int offset, boolean isInstanceOf) {
        PHPCodeContext context = this.getContext(projectModel, fileName, offset);
        String contextClassName = context.getContainerClassName();
        if (contextClassName.equals(className)) {
            return ModelSupport.PIRVATE_ACCESS_LEVEL_FILTER;
        }
        if (isInstanceOf) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER;
        }
        if (contextClassName.equals("")) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
        }
        PHPClassData classData = projectModel.getClass(fileName, contextClassName);
        String superClassName = classData.getSuperClassData().getName();
        while (superClassName != null) {
            if (superClassName.equals(className)) {
                return ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
            }
            classData = projectModel.getClass(fileName, superClassName);
            if (classData == null) break;
            superClassName = classData.getSuperClassData().getName();
        }
        if (superClassName == null && !contextClassName.equals("")) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
        }
        return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER;
    }

    protected PHPCodeContext getContext(PHPProjectModel projectModel, String fileName, int offset) {
        PHPFileData fileData = projectModel.getFileData(fileName);
        return ModelSupport.createContext((PHPFileData)fileData, (int)offset);
    }

    protected boolean isInFunctionDeclaration(PHPProjectModel projectModel, String fileName, TextSequence text, int offset, int selectionLength, boolean explicit) {
        String functionNameStart;
        int functionStart = PHPTextSequenceUtilities.isInFunctionDeclaration((TextSequence)text);
        if (functionStart == -1) {
            return false;
        }
        int i = text.length() - 1;
        while (i >= functionStart) {
            if (text.charAt(i) == '(') {
                boolean showClassCompletion = true;
                int j = text.length() - 1;
                while (j > i) {
                    if (text.charAt(j) == '$') {
                        showClassCompletion = false;
                        break;
                    }
                    if (text.charAt(j) == ',') break;
                    --j;
                }
                if (showClassCompletion) {
                    CodeData[] classes = projectModel.getClasses();
                    this.completionProposalGroup = this.phpCompletionProposalGroup;
                    String prefix = text.subTextSequence(j + 1, text.length()).toString();
                    int k = 0;
                    while (k < prefix.length()) {
                        if (!Character.isWhitespace(prefix.charAt(k))) break;
                        ++k;
                    }
                    if (k != 0) {
                        prefix = prefix.substring(k);
                    }
                    this.completionProposalGroup.setData(offset, classes, prefix, selectionLength, false);
                }
                return true;
            }
            --i;
        }
        PHPClassData classData = this.getContainerClassData(projectModel, fileName, text.getOriginalOffset(functionStart));
        if (classData == null) {
            return true;
        }
        int wordEnd = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)text, (int)text.length());
        int wordStart = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)text, (int)wordEnd, (boolean)false);
        String word = text.subSequence(wordStart, wordEnd).toString();
        if (word.equals("function")) {
            functionNameStart = "";
        } else if (wordEnd == text.length()) {
            functionNameStart = word;
        } else {
            return true;
        }
        String phpVersion = projectModel.getPHPLanguageModel().getPHPVersion();
        boolean isPHP5 = phpVersion.equals("php5");
        CodeData[] magicMethods = PHPCodeDataFactory.createMagicMethods((PHPClassData)classData, (boolean)isPHP5);
        CodeData[] constructors = PHPCodeDataFactory.createConstructors((PHPClassData)classData, (boolean)isPHP5);
        Object[] data = new CodeData[magicMethods.length + constructors.length];
        System.arraycopy(magicMethods, 0, data, 0, magicMethods.length);
        System.arraycopy(constructors, 0, data, magicMethods.length, constructors.length);
        Arrays.sort(data);
        this.completionProposalGroup = this.classConstructorCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, (CodeData[])data, functionNameStart, selectionLength);
        return true;
    }

    protected boolean isInClassDeclaration(PHPProjectModel projectModel, TextSequence text, int offset, int selectionLength, boolean explicit) {
        int classEnd = PHPTextSequenceUtilities.isInClassDeclaration((TextSequence)text);
        if (classEnd == -1) {
            return false;
        }
        boolean isClassDeclaration = true;
        if (classEnd >= 6) {
            String classString = text.subSequence(classEnd - 6, classEnd - 1).toString();
            isClassDeclaration = classString.equals("class");
        }
        text = text.subTextSequence(classEnd, text.length());
        int classIdentifierEndPosition = 0;
        while (classIdentifierEndPosition < text.length()) {
            if (!Character.isLetterOrDigit(text.charAt(classIdentifierEndPosition))) break;
            ++classIdentifierEndPosition;
        }
        if (classIdentifierEndPosition == text.length()) {
            return true;
        }
        text = text.subTextSequence(classIdentifierEndPosition, text.length());
        int endPosition = text.length();
        int startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)text, (int)endPosition, (boolean)false);
        String lastWord = text.subSequence(startPosition, endPosition).toString();
        Matcher extendsMatcher = extendsPattern.matcher((CharSequence)text);
        Matcher implementsMatcher = implementsPattern.matcher((CharSequence)text);
        boolean foundExtends = extendsMatcher.find();
        boolean foundImplements = implementsMatcher.find();
        if (!foundExtends && !foundImplements) {
            if (explicit || lastWord.length() > 0) {
                if (isClassDeclaration) {
                    this.showExtendsImplementsList(projectModel, lastWord, offset, selectionLength, explicit);
                } else {
                    this.showExtendsList(projectModel, lastWord, offset, selectionLength, explicit);
                }
            }
            return true;
        }
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)text, (int)startPosition);
        String firstWord = text.subSequence(startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)text, (int)endPosition, (boolean)true), endPosition).toString();
        if (firstWord.equalsIgnoreCase("extends")) {
            this.showBaseClassList(projectModel, lastWord, offset, selectionLength, isClassDeclaration, explicit);
            return true;
        }
        if (firstWord.equalsIgnoreCase("implements")) {
            this.showInterfaceList(projectModel, lastWord, offset, selectionLength, explicit);
            return true;
        }
        if (foundExtends && foundImplements) {
            if (explicit || lastWord.length() > 0) {
                if (extendsMatcher.start() < implementsMatcher.start()) {
                    this.showInterfaceList(projectModel, lastWord, offset, selectionLength, explicit);
                } else {
                    this.showBaseClassList(projectModel, lastWord, offset, selectionLength, isClassDeclaration, explicit);
                }
            }
            return true;
        }
        if (foundImplements || !isClassDeclaration) {
            if (explicit) {
                this.showInterfaceList(projectModel, lastWord, offset, selectionLength, explicit);
            }
            return true;
        }
        if ((explicit || lastWord.length() > 0) && isClassDeclaration) {
            this.showImplementsList(projectModel, lastWord, offset, selectionLength, explicit);
        }
        return true;
    }

    protected void showInterfaceList(PHPProjectModel projectModel, String startWith, int offset, int selectionLength, boolean explicit) {
        if (!explicit && !this.autoShowClassNames) {
            return;
        }
        CodeData[] classes = projectModel.getClasses();
        ArrayList<CodeData> interfaces = new ArrayList<CodeData>(classes.length / 10);
        CodeData[] codeDataArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData element = codeDataArray[n2];
            if (PHPModifier.isInterface((int)((PHPClassData)element).getModifiers())) {
                interfaces.add(element);
            }
            ++n2;
        }
        CodeData[] interfacesArray = new CodeData[interfaces.size()];
        Iterator iter = interfaces.iterator();
        int i = 0;
        while (i < interfacesArray.length) {
            interfacesArray[i] = (CodeData)iter.next();
            ++i;
        }
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, interfacesArray, startWith, selectionLength);
    }

    protected void showExtendsImplementsList(PHPProjectModel projectModel, String startWith, int offset, int selectionLength, boolean explicit) {
        if (!explicit && !this.autoShowClassNames) {
            return;
        }
        CodeData[] result = this.getExtendsImplementsCodeData(projectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, result, startWith, selectionLength);
    }

    protected CodeData[] getExtendsImplementsCodeData(PHPProjectModel projectModel) {
        if (this.extendedImplementCodeData == null) {
            CodeData[] keywords;
            CodeData extendsCodeData = null;
            CodeData implementsCodeData = null;
            CodeData[] codeDataArray = keywords = projectModel.getKeywordData();
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                CodeData element = codeDataArray[n2];
                if (element.getName().equals("extends")) {
                    extendsCodeData = element;
                }
                if (element.getName().equals("implements")) {
                    implementsCodeData = element;
                }
                ++n2;
            }
            String phpVersion = projectModel.getPHPLanguageModel().getPHPVersion();
            boolean isPHP5 = phpVersion.equals("php5");
            this.extendedImplementCodeData = isPHP5 ? new CodeData[]{extendsCodeData, implementsCodeData} : new CodeData[]{extendsCodeData};
        }
        return this.extendedImplementCodeData;
    }

    protected void showImplementsList(PHPProjectModel projectModel, String startWith, int offset, int selectionLength, boolean explicit) {
        if (!explicit && !this.autoShowClassNames) {
            return;
        }
        CodeData[] result = this.getImplementsCodeData(projectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, result, startWith, selectionLength);
    }

    protected CodeData[] getImplementsCodeData(PHPProjectModel projectModel) {
        String phpVersion = projectModel.getPHPLanguageModel().getPHPVersion();
        boolean isPHP5 = phpVersion.equals("php5");
        if (!isPHP5) {
            return null;
        }
        if (implementCodeData == null) {
            CodeData[] keywords;
            CodeData implementsCodeData = null;
            CodeData[] codeDataArray = keywords = projectModel.getKeywordData();
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                CodeData element = codeDataArray[n2];
                if (element.getName().equals("implements")) {
                    implementsCodeData = element;
                    break;
                }
                ++n2;
            }
            implementCodeData = new CodeData[]{implementsCodeData};
        }
        return implementCodeData;
    }

    private void showExtendsList(PHPProjectModel projectModel, String startWith, int offset, int selectionLength, boolean explicit) {
        if (!explicit && !this.autoShowClassNames) {
            return;
        }
        CodeData[] result = ContentAssistSupport.getExtendsCodeData(projectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, result, startWith, selectionLength);
    }

    private static CodeData[] getExtendsCodeData(PHPProjectModel projectModel) {
        if (extendsCodeData == null) {
            CodeData[] keywords;
            CodeData extendCodeData = null;
            CodeData[] codeDataArray = keywords = projectModel.getKeywordData();
            int n = keywords.length;
            int n2 = 0;
            while (n2 < n) {
                CodeData element = codeDataArray[n2];
                if (element.getName().equals("extends")) {
                    extendCodeData = element;
                    break;
                }
                ++n2;
            }
            extendsCodeData = new CodeData[]{extendCodeData};
        }
        return extendsCodeData;
    }

    private void showBaseClassList(PHPProjectModel projectModel, String startWith, int offset, int selectionLength, boolean isClassDecleration, boolean explicit) {
        if (!isClassDecleration) {
            this.showInterfaceList(projectModel, startWith, offset, selectionLength, explicit);
            return;
        }
        if (!explicit && !this.autoShowClassNames) {
            return;
        }
        CodeData[] classes = this.getOnlyClasses(projectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, classes, startWith, selectionLength);
    }

    private CodeData[] getOnlyClasses(PHPProjectModel projectModel) {
        CodeData[] classes = projectModel.getClasses();
        int numOfInterfaces = 0;
        CodeData[] codeDataArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData element = codeDataArray[n2];
            if (PHPModifier.isInterface((int)((PHPClassData)element).getModifiers())) {
                ++numOfInterfaces;
            }
            ++n2;
        }
        if (numOfInterfaces == 0) {
            return classes;
        }
        CodeData[] newClasses = new CodeData[classes.length - numOfInterfaces];
        int j = 0;
        int i = 0;
        while (i < classes.length) {
            if (!PHPModifier.isInterface((int)((PHPClassData)classes[i]).getModifiers())) {
                newClasses[j] = classes[i];
                ++j;
            }
            ++i;
        }
        return newClasses;
    }

    protected boolean isInCatchStatement(PHPProjectModel projectModel, PHPFileData fileData, TextSequence text, int offset, int selectionLength, boolean explicit) {
        Matcher matcher = catchPattern.matcher((CharSequence)text);
        int catchStart = text.length();
        while (matcher.find()) {
            if (text.length() != matcher.end()) continue;
            catchStart = matcher.start() + 1;
            break;
        }
        if (catchStart == text.length()) {
            return false;
        }
        int classEnd = catchStart + 5;
        text = text.subTextSequence(classEnd, text.length());
        int startPosition = 0;
        while (startPosition < text.length()) {
            if (text.charAt(startPosition) == '(') break;
            ++startPosition;
        }
        if (startPosition == text.length()) {
            return true;
        }
        startPosition = PHPTextSequenceUtilities.readForwardSpaces((TextSequence)text, (int)(startPosition + 1));
        int endPosition = PHPTextSequenceUtilities.readIdentifierEndIndex((TextSequence)text, (int)startPosition, (boolean)false);
        String className = text.subSequence(startPosition, endPosition).toString();
        if (endPosition == text.length()) {
            this.showClassList(projectModel, fileData, className, offset, selectionLength, States.CATCH, explicit);
        }
        return true;
    }

    protected void showClassList(PHPProjectModel projectModel, PHPFileData fileData, String startWith, int offset, int selectionLength, States state, boolean explicit) {
        if (!explicit && !this.autoShowClassNames) {
            return;
        }
        boolean addSelfKeyword = this.needToAddSelfKeyword(fileData, offset);
        CodeData[] classes = null;
        switch (state) {
            case NEW: {
                this.completionProposalGroup = this.newStatementCompletionProposalGroup;
                classes = this.getOnlyClasses(projectModel);
                classes = ModelSupport.removeFilteredCodeData((CodeData[])classes, (CodeDataFilter)ModelSupport.IS_ABSTRACT_CLASS_FILTER);
                if (!addSelfKeyword) break;
                classes = this.addSelfKeywordToProposals(classes);
                break;
            }
            case INSTANCEOF: {
                this.completionProposalGroup = this.phpCompletionProposalGroup;
                classes = projectModel.getClasses();
                if (!addSelfKeyword) break;
                classes = this.addSelfKeywordToProposals(classes);
                break;
            }
            case CATCH: {
                this.completionProposalGroup = this.phpCompletionProposalGroup;
                classes = projectModel.getClasses();
                break;
            }
        }
        this.completionProposalGroup.setData(offset, classes, startWith, selectionLength);
    }

    private boolean needToAddSelfKeyword(PHPFileData fileData, int offset) {
        boolean addSelfKeyword = false;
        PHPCodeContext context = ModelSupport.createContext((PHPFileData)fileData, (int)offset);
        String className = context.getContainerClassName();
        String functionName = context.getContainerFunctionName();
        if (className != null && className.trim().length() > 0 && functionName != null && functionName.trim().length() > 0) {
            PHPClassData[] classes;
            addSelfKeyword = true;
            PHPClassData[] pHPClassDataArray = classes = fileData.getClasses();
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                int modifiers;
                PHPClassData classData = pHPClassDataArray[n2];
                if (classData.getName().equals(className) && (PHPModifier.isAbstract((int)(modifiers = classData.getModifiers())) || PHPModifier.isInterface((int)modifiers))) {
                    return false;
                }
                ++n2;
            }
        }
        return addSelfKeyword;
    }

    private CodeData[] addSelfKeywordToProposals(CodeData[] classes) {
        PHPKeywordData selfKeyword = PHPCodeDataFactory.createPHPKeywordData((String)"self", (String)CLASS_FUNCTIONS_TRIGGER, (int)2);
        Object[] proposalArray = new CodeData[classes.length + 1];
        System.arraycopy(classes, 0, proposalArray, 0, classes.length);
        proposalArray[classes.length] = selfKeyword;
        Arrays.sort(proposalArray);
        return proposalArray;
    }

    protected boolean isNewOrInstanceofStatement(PHPProjectModel projectModel, PHPFileData fileData, String keyword, String startWith, int offset, int selectionLength, boolean explicit, String type) {
        if (PHPPartitionTypes.isPHPQuotesState((String)type)) {
            return false;
        }
        if (keyword.equalsIgnoreCase("instanceof")) {
            this.showClassList(projectModel, fileData, startWith, offset, selectionLength, States.INSTANCEOF, explicit);
            return true;
        }
        if (keyword.equalsIgnoreCase("new")) {
            this.showClassList(projectModel, fileData, startWith, offset, selectionLength, States.NEW, explicit);
            return true;
        }
        return false;
    }

    protected boolean isInArrayOption(PHPProjectModel projectModel, String fileName, boolean haveSpacesAtEnd, String firstWord, String lastWord, int startPosition, int offset, int selectionLength, TextSequence text, String type) {
        CodeData[] constans;
        CodeData[] functions;
        if (PHPPartitionTypes.isPHPQuotesState((String)type)) {
            return false;
        }
        boolean isArrayOption = false;
        if (startPosition > 0 && !lastWord.startsWith("$")) {
            if (haveSpacesAtEnd) {
                if (lastWord.length() == 0 && firstWord.length() == 0 && text.charAt(startPosition - 1) == '[') {
                    isArrayOption = true;
                }
            } else if (firstWord.length() == 0 && text.charAt(startPosition - 1) == '[') {
                isArrayOption = true;
            }
        }
        if (!isArrayOption) {
            return false;
        }
        int endPosition = startPosition - 1;
        startPosition = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)text, (int)(endPosition = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)text, (int)endPosition)), (boolean)true);
        String variableName = text.subSequence(startPosition, endPosition).toString();
        if (variableName.startsWith("$")) {
            variableName = variableName.substring(1);
        }
        CodeData[] arrayResult = projectModel.getArrayVariables(fileName, variableName, lastWord, this.determineObjectTypeFromOtherFile);
        if (lastWord.length() == 0) {
            functions = projectModel.getFunctions();
            constans = this.disableConstants ? null : projectModel.getConstants();
        } else {
            functions = projectModel.getFunctions(lastWord);
            constans = this.disableConstants ? null : projectModel.getConstants(lastWord, this.constantCaseSensitive);
        }
        CodeData[] result = ModelSupport.merge((CodeData[])functions, (CodeData[])ModelSupport.merge((CodeData[])arrayResult, (CodeData[])constans));
        this.completionProposalGroup = this.arrayCompletionProposalGroup;
        this.completionProposalGroup.setData(offset, result, lastWord, selectionLength);
        return true;
    }

    protected ICompletionProposal[] merg(ICompletionProposal[] sortedArray1, ICompletionProposal[] sortedArray2) {
        int firstLength = sortedArray1 == null ? 0 : sortedArray1.length;
        int secondLength = sortedArray2 == null ? 0 : sortedArray2.length;
        ICompletionProposal[] mergedAndSorted = new ICompletionProposal[firstLength + secondLength];
        int position = 0;
        if (sortedArray1 != null) {
            System.arraycopy(sortedArray1, 0, mergedAndSorted, 0, firstLength);
            position = firstLength;
        }
        if (sortedArray2 != null) {
            System.arraycopy(sortedArray2, 0, mergedAndSorted, position, secondLength);
        }
        Arrays.sort(mergedAndSorted, proposalsComperator);
        return mergedAndSorted;
    }

    private class ArrayCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ArrayCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel projectModel, CodeData codeData) {
            if (!(codeData instanceof PHPVariableData)) {
                return super.createProposal(projectModel, codeData);
            }
            ArrayCompletionProposal proposal = new ArrayCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "'", "'", 1);
            return proposal;
        }

        private class ArrayCompletionProposal
        extends CodeDataCompletionProposal {
            public ArrayCompletionProposal(CodeData codeData, int offset, int length, int selectionLength, String prefix, String suffix, int caretOffsetInSuffix) {
                super(ArrayCompletionProposalGroup.this.projectModel, codeData, offset, length, selectionLength, prefix, suffix, caretOffsetInSuffix, false);
            }

            public void apply(IDocument document) {
                try {
                    char ch;
                    boolean insertCompletion = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistInsertCompletion");
                    if (!insertCompletion) {
                        this.removeTrailingCharacters(document);
                    }
                    if ((ch = document.getChar(this.replacementOffset - 1)) == '\'' || ch == '\"') {
                        --this.replacementOffset;
                        ++this.replacementLength;
                        int position = this.replacementOffset + this.replacementLength + this.selectionLength;
                        int length = document.getLength();
                        int spacesToRemove = 0;
                        boolean removeSpaces = false;
                        while (position < length) {
                            char ch2 = document.getChar(position);
                            if (ch2 == ch) {
                                ++spacesToRemove;
                                removeSpaces = true;
                                break;
                            }
                            if (!Character.isWhitespace(ch2)) break;
                            ++spacesToRemove;
                            ++position;
                        }
                        if (removeSpaces) {
                            this.replacementLength += spacesToRemove;
                        }
                    }
                    document.replace(this.replacementOffset, this.replacementLength + this.selectionLength, this.getReplacementString());
                }
                catch (BadLocationException badLocationException) {
                    super.apply(document);
                }
            }
        }
    }

    private class ClassConstructorCompletionProposalGroup
    extends CompletionProposalGroup {
        private ClassConstructorCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel projectModel, CodeData codeData) {
            return new CodeDataCompletionProposal(projectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", "()", 1, true);
        }
    }

    private class ClassStaticCallCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ClassStaticCallCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel projectModel, CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return new CodeDataCompletionProposal(projectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "$", "", 0, false);
            }
            return super.createProposal(projectModel, codeData);
        }

        protected ICompletionProposal[] calcCompletionProposals(PHPProjectModel projectModel) {
            CodeData[] tmp;
            if (this.key.length() == 0) {
                return super.calcCompletionProposals(projectModel);
            }
            if (this.key.charAt(0) == '$') {
                tmp = ModelSupport.getFilteredCodeData((CodeData[])this.codeDataProposals, (CodeDataFilter)ModelSupport.STATIC_VARIABLES_FILTER);
                tmp = ModelSupport.getCodeDataStartingWith((CodeData[])tmp, (String)this.key.substring(1));
            } else {
                tmp = ModelSupport.getCodeDataStartingWith((CodeData[])this.codeDataProposals, (String)this.key);
                tmp = ModelSupport.getFilteredCodeData((CodeData[])tmp, (CodeDataFilter)ModelSupport.NOT_STATIC_VARIABLES_FILTER);
            }
            ICompletionProposal[] result = new CodeDataCompletionProposal[tmp.length];
            int i = 0;
            while (i < tmp.length) {
                result[i] = this.createProposal(projectModel, tmp[i]);
                ++i;
            }
            return result;
        }
    }

    private class ClassVariableCallCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ClassVariableCallCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel projectModel, CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return new CodeDataCompletionProposal(projectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "$", "", 0, false);
            }
            return super.createProposal(projectModel, codeData);
        }
    }

    private class NewStatementCompletionProposalGroup
    extends CompletionProposalGroup {
        private NewStatementCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel projectModel, CodeData codeData) {
            PHPCodeData phpCodeData = (PHPCodeData)codeData;
            if (phpCodeData instanceof PHPClassData) {
                PHPClassData classData = (PHPClassData)phpCodeData;
                PHPFunctionData constructor = classData.getUserData() != null ? PHPModelUtil.getRealConstructor((PHPProjectModel)projectModel, (String)classData.getUserData().getFileName(), (PHPClassData)classData) : null;
                int suffixOffset = constructor != null && constructor.getParameters().length > 0 ? 1 : 2;
                return new CodeDataCompletionProposal(projectModel, (CodeData)classData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", "()", suffixOffset, true);
            }
            return new CodeDataCompletionProposal(projectModel, (CodeData)phpCodeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", "()", 2, true);
        }
    }

    protected class PHPCompletionProposalGroup
    extends CompletionProposalGroup {
        protected PHPCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel projectModel, CodeData codeData) {
            String suffix = " ";
            int caretOffsetInSuffix = 1;
            boolean showTypeHints = false;
            if (codeData instanceof PHPKeywordData) {
                PHPKeywordData phpKeywordData = (PHPKeywordData)codeData;
                suffix = phpKeywordData.getSuffix();
                caretOffsetInSuffix = phpKeywordData.getSuffixOffset();
            } else if (codeData instanceof PHPTagData) {
                suffix = "";
                caretOffsetInSuffix = 0;
            } else if (codeData instanceof PHPFunctionData) {
                String returnType;
                boolean hasArgs;
                PHPFunctionData phpFunctionData = (PHPFunctionData)codeData;
                suffix = "()";
                showTypeHints = true;
                caretOffsetInSuffix = 2;
                boolean bl = hasArgs = phpFunctionData.getParameters().length > 0;
                if (hasArgs) {
                    --caretOffsetInSuffix;
                }
                if ((returnType = phpFunctionData.getReturnType()) != null && returnType.compareToIgnoreCase("void") == 0) {
                    suffix = String.valueOf(suffix) + ";";
                    if (!hasArgs) {
                        ++caretOffsetInSuffix;
                    }
                }
            } else if (codeData instanceof PHPVariableData || codeData instanceof PHPConstantData || codeData instanceof PHPClassConstData) {
                suffix = "";
                caretOffsetInSuffix = 0;
            }
            return new CodeDataCompletionProposal(projectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", suffix, caretOffsetInSuffix, showTypeHints);
        }
    }

    static class PHPTagData
    extends PHPCodeDataFactory.PHPFunctionDataImp {
        PHPTagData() {
            super("php", 0, null, null, PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, "");
        }

        public void accept(Visitor v) {
            if (v instanceof PHPCompletionRendererVisitor) {
                ((PHPCompletionRendererVisitor)v).visit(this);
            } else {
                super.accept(v);
            }
        }
    }

    private class RegularPHPCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private RegularPHPCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel projectModel, CodeData codeData) {
            if (!(codeData instanceof PHPClassData)) {
                return super.createProposal(projectModel, codeData);
            }
            return new CodeDataCompletionProposal(projectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", ContentAssistSupport.CLASS_FUNCTIONS_TRIGGER, 2, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum States {
        CATCH,
        NEW,
        INSTANCEOF;

    }
}

