/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.SimplePHPCodeDataVisitor;
import org.eclipse.php.internal.core.util.Visitor;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.ContentAssistSupport;
import org.eclipse.php.internal.ui.util.PHPElementImageProvider;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class PHPCompletionRendererVisitor
extends SimplePHPCodeDataVisitor {
    private String text;
    private Image image;
    protected StringBuffer buffer = new StringBuffer();

    public void init(CodeData codeData) {
        this.buffer.setLength(0);
        codeData.accept((Visitor)this);
        this.text = this.buffer.toString();
    }

    public String getDisplayString() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public void visit(CodeData codeData) {
        this.buffer.append(codeData.getName());
    }

    public void visit(PHPFunctionData codeData) {
        int modifiers = codeData.getModifiers();
        int flags = this.computeAdornments(modifiers, 0);
        this.image = PHPModifier.isProtected((int)modifiers) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_MISC_PROTECTED, flags, PHPElementImageProvider.SMALL_SIZE) : (PHPModifier.isPrivate((int)modifiers) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_MISC_PRIVATE, flags, PHPElementImageProvider.SMALL_SIZE) : PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_MISC_PUBLIC, flags, PHPElementImageProvider.SMALL_SIZE));
        this.buffer.append(codeData.getName());
        this.buffer.append("(");
        PHPFunctionData.PHPFunctionParameter[] parameters = codeData.getParameters();
        int i = 0;
        while (i < parameters.length) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            this.visit(parameters[i]);
            ++i;
        }
        this.buffer.append(")");
        String rt = codeData.getReturnType().trim();
        rt = rt.split(" ", 2)[0];
        rt = "  " + rt;
        this.buffer.append(rt);
    }

    public void visit(ContentAssistSupport.PHPTagData codeData) {
        this.image = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_KEYWORD);
        this.buffer.append("php");
    }

    public void visit(PHPClassVarData codeData) {
        int modifiers = codeData.getModifiers();
        int flags = this.computeAdornments(modifiers, 0);
        this.image = PHPModifier.isProtected((int)modifiers) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_FIELD_PROTECTED, flags, PHPElementImageProvider.SMALL_SIZE) : (PHPModifier.isPrivate((int)modifiers) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_FIELD_PRIVATE, flags, PHPElementImageProvider.SMALL_SIZE) : PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_FIELD_PUBLIC, flags, PHPElementImageProvider.SMALL_SIZE));
        super.visit(codeData);
    }

    public void visit(PHPClassConstData codeData) {
        this.image = PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_CONSTANT, 2, PHPElementImageProvider.SMALL_SIZE);
        super.visit(codeData);
    }

    public void visit(PHPConstantData codeData) {
        this.image = PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_CONSTANT, 2, PHPElementImageProvider.SMALL_SIZE);
        super.visit(codeData);
    }

    public void visit(PHPClassData codeData) {
        int modifiers = codeData.getModifiers();
        int flags = this.computeAdornments(modifiers, 0);
        this.image = PHPModifier.isInterface((int)modifiers) ? PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_OBJS_INTERFACE, flags, PHPElementImageProvider.SMALL_SIZE) : PHPElementImageProvider.getDecoratedImage(PHPPluginImages.DESC_OBJS_CLASS, flags, PHPElementImageProvider.SMALL_SIZE);
        super.visit(codeData);
    }

    public void visit(PHPKeywordData codeData) {
        this.image = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_KEYWORD);
        super.visit(codeData);
    }

    public void visit(PHPVariableData codeData) {
        this.image = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_FIELD_PUBLIC);
        super.visit(codeData);
    }

    public void visit(PHPFunctionData.PHPFunctionParameter codeData) {
        String classType = codeData.getClassType();
        if (classType != null && classType.length() != 0) {
            this.buffer.append(classType).append(" ");
        }
        if (codeData.isConst()) {
            this.buffer.append("const ");
        }
        if (codeData.isReference()) {
            this.buffer.append("&");
        }
        if (this.buffer.length() > 0) {
            this.buffer.append("$");
        }
        this.buffer.append(codeData.getName());
        String defaultValue = codeData.getDefaultValue();
        if (defaultValue != null && defaultValue.length() != 0) {
            this.buffer.append(" = ").append(defaultValue);
        }
    }

    private int computeAdornments(int modifiers, int flags) {
        if (PHPModifier.isAbstract((int)modifiers)) {
            flags |= 4;
        }
        if (PHPModifier.isFinal((int)modifiers)) {
            flags |= 8;
        }
        if (PHPModifier.isStatic((int)modifiers)) {
            flags |= 1;
        }
        return flags;
    }
}

