/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.util.CodeDataResolver;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.hover.AbstractPHPTextHover;
import org.eclipse.php.internal.ui.editor.hover.AbstractReusableInformationControlCreator;
import org.eclipse.php.internal.ui.editor.hover.PHPSourceViewerInformationControl;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class PHPSourceTextHover
extends AbstractPHPTextHover
implements IInformationProviderExtension2,
ITextHoverExtension {
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    int shellStyle = 20;
                    int style = 768;
                    return new PHPSourceViewerInformationControl(parent, shellStyle, style);
                }
            };
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    return new PHPSourceViewerInformationControl(parent, 0, PHPSourceTextHover.this.getTooltipAffordanceString());
                }
            };
        }
        return this.fHoverControlCreator;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument document = textViewer.getDocument();
        if (document instanceof IStructuredDocument) {
            IStructuredDocument sDoc = (IStructuredDocument)document;
            try {
                CodeData[] codeDatas = CodeDataResolver.getInstance().resolve(sDoc, hoverRegion.getOffset());
                if (codeDatas.length != 0) {
                    ArrayList<String> hoverInfos = new ArrayList<String>(codeDatas.length);
                    int i = 0;
                    while (i < codeDatas.length) {
                        UserData userData;
                        CodeData codeData = codeDatas[i];
                        String hoverInfo = "";
                        if (!(codeData instanceof PHPVariableData) && (userData = codeData.getUserData()) != null) {
                            FindText findText = new FindText(codeData);
                            Display.getDefault().syncExec((Runnable)findText);
                            String text = findText.getText();
                            if (text != null) {
                                hoverInfo = this.formatHoverInfo(text);
                            } else {
                                IFile file = (IFile)PHPModelUtil.getResource((Object)codeData);
                                if (file != null) {
                                    BufferedReader r = new BufferedReader(new InputStreamReader(file.getContents()));
                                    int startPosition = userData.getStartPosition();
                                    int len = userData.getEndPosition() - startPosition;
                                    char[] buf = new char[len];
                                    r.skip(startPosition);
                                    r.read(buf, 0, len);
                                    r.close();
                                    hoverInfo = this.formatHoverInfo(new String(buf));
                                }
                            }
                        }
                        if (hoverInfo.length() != 0) {
                            hoverInfos.add(hoverInfo);
                        }
                        ++i;
                    }
                    return this.concatenateHoverInfos(hoverInfos);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return null;
    }

    private String concatenateHoverInfos(List hoverInfos) {
        StringBuffer concatenatedInfo = new StringBuffer();
        Iterator i = hoverInfos.iterator();
        while (i.hasNext()) {
            concatenatedInfo.append(i.next());
            if (!i.hasNext()) continue;
            concatenatedInfo.append("\n");
        }
        return concatenatedInfo.toString();
    }

    public String formatHoverInfo(String info) {
        String[] lines = (info = info.trim()).split("[\r\n]+");
        if (lines.length > 0) {
            String lastLine = lines[lines.length - 1];
            int numCharsToStrip = 0;
            while (Character.isWhitespace(lastLine.charAt(numCharsToStrip))) {
                ++numCharsToStrip;
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < lines.length) {
                int actuallyStrip = 0;
                while (actuallyStrip < numCharsToStrip && actuallyStrip < lines[i].length()) {
                    if (!Character.isWhitespace(lines[i].charAt(actuallyStrip))) break;
                    ++actuallyStrip;
                }
                buf.append(lines[i].substring(actuallyStrip));
                if (lines[i] != lastLine) {
                    buf.append("\n");
                }
                ++i;
            }
            info = buf.toString();
        }
        return info;
    }

    private static class FindText
    implements Runnable {
        final CodeData codeData;
        private String text = null;

        public FindText(CodeData codeData) {
            this.codeData = codeData;
        }

        public void run() {
            IEditorPart openInEditor = EditorUtility.isOpenInEditor(this.codeData);
            if (openInEditor == null || !(openInEditor instanceof PHPStructuredEditor)) {
                return;
            }
            StructuredTextViewer textViewer = ((PHPStructuredEditor)openInEditor).getTextViewer();
            IDocument document = textViewer.getDocument();
            UserData userData = this.codeData.getUserData();
            if (userData == null || document == null) {
                return;
            }
            int startPosition = userData.getStartPosition();
            int len = userData.getEndPosition() - startPosition;
            try {
                this.text = document.get(startPosition, len);
            }
            catch (BadLocationException badLocationException) {
                this.text = null;
            }
        }

        public String getText() {
            return this.text;
        }
    }
}

