/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class PhpTemplateProposal
extends TemplateProposal
implements ICompletionProposalExtension4 {
    public PhpTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    protected Template getTemplateNew() {
        return super.getTemplate();
    }

    public String getAdditionalProposalInfo() {
        String additionalInfo = super.getAdditionalProposalInfo();
        return StringUtils.convertToHTMLContent((String)additionalInfo);
    }

    public boolean isAutoInsertable() {
        return this.getTemplate().isAutoInsertable();
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IStructuredDocument document = (IStructuredDocument)viewer.getDocument();
        String originalTemplate = this.getTemplate().getPattern();
        String blanks = "";
        int lineNumber = document.getLineOfOffset(offset);
        try {
            IRegion lineRegion = document.getLineInformation(lineNumber);
            blanks = FormatterUtils.getLineBlanks((IStructuredDocument)document, (IRegion)lineRegion);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            super.apply(viewer, trigger, stateMask, offset);
            return;
        }
        String docLineDelimiter = document.getLineDelimiter();
        String lineDelimiter = "\n";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(String.valueOf(docLineDelimiter) + "|" + lineDelimiter);
        Matcher m = p.matcher(originalTemplate);
        boolean result = m.find();
        while (result) {
            m.group(0);
            m.appendReplacement(sb, String.valueOf(docLineDelimiter) + blanks);
            result = m.find();
        }
        m.appendTail(sb);
        String newTemplate = sb.toString();
        this.getTemplate().setPattern(newTemplate);
        super.apply(viewer, trigger, stateMask, offset);
        this.getTemplate().setPattern(originalTemplate);
    }
}

