/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.util;

import java.util.ArrayList;
import org.eclipse.php.internal.core.phpModel.phpElementData.BasicPHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlockImp;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;

public class PHPDocTool {
    public static PHPDocBlock createPhpDoc(CodeData codeData) {
        return PHPDocTool.createPhpDoc(codeData, null);
    }

    public static PHPDocBlock createPhpDoc(CodeData codeData, String shortDescription) {
        PHPDocBlock block = PHPDocTool.createDocBlock(codeData);
        if (shortDescription != null) {
            block.setShortDescription(shortDescription);
        }
        return block;
    }

    private static PHPDocBlock createDocBlock(CodeData codeData) {
        if (codeData instanceof PHPFunctionData) {
            return PHPDocTool.createFunctionDocBlock((PHPFunctionData)codeData);
        }
        if (codeData instanceof PHPClassData) {
            return PHPDocTool.createClassDocBlock();
        }
        if (codeData instanceof PHPFileData) {
            return PHPDocTool.createFileDocBlock();
        }
        if (codeData instanceof PHPClassVarData) {
            return PHPDocTool.createClassVarDocBlock();
        }
        if (codeData instanceof PHPVariableData) {
            return PHPDocTool.createVarDocBlock((PHPVariableData)codeData);
        }
        if (codeData instanceof PHPConstantData) {
            return PHPDocTool.createConstantDocBlock();
        }
        if (codeData instanceof PHPIncludeFileData) {
            return PHPDocTool.createIncludeDocBlock();
        }
        if (codeData instanceof PHPClassConstData) {
            return PHPDocTool.createClassConstantDocBlock();
        }
        return null;
    }

    private static PHPDocBlock createFunctionDocBlock(PHPFunctionData codeData) {
        PHPFunctionData.PHPFunctionParameter[] parameters = codeData.getParameters();
        ArrayList<BasicPHPDocTag> tagList = new ArrayList<BasicPHPDocTag>(parameters.length + 1);
        int i = 0;
        while (i < parameters.length) {
            String param = String.valueOf('$') + parameters[i].getName();
            param = parameters[i].getClassType() != null ? String.valueOf(parameters[i].getClassType()) + ' ' + param : "unknown_type " + param;
            BasicPHPDocTag paramTag = new BasicPHPDocTag(7, param);
            tagList.add(paramTag);
            ++i;
        }
        String returnValue = codeData.getReturnType();
        if (returnValue == null) {
            returnValue = "unknown";
        } else if (!returnValue.equals("void")) {
            BasicPHPDocTag returnTag = new BasicPHPDocTag(6, returnValue);
            tagList.add(returnTag);
        }
        PHPDocTag[] tags = new PHPDocTag[tagList.size()];
        tagList.toArray(tags);
        return new PHPDocBlockImp(null, null, tags, 2);
    }

    private static PHPDocBlock createClassDocBlock() {
        return new PHPDocBlockImp(null, null, null, 1);
    }

    private static PHPDocBlock createFileDocBlock() {
        BasicPHPDocTag packageTag = new BasicPHPDocTag(13, "defaultPackage");
        BasicPHPDocTag authorTag = new BasicPHPDocTag(1, System.getProperty("user.name"));
        PHPDocTag[] tags = new PHPDocTag[]{authorTag, packageTag};
        return new PHPDocBlockImp(null, null, tags, 0);
    }

    private static PHPDocBlock createClassVarDocBlock() {
        int id = 9;
        BasicPHPDocTag varTag = new BasicPHPDocTag(12, "unknown_type");
        PHPDocTag[] tags = new PHPDocTag[]{varTag};
        return new PHPDocBlockImp(null, null, tags, id);
    }

    private static PHPDocBlock createVarDocBlock(PHPVariableData codeData) {
        BasicPHPDocTag globalTag = null;
        int id = 3;
        if (codeData.isGlobal()) {
            globalTag = new BasicPHPDocTag(4, codeData.getName());
            id = 4;
        }
        PHPDocTag[] tags = null;
        if (globalTag != null) {
            tags = new PHPDocTag[]{globalTag};
        }
        return new PHPDocBlockImp(null, null, tags, id);
    }

    private static PHPDocBlock createConstantDocBlock() {
        return new PHPDocBlockImp(null, null, null, 5);
    }

    private static PHPDocBlock createIncludeDocBlock() {
        return new PHPDocBlockImp(null, null, null, 7);
    }

    private static PHPDocBlock createClassConstantDocBlock() {
        return new PHPDocBlockImp(null, null, null, 5);
    }
}

