/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.actions.BuildActionGroup;
import org.eclipse.php.internal.ui.actions.CCPActionGroup;
import org.eclipse.php.internal.ui.actions.CompositeActionGroup;
import org.eclipse.php.internal.ui.actions.ConfigureIncludePathActionGroup;
import org.eclipse.php.internal.ui.actions.ConvertProjectActionGroup;
import org.eclipse.php.internal.ui.actions.CustomFiltersActionGroup;
import org.eclipse.php.internal.ui.actions.ImportActionGroup;
import org.eclipse.php.internal.ui.actions.NavigateActionGroup;
import org.eclipse.php.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.php.internal.ui.actions.ProjectActionGroup;
import org.eclipse.php.internal.ui.actions.RefactorActionGroup;
import org.eclipse.php.internal.ui.explorer.CollapseAllAction;
import org.eclipse.php.internal.ui.explorer.ExplorerFrameSource;
import org.eclipse.php.internal.ui.explorer.ExplorerPart;
import org.eclipse.php.internal.ui.explorer.PHPSearchActionGroup;
import org.eclipse.php.internal.ui.explorer.ToggleLinkingAction;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.workingset.ExplorerViewActionGroup;
import org.eclipse.php.internal.ui.workingset.WorkingSetModel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.UpAction;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;

public class ExplorerActionGroup
extends CompositeActionGroup {
    private ExplorerPart fPart;
    private CollapseAllAction fCollapseAllAction;
    private GoIntoAction fZoomInAction;
    private BackAction fBackAction;
    private ForwardAction fForwardAction;
    private UpAction fUpAction;
    private FrameList fFrameList;
    private ToggleLinkingAction fToggleLinkingAction;
    private RefactorActionGroup fRefactorActionGroup;
    private NavigateActionGroup fNavigateActionGroup;
    private ExplorerViewActionGroup fViewActionGroup;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;

    public ExplorerActionGroup(ExplorerPart part) {
        this.fPart = part;
        TreeViewer viewer = part.getViewer();
        IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ExplorerActionGroup.this.doWorkingSetChanged(event);
            }
        };
        IWorkbenchPartSite site = this.fPart.getSite();
        ActionGroup[] actionGroupArray = new ActionGroup[12];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)site);
        this.fNavigateActionGroup = new NavigateActionGroup((IViewPart)this.fPart);
        actionGroupArray[1] = this.fNavigateActionGroup;
        actionGroupArray[2] = new PHPSearchActionGroup();
        actionGroupArray[3] = new CCPActionGroup((IViewPart)this.fPart);
        actionGroupArray[4] = new ConfigureIncludePathActionGroup((IViewPart)this.fPart);
        this.fRefactorActionGroup = new RefactorActionGroup((IViewPart)this.fPart);
        actionGroupArray[5] = this.fRefactorActionGroup;
        actionGroupArray[6] = new ImportActionGroup((IViewPart)this.fPart);
        actionGroupArray[7] = new BuildActionGroup((IViewPart)this.fPart);
        actionGroupArray[8] = new ProjectActionGroup((IViewPart)this.fPart);
        this.fViewActionGroup = new ExplorerViewActionGroup(this.fPart.getRootMode(), workingSetListener, site);
        actionGroupArray[9] = this.fViewActionGroup;
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this.fPart, (StructuredViewer)viewer);
        actionGroupArray[10] = this.fCustomFiltersActionGroup;
        actionGroupArray[11] = new ConvertProjectActionGroup((IViewPart)this.fPart);
        this.setGroups(actionGroupArray);
        this.fViewActionGroup.fillFilters((StructuredViewer)viewer);
        ExplorerFrameSource frameSource = new ExplorerFrameSource(this.fPart);
        this.fFrameList = new FrameList((IFrameSource)frameSource);
        frameSource.connectTo(this.fFrameList);
        this.fZoomInAction = new GoIntoAction(this.fFrameList);
        this.fBackAction = new BackAction(this.fFrameList);
        this.fForwardAction = new ForwardAction(this.fFrameList);
        this.fUpAction = new UpAction(this.fFrameList);
        this.fCollapseAllAction = new CollapseAllAction(this.fPart);
        this.fToggleLinkingAction = new ToggleLinkingAction(this.fPart);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.setGlobalActionHandlers(actionBars);
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    void updateActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().removeAll();
        actionBars.getMenuManager().removeAll();
        this.fZoomInAction.setEnabled(true);
        this.fillActionBars(actionBars);
        actionBars.updateActionBars();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("goInto", (IAction)this.fZoomInAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.fBackAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.fForwardAction);
        actionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
        this.fRefactorActionGroup.retargetFileMenuActions(actionBars);
    }

    void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IAction)this.fBackAction);
        toolBar.add((IAction)this.fForwardAction);
        toolBar.add((IAction)this.fUpAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fCollapseAllAction);
        toolBar.add((IAction)this.fToggleLinkingAction);
    }

    void fillViewMenu(IMenuManager menu) {
        menu.add((IAction)this.fToggleLinkingAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        Object element = selection.getFirstElement();
        this.addOpenNewWindowAction(menu, element);
        super.fillContextMenu(menu);
    }

    private void addOpenNewWindowAction(IMenuManager menu, Object element) {
        if (element instanceof PHPCodeData || element instanceof PHPProjectModel) {
            element = PHPModelUtil.getResource((Object)element);
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return;
        }
        if (!(element instanceof IContainer)) {
            return;
        }
        menu.appendToGroup("group.open", (IAction)new OpenInNewWindowAction(this.fPart.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    void handleDoubleClick(DoubleClickEvent event) {
        Object element;
        TreeViewer viewer = this.fPart.getViewer();
        if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
            if (this.doubleClickGoesInto()) {
                if (element instanceof PHPFileData) {
                    return;
                }
                if (element instanceof IContainer) {
                    this.fZoomInAction.run();
                }
                if (element instanceof IJavaScriptUnit || element instanceof IClassFile) {
                    return;
                }
                if (element instanceof IOpenable || element instanceof IContainer || element instanceof IWorkingSet) {
                    this.fZoomInAction.run();
                }
            } else {
                IAction openAction = this.fNavigateActionGroup.getOpenAction();
                if (openAction != null && openAction.isEnabled() && OpenStrategy.getOpenMethod() == 0 && !(element instanceof PHPFileData) && !(element instanceof IFile)) {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
                return;
            }
        }
    }

    void handleOpen(OpenEvent event) {
        IAction openAction = this.fNavigateActionGroup.getOpenAction();
        if (openAction != null && openAction.isEnabled()) {
            openAction.run();
            return;
        }
    }

    void handleKeyEvent(KeyEvent event) {
        if (event.stateMask != 0) {
            return;
        }
        if (event.keyCode == 8 && this.fUpAction != null && this.fUpAction.isEnabled()) {
            this.fUpAction.run();
            event.doit = false;
        }
    }

    private boolean doubleClickGoesInto() {
        return "phpviewGointo".equals(PreferenceConstants.getPreferenceStore().getString("phpviewDoubleclick"));
    }

    public FrameAction getUpAction() {
        return this.fUpAction;
    }

    public FrameAction getBackAction() {
        return this.fBackAction;
    }

    public FrameAction getForwardAction() {
        return this.fForwardAction;
    }

    public ExplorerViewActionGroup getWorkingSetActionGroup() {
        return this.fViewActionGroup;
    }

    private void doWorkingSetChanged(PropertyChangeEvent event) {
        if (ExplorerViewActionGroup.MODE_CHANGED.equals(event.getProperty())) {
            this.fPart.rootModeChanged((Integer)event.getNewValue());
            WorkingSetModel oldInput = null;
            Object newInput = null;
            if (this.fPart.showProjects()) {
                oldInput = this.fPart.getWorkingSetModel();
                newInput = PHPWorkspaceModelManager.getInstance();
            } else if (this.fPart.showWorkingSets()) {
                oldInput = PHPWorkspaceModelManager.getInstance();
                newInput = this.fPart.getWorkingSetModel();
            }
            if (oldInput != null && newInput != null) {
                Frame frame;
                int i = 0;
                while ((frame = this.fFrameList.getFrame(i)) != null) {
                    TreeFrame treeFrame;
                    if (frame instanceof TreeFrame && oldInput.equals((treeFrame = (TreeFrame)frame).getInput())) {
                        treeFrame.setInput(newInput);
                    }
                    ++i;
                }
            }
        } else {
            IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
            String workingSetName = null;
            if (workingSet != null) {
                workingSetName = workingSet.getName();
            }
            this.fPart.setWorkingSetName(workingSetName);
            this.fPart.updateTitle();
            String property = event.getProperty();
            if ("workingSetContentChange".equals(property)) {
                TreeViewer viewer = this.fPart.getViewer();
                viewer.getControl().setRedraw(false);
                viewer.refresh();
                viewer.getControl().setRedraw(true);
            }
        }
    }

    void restoreFilterAndSorterState(IMemento memento) {
        this.fViewActionGroup.restoreState(memento);
        this.fCustomFiltersActionGroup.restoreState(memento);
    }

    void saveFilterAndSorterState(IMemento memento) {
        this.fViewActionGroup.saveState(memento);
        this.fCustomFiltersActionGroup.saveState(memento);
    }
}

