/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.filters;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.util.StringMatcher;

public class NamePatternFilter
extends ViewerFilter {
    private String[] fPatterns;
    private StringMatcher[] fMatchers;

    private StringMatcher[] getMatchers() {
        return this.fMatchers;
    }

    public String[] getPatterns() {
        return this.fPatterns;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String matchName = null;
        if (element instanceof PHPCodeData) {
            matchName = ((PHPCodeData)element).getName();
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            PHPCodeData phpElement = (PHPCodeData)adaptable.getAdapter(PHPCodeData.class);
            if (phpElement != null) {
                matchName = phpElement.getName();
            } else {
                IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                if (resource != null) {
                    matchName = resource.getName();
                }
            }
        }
        if (matchName != null) {
            StringMatcher[] testMatchers = this.getMatchers();
            int i = 0;
            while (i < testMatchers.length) {
                if (testMatchers[i].match(matchName)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return true;
    }

    public void setPatterns(String[] newPatterns) {
        this.fPatterns = newPatterns;
        this.fMatchers = new StringMatcher[newPatterns.length];
        int i = 0;
        while (i < newPatterns.length) {
            this.fMatchers[i] = new StringMatcher(newPatterns[i], true, false);
            ++i;
        }
    }
}

