/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public class Element {
    public final ElementType type;
    public final String name;
    public final Element parent;
    public final int index;
    public int length;

    Element(Element parent, ElementType type, String name, int length) {
        this(parent, type, name, length, 0);
    }

    Element(Element parent, ElementType type, String name, int length, int index) {
        this.type = type;
        this.name = name;
        this.parent = parent;
        this.index = index;
        this.length = length;
    }

    public Element(ElementType type, String name, int length) {
        this(null, type, name, length);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        assert (obj instanceof Element);
        Element other = (Element)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null) {
            if (other.type != null) {
                return false;
            }
        } else {
            if (!this.type.equals((Object)other.type)) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Element ");
        buffer.append(this.type.toString());
        buffer.append(": ");
        buffer.append(", Name: ");
        buffer.append(this.name);
        buffer.append(", Parent: ");
        buffer.append(this.parent);
        buffer.append(", Index: ");
        buffer.append(this.index);
        buffer.append("]");
        return buffer.toString();
    }

    public static class ElementFactory {
        private ElementFactory() {
        }

        public static Element createDocElement(Element container, PHPDocBlock codeData) {
            return new Element(container, ElementType.DOC, container.name, codeData.getEndPosition() - codeData.getStartPosition());
        }

        public static Element createFileElement(PHPFileData codeData) {
            return ElementFactory.createElement(null, (PHPCodeData)codeData, 0);
        }

        public static Element createElement(Element container, PHPCodeData codeData, int index) {
            Element element = null;
            if (codeData instanceof PHPFileData) {
                element = new Element(ElementType.FILE, codeData.getName(), 0);
            } else if (codeData instanceof PHPClassData) {
                element = new Element(container, ElementType.CLASS, codeData.getName(), ElementFactory.getLength(codeData), index);
            } else if (codeData instanceof PHPFunctionData) {
                element = container.type == ElementType.FILE ? new Element(container, ElementType.FUNCTION, codeData.getName(), ElementFactory.getLength(codeData), index) : new Element(container, ElementType.METHOD, codeData.getName(), ElementFactory.getLength(codeData), index);
            } else if (codeData instanceof PHPClassVarData) {
                element = new Element(container, ElementType.FIELD, codeData.getName(), ElementFactory.getLength(codeData), index);
            } else if (codeData instanceof PHPClassConstData) {
                assert (container != null);
                element = new Element(container, ElementType.CONSTANT, codeData.getName(), ElementFactory.getLength(codeData), index);
            } else {
                throw new IllegalStateException("Internal Error: CodeData is not supported as folded element");
            }
            return element;
        }

        private static final int getLength(PHPCodeData codeData) {
            int len = codeData.getUserData().getEndPosition() - codeData.getUserData().getStartPosition();
            return len < 0 ? 0 : len;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementType {
        FILE("File"),
        CLASS("Class"),
        FUNCTION("Function"),
        METHOD("Method"),
        FIELD("Field"),
        CONSTANT("Constant"),
        DOC("PHP Doc");

        private final String elementTypeName;

        private ElementType(String elementTypeName) {
            this.elementTypeName = elementTypeName;
        }

        public String toString() {
            return this.elementTypeName;
        }
    }
}

