/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.folding.projection.CaptionedPosition;
import org.eclipse.php.internal.ui.folding.projection.CommentPosition;
import org.eclipse.php.internal.ui.folding.projection.Element;
import org.eclipse.php.internal.ui.folding.projection.ElementProjectionAnnotation;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryPHP;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterHTML;
import org.eclipse.php.internal.ui.folding.projection.ProjectionViewerInformation;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionModelNodeAdapterPHP
extends ProjectionModelNodeAdapterHTML {
    private IStructuredDocument document;
    private boolean shouldAutoCollapseAnnotations = true;

    public ProjectionModelNodeAdapterPHP(ProjectionModelNodeAdapterFactoryPHP factory) {
        super(factory);
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == ProjectionModelNodeAdapterPHP.class;
    }

    @Override
    public void updateAdapter(Node node, ProjectionViewer viewer) {
        HashMap<ProjectionAnnotation, Position> addedAnnotations = new HashMap<ProjectionAnnotation, Position>();
        HashMap<ProjectionAnnotation, Position> currentAnnotations = new HashMap<ProjectionAnnotation, Position>();
        if (node != null && node instanceof NodeImpl) {
            ProjectionViewerInformation information;
            NodeImpl element = (NodeImpl)node;
            assert (element.getModel() instanceof DOMModelForPHP) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.0");
            DOMModelForPHP phpModel = (DOMModelForPHP)element.getModel();
            this.document = phpModel.getStructuredDocument();
            ProjectionViewer modelViewer = this.getAdapterFactory().findViewer(phpModel);
            if (modelViewer == null) {
                return;
            }
            if (modelViewer instanceof PHPStructuredTextViewer) {
                PHPStructuredTextViewer v = (PHPStructuredTextViewer)modelViewer;
                if (v.isUndoOperation) {
                    return;
                }
            }
            if ((information = this.getAdapterFactory().getInformation(modelViewer)).isDocumentChanging()) {
                return;
            }
            PHPFileData fileData = phpModel.getFileData();
            if (fileData == null) {
                return;
            }
            this.createAnnotationsForChild(addedAnnotations, currentAnnotations, fileData, node.getFirstChild());
            ProjectionAnnotation[] oldList = null;
            if (!this.previousAnnotations.isEmpty()) {
                oldList = this.previousAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            if (viewer != null && !currentAnnotations.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, null, currentAnnotations, null, viewer);
            }
            if (oldList != null && oldList.length > 0 || !addedAnnotations.isEmpty() || currentAnnotations.size() > 0) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, (Annotation[])oldList, addedAnnotations, currentAnnotations);
            }
            this.shouldAutoCollapseAnnotations = false;
        }
        this.previousAnnotations = currentAnnotations;
    }

    private final Node createAnnotationsForChild(Map<ProjectionAnnotation, Position> addedAnnotations, Map<ProjectionAnnotation, Position> currentAnnotations, PHPFileData fileData, Node childNode) {
        while (childNode != null) {
            if (childNode.getNodeType() == 1) {
                assert (childNode instanceof ElementImplForPhp) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.1");
                ElementImplForPhp childElement = (ElementImplForPhp)childNode;
                if (childElement.isPhpTag()) {
                    int startOffset = childElement.getStartOffset();
                    int endOffset = childElement.getEndOffset();
                    this.createFileAnnotations(currentAnnotations, addedAnnotations, fileData, startOffset, endOffset);
                }
                childElement.getFirstChild();
                this.createAnnotationsForChild(addedAnnotations, currentAnnotations, fileData, childElement.getFirstChild());
            }
            childNode = childNode.getNextSibling();
        }
        return childNode;
    }

    private void createFileAnnotations(Map<ProjectionAnnotation, Position> currentAnnotations, Map<ProjectionAnnotation, Position> addedAnnotations, PHPFileData fileData, int startOffset, int endOffset) {
        ProjectionModelNodeAdapterFactoryPHP adapterFactory = this.getAdapterFactory();
        assert (adapterFactory != null) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.2");
        boolean foldingPhpDoc = adapterFactory.isFoldingPhpDoc();
        boolean foldingFunctions = adapterFactory.isFoldingFunctions();
        boolean foldingClasses = adapterFactory.isFoldingClasses();
        Element fileElement = Element.ElementFactory.createFileElement(fileData);
        this.createDocBlockAnnotations(fileElement, (PHPCodeData)fileData, currentAnnotations, addedAnnotations, startOffset, endOffset, foldingPhpDoc);
        PHPClassData[] classes = fileData.getClasses();
        HashMap<String, Integer> classIndices = new HashMap<String, Integer>();
        PHPClassData[] pHPClassDataArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            PHPClassData classData = pHPClassDataArray[n2];
            Integer classIndex = (Integer)classIndices.get(classData.getName());
            classIndex = classIndex == null ? Integer.valueOf(0) : Integer.valueOf(classIndex + 1);
            classIndices.put(classData.getName(), classIndex);
            Element classElement = this.createCodeDataAnnotations(fileElement, (PHPCodeData)classData, currentAnnotations, addedAnnotations, classIndex, startOffset, endOffset, foldingClasses, foldingPhpDoc);
            PHPFunctionData[] methods = classData.getFunctions();
            HashMap<String, Integer> methodIndices = new HashMap<String, Integer>();
            PHPFunctionData[] pHPFunctionDataArray = methods;
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                PHPFunctionData methodData = pHPFunctionDataArray[n4];
                Integer methodIndex = (Integer)methodIndices.get(methodData.getName());
                methodIndex = methodIndex == null ? Integer.valueOf(0) : Integer.valueOf(methodIndex + 1);
                methodIndices.put(methodData.getName(), methodIndex);
                this.createCodeDataAnnotations(classElement, (PHPCodeData)methodData, currentAnnotations, addedAnnotations, methodIndex, startOffset, endOffset, foldingFunctions, foldingPhpDoc);
                ++n4;
            }
            PHPClassVarData[] variables = classData.getVars();
            HashMap<String, Integer> variableIndices = new HashMap<String, Integer>();
            PHPClassVarData[] pHPClassVarDataArray = variables;
            int methodIndex = variables.length;
            int n5 = 0;
            while (n5 < methodIndex) {
                PHPClassVarData variableData = pHPClassVarDataArray[n5];
                Integer variableIndex = (Integer)variableIndices.get(variableData.getName());
                variableIndex = variableIndex == null ? Integer.valueOf(0) : Integer.valueOf(variableIndex + 1);
                variableIndices.put(variableData.getName(), variableIndex);
                this.createCodeDataAnnotations(classElement, (PHPCodeData)variableData, currentAnnotations, addedAnnotations, variableIndex, startOffset, endOffset, false, foldingPhpDoc);
                ++n5;
            }
            PHPClassConstData[] constants = classData.getConsts();
            HashMap<String, Integer> constantIndices = new HashMap<String, Integer>();
            PHPClassConstData[] pHPClassConstDataArray = constants;
            int n6 = constants.length;
            int n7 = 0;
            while (n7 < n6) {
                PHPClassConstData constantData = pHPClassConstDataArray[n7];
                Integer constantIndex = (Integer)constantIndices.get(constantData.getName());
                constantIndex = constantIndex == null ? Integer.valueOf(0) : Integer.valueOf(constantIndex + 1);
                constantIndices.put(constantData.getName(), constantIndex);
                this.createCodeDataAnnotations(classElement, (PHPCodeData)constantData, currentAnnotations, addedAnnotations, constantIndex, startOffset, endOffset, false, foldingPhpDoc);
                ++n7;
            }
            ++n2;
        }
        PHPFunctionData[] functions = fileData.getFunctions();
        HashMap<String, Integer> functionIndices = new HashMap<String, Integer>();
        PHPFunctionData[] pHPFunctionDataArray = functions;
        int n8 = functions.length;
        int n9 = 0;
        while (n9 < n8) {
            PHPFunctionData functionData = pHPFunctionDataArray[n9];
            Integer functionIndex = (Integer)functionIndices.get(functionData.getName());
            functionIndex = functionIndex == null ? Integer.valueOf(0) : Integer.valueOf(functionIndex + 1);
            functionIndices.put(functionData.getName(), functionIndex);
            this.createCodeDataAnnotations(fileElement, (PHPCodeData)functionData, currentAnnotations, addedAnnotations, functionIndex, startOffset, endOffset, foldingFunctions, foldingPhpDoc);
            ++n9;
        }
    }

    private Element createCodeDataAnnotations(Element parentElement, PHPCodeData codeData, Map<ProjectionAnnotation, Position> currentAnnotations, Map<ProjectionAnnotation, Position> addedAnnotations, int index, int startOffset, int endOffset, boolean collapse, boolean collapseDoc) {
        UserData userData = codeData.getUserData();
        int codeStartOffset = userData.getStartPosition();
        int codeEndOffset = userData.getEndPosition();
        boolean createAnnotation = this.document.getLineOfOffset(codeStartOffset) != this.document.getLineOfOffset(codeEndOffset);
        createAnnotation &= codeStartOffset > startOffset && codeStartOffset < endOffset;
        ElementProjectionAnnotation newAnnotation = new ElementProjectionAnnotation(parentElement, codeData, index, this.shouldAutoCollapseAnnotations ? collapse : false);
        ElementProjectionAnnotation existingAnnotation = this.getExistingAnnotation(newAnnotation);
        Position newPosition = this.createPosition(codeStartOffset, userData.getEndPosition(), (IDocument)this.document);
        Element element = newAnnotation.element;
        if (createAnnotation) {
            if (existingAnnotation == null) {
                currentAnnotations.put(newAnnotation, newPosition);
                addedAnnotations.put(newAnnotation, newPosition);
            } else {
                currentAnnotations.put(existingAnnotation, newPosition);
                this.previousAnnotations.remove((Object)existingAnnotation);
            }
        }
        this.createDocBlockAnnotations(element, codeData, currentAnnotations, addedAnnotations, startOffset, endOffset, collapseDoc);
        return element;
    }

    private void createDocBlockAnnotations(Element parentElement, PHPCodeData codeData, Map<ProjectionAnnotation, Position> currentAnnotations, Map<ProjectionAnnotation, Position> addedAnnotations, int startOffset, int endOffset, boolean collapse) {
        PHPDocBlock docBlock = codeData.getDocBlock();
        if (docBlock == null) {
            return;
        }
        int codeStartOffset = docBlock.getStartPosition();
        int codeEndOffset = docBlock.getEndPosition();
        if (this.document.getLineOfOffset(codeStartOffset) >= this.document.getLineOfOffset(codeEndOffset)) {
            return;
        }
        if (codeStartOffset > startOffset && codeStartOffset < endOffset) {
            Position newPosition = this.createCommentPosition(codeStartOffset, docBlock.getEndPosition(), (IDocument)this.document);
            ElementProjectionAnnotation newAnnotation = new ElementProjectionAnnotation(parentElement, docBlock, this.shouldAutoCollapseAnnotations ? collapse : false);
            ElementProjectionAnnotation existingAnnotation = this.getExistingAnnotation(newAnnotation);
            if (existingAnnotation == null) {
                currentAnnotations.put(newAnnotation, newPosition);
                addedAnnotations.put(newAnnotation, newPosition);
            } else {
                currentAnnotations.put(existingAnnotation, newPosition);
                this.previousAnnotations.remove((Object)existingAnnotation);
            }
        }
    }

    private Position createPosition(int startOffset, int endOffset, IDocument document) {
        assert (document != null);
        IRegion alignRegion = this.alignRegion(startOffset, endOffset, document);
        return new CaptionedPosition(alignRegion.getOffset(), alignRegion.getLength());
    }

    private Position createCommentPosition(int startOffset, int endOffset, IDocument document) {
        assert (document != null);
        IRegion alignRegion = this.alignRegion(startOffset, endOffset, document);
        return new CommentPosition(alignRegion.getOffset(), alignRegion.getLength());
    }

    protected final IRegion alignRegion(int startOffset, int endOffsetOrg, IDocument document) {
        try {
            int length = document.getLength();
            int start = document.getLineOfOffset(startOffset);
            int end = document.getLineOfOffset(Math.min(length, endOffsetOrg));
            if (start >= end) {
                return new Region(startOffset, 0);
            }
            int offset = document.getLineOffset(start);
            int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
            return new Region(offset, endOffset - offset);
        }
        catch (BadLocationException badLocationException) {
            return new Region(startOffset, endOffsetOrg - startOffset);
        }
    }

    private ElementProjectionAnnotation getExistingAnnotation(ElementProjectionAnnotation projectionAnnotation) {
        assert (projectionAnnotation != null) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.3");
        if (!this.previousAnnotations.isEmpty()) {
            for (ProjectionAnnotation annotation : this.previousAnnotations.keySet()) {
                if (!projectionAnnotation.equals(annotation)) continue;
                ElementProjectionAnnotation annotation2 = (ElementProjectionAnnotation)annotation;
                annotation2.sameSize = projectionAnnotation.element.length == annotation2.element.length;
                annotation2.element.length = projectionAnnotation.element.length;
                return annotation2;
            }
        }
        return null;
    }

    private ProjectionModelNodeAdapterFactoryPHP getAdapterFactory() {
        assert (this.fAdapterFactory instanceof ProjectionModelNodeAdapterFactoryPHP) : PHPUIMessages.getString("ProjectionModelNodeAdapterPHP.4");
        return (ProjectionModelNodeAdapterFactoryPHP)this.fAdapterFactory;
    }
}

