/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.functions;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public class PHPFunctionsContentProvider
implements ITreeContentProvider {
    public static final String CONSTANTS_NODE_NAME = "constants";
    protected static final Object[] NO_CHILDREN = new Object[0];
    private PHPLanguageModel model;

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof PHPFileData) {
            return true;
        }
        if (element instanceof PHPProjectModel) {
            return true;
        }
        if (element instanceof PHPCodeData) {
            PHPCodeData codeData = (PHPCodeData)element;
            return PHPModelUtil.hasChildren((PHPCodeData)codeData);
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object getParent(Object element) {
        return null;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object element) {
        return PHPModelUtil.getParent((Object)element);
    }

    private Object[] getClassChildren(PHPClassData classData) {
        PHPFunctionData[] functions;
        PHPClassVarData[] vars;
        ArrayList<Object> list = new ArrayList<Object>();
        PHPClassConstData[] consts = classData.getConsts();
        if (consts != null) {
            int i = 0;
            while (i < consts.length) {
                list.add(consts[i]);
                ++i;
            }
        }
        if ((vars = classData.getVars()) != null) {
            int i = 0;
            while (i < vars.length) {
                list.add(vars[i]);
                ++i;
            }
        }
        if ((functions = classData.getFunctions()) != null) {
            int i = 0;
            while (i < functions.length) {
                list.add(functions[i]);
                ++i;
            }
        }
        return list.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (!this.exists(parentElement)) {
            return NO_CHILDREN;
        }
        if (parentElement instanceof PHPLanguageModel) {
            CodeData[] functions = this.model.getFunctions();
            CodeData[] classes = this.model.getClasses();
            Object[] rootsChildren = NO_CHILDREN;
            if (functions.length > 0 && classes.length > 0) {
                rootsChildren = new Object[classes.length + functions.length + 1];
                rootsChildren[0] = CONSTANTS_NODE_NAME;
                System.arraycopy(classes, 0, rootsChildren, 1, classes.length);
                System.arraycopy(functions, 0, rootsChildren, classes.length + 1, functions.length);
            }
            return rootsChildren;
        }
        if (parentElement instanceof PHPClassData) {
            return this.getClassChildren((PHPClassData)parentElement);
        }
        if (parentElement.equals(CONSTANTS_NODE_NAME)) {
            return this.model.getConstants();
        }
        return NO_CHILDREN;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            return;
        }
        this.model = (PHPLanguageModel)newInput;
    }
}

