/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathEntry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.ArchieveFileFilter;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElementAttribute;

public class IPListElement {
    private IProject fProject;
    private int fEntryKind;
    private int fContentKind;
    private IPath fPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private Object fParentContainer;
    private IIncludePathEntry fCachedEntry;
    private ArrayList fChildren;

    public IPListElement(IProject project, int entryKind, int contentKind, IPath path, IResource res) {
        this(null, project, entryKind, contentKind, path, res);
    }

    public IPListElement(Object parent, IProject project, int entryKind, int contentKind, IPath path, IResource res) {
        this.fProject = project;
        this.fEntryKind = entryKind;
        this.fContentKind = contentKind;
        this.fPath = path;
        this.fChildren = new ArrayList();
        this.fResource = res;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = parent;
        switch (entryKind) {
            case 3: {
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                throw new RuntimeException(PHPUIMessages.getString("IPListElement.0"));
            }
        }
    }

    public IIncludePathEntry getIncludePathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newIncludePathEntry();
        }
        return this.fCachedEntry;
    }

    private IIncludePathEntry newIncludePathEntry() {
        switch (this.fEntryKind) {
            case 3: {
                return IncludePathEntry.newSourceEntry((IPath)this.fPath, (IResource)this.fResource);
            }
            case 1: {
                return new IncludePathEntry(this.fContentKind, 1, this.fPath, this.fResource, this.isExported());
            }
            case 6: {
                return new IncludePathEntry(this.fContentKind, 6, this.fPath, this.fResource, this.isExported());
            }
            case 2: {
                return IncludePathEntry.newProjectEntry((IPath)this.fPath, (IResource)this.fResource, (boolean)this.isExported());
            }
            case 5: {
                return IncludePathEntry.newContainerEntry((IPath)this.fPath, (IResource)this.fResource, (boolean)this.isExported());
            }
            case 4: {
                return IncludePathEntry.newVariableEntry((IPath)this.fPath, (IResource)this.fResource, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public int getContentKind() {
        return this.fContentKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public IPListElementAttribute setAttribute(String key, Object value) {
        IPListElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        attribute.setValue(value);
        this.attributeChanged(key);
        return attribute;
    }

    public IPListElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            IPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof IPListElementAttribute && key.equals((elem = (IPListElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        IPListElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    private void createAttributeElement(String key, Object value, boolean builtIn) {
        this.fChildren.add(new IPListElementAttribute(this, key, value, builtIn));
    }

    private static boolean isFiltered(Object entry, String[] filteredKeys) {
        if (entry instanceof IPListElementAttribute) {
            String key = ((IPListElementAttribute)entry).getKey();
            int i = 0;
            while (i < filteredKeys.length) {
                if (key.equals(filteredKeys[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private Object[] getFilteredChildren(String[] filteredKeys) {
        int nChildren = this.fChildren.size();
        ArrayList res = new ArrayList(nChildren);
        int i = 0;
        while (i < nChildren) {
            Object curr = this.fChildren.get(i);
            if (!IPListElement.isFiltered(curr, filteredKeys)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray();
    }

    public Object[] getChildren(boolean hideOutputFolder) {
        if (hideOutputFolder && this.fEntryKind == 3) {
            return this.getFilteredChildren(new String[0]);
        }
        if (this.fEntryKind == 2) {
            return this.getFilteredChildren(new String[0]);
        }
        return this.fChildren.toArray();
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    private void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    private boolean canUpdateContainer() {
        throw new RuntimeException(PHPUIMessages.getString("IPListElement.0"));
    }

    public boolean isInNonModifiableContainer() {
        if (this.fParentContainer instanceof IPListElement) {
            return !((IPListElement)this.fParentContainer).canUpdateContainer();
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass().equals(this.getClass())) {
            IPListElement elem = (IPListElement)other;
            return this.getIncludePathEntry().equals(elem.getIncludePathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind + this.fContentKind;
    }

    public String toString() {
        return this.getIncludePathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public IProject getProject() {
        return this.fProject;
    }

    public static IPListElement createFromExisting(IIncludePathEntry curr, IProject project) {
        return IPListElement.createFromExisting(null, curr, project);
    }

    public static IPListElement createFromExisting(Object parent, IIncludePathEntry curr, IProject project) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = null;
        boolean isMissing = false;
        switch (curr.getEntryKind()) {
            case 5: {
                res = null;
                isMissing = project != null && PHPProjectOptions.getIncludePathContainer((IPath)path, (IProject)project) == null;
                break;
            }
            case 4: {
                IPath resolvedPath = PHPProjectOptions.getResolvedVariablePath((IPath)path);
                res = null;
                isMissing = root.findMember(resolvedPath) == null && !resolvedPath.toFile().exists();
                break;
            }
            case 1: 
            case 6: {
                res = root.findMember(path);
                if (res != null) break;
                if (!ArchieveFileFilter.isZipPath(path) && root.getWorkspace().validatePath(path.toString(), 2).isOK() && root.getProject(path.segment(0)).exists()) {
                    res = root.getFolder(path);
                }
                isMissing = !path.toFile().exists();
                break;
            }
            case 3: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res != null) break;
                if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                    res = root.getFolder(path);
                }
                isMissing = true;
                break;
            }
            case 2: {
                res = root.findMember(path);
                isMissing = res == null;
            }
        }
        IPListElement elem = new IPListElement(parent, project, curr.getEntryKind(), curr.getContentKind(), path, res);
        elem.setExported(curr.isExported());
        if (project != null && project.exists()) {
            elem.setIsMissing(isMissing);
        }
        return elem;
    }

    public static StringBuffer appendEncodePath(IPath path, StringBuffer buf) {
        if (path != null) {
            String str = path.toString();
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedString(String str, StringBuffer buf) {
        if (str != null) {
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedFilter(IPath[] filters, StringBuffer buf) {
        if (filters != null) {
            buf.append('[').append(filters.length).append(']');
            int i = 0;
            while (i < filters.length) {
                IPListElement.appendEncodePath(filters[i], buf).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public StringBuffer appendEncodedSettings(StringBuffer buf) {
        buf.append(this.fEntryKind).append(';');
        buf.append(this.fContentKind).append(';');
        IPListElement.appendEncodePath(this.fPath, buf).append(';');
        buf.append((Object)this.fIsExported).append(';');
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof IPListElementAttribute) {
                IPListElementAttribute elem = (IPListElementAttribute)curr;
                if (elem.isBuiltIn()) {
                    elem.getKey();
                } else {
                    IPListElement.appendEncodedString((String)elem.getValue(), buf);
                }
            }
            ++i;
        }
        return buf;
    }
}

