/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathEntry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.IIncludePathContainerPage;
import org.eclipse.php.internal.ui.preferences.includepath.IIncludePathContainerPageExtension;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathPropertyPage;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class IncludePathContainerDefaultPage
extends WizardPage
implements IIncludePathContainerPage,
IIncludePathContainerPageExtension {
    private StringDialogField fEntryField;
    private ArrayList fUsedPaths;

    public IncludePathContainerDefaultPage() {
        super("IncludePathContainerDefaultPage");
        this.setTitle(PHPUIMessages.getString("IncludePathContainerDefaultPage_title"));
        this.setDescription(PHPUIMessages.getString("IncludePathContainerDefaultPage_description"));
        this.setImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fUsedPaths = new ArrayList();
        this.fEntryField = new StringDialogField();
        this.fEntryField.setLabelText(PHPUIMessages.getString("IncludePathContainerDefaultPage_path_label"));
        this.fEntryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                IncludePathContainerDefaultPage.this.validatePath();
            }
        });
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo status = new StatusInfo();
        String str = this.fEntryField.getText();
        if (str.length() == 0) {
            status.setError(PHPUIMessages.getString("IncludePathContainerDefaultPage_path_error_enterpath"));
        } else if (!Path.ROOT.isValidPath(str)) {
            status.setError(PHPUIMessages.getString("IncludePathContainerDefaultPage_path_error_invalidpath"));
        } else {
            Path path = new Path(str);
            if (path.segmentCount() == 0) {
                status.setError(PHPUIMessages.getString("IncludePathContainerDefaultPage_path_error_needssegment"));
            } else if (this.fUsedPaths.contains(path)) {
                status.setError(PHPUIMessages.getString("IncludePathContainerDefaultPage_path_error_alreadyexists"));
            }
        }
        this.updateStatus((IStatus)status);
    }

    protected void updateStatus(IStatus status) {
        IncludePathPropertyPage.applyToStatusLine((DialogPage)this, status);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fEntryField.doFillIntoGrid(composite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fEntryField.getTextControl(null));
        this.fEntryField.setFocus();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.php.help.include_paths");
    }

    public boolean finish() {
        return true;
    }

    public IIncludePathEntry getSelection() {
        return IncludePathEntry.newContainerEntry((IPath)new Path(this.fEntryField.getText()), null, (boolean)true);
    }

    public void initialize(IProject project, IIncludePathEntry[] currentEntries) {
        int i = 0;
        while (i < currentEntries.length) {
            IIncludePathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    public void setSelection(IIncludePathEntry containerEntry) {
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
            this.fEntryField.setText(containerEntry.getPath().toString());
        } else {
            this.fEntryField.setText("");
        }
    }
}

