/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElement;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NewContainerDialog
extends StatusDialog {
    private StringDialogField fContainerDialogField;
    private StatusInfo fContainerFieldStatus;
    private IFolder fFolder;
    private IPath[] fExistingFolders;
    private IProject fCurrProject;

    public NewContainerDialog(Shell parent, String title, IProject project, IPath[] existingFolders, IPListElement entryToEdit) {
        super(parent);
        this.setTitle(title);
        this.fContainerFieldStatus = new StatusInfo();
        SourceContainerAdapter adapter = new SourceContainerAdapter();
        this.fContainerDialogField = new StringDialogField();
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fFolder = null;
        this.fExistingFolders = existingFolders;
        this.fCurrProject = project;
        if (entryToEdit == null) {
            this.fContainerDialogField.setText("");
        } else {
            this.fContainerDialogField.setText(entryToEdit.getPath().removeFirstSegments(1).toString());
        }
    }

    public void setMessage(String message) {
        this.fContainerDialogField.setLabelText(message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int widthHint = this.convertWidthInCharsToPixels(80);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        inner.setLayout((Layout)layout);
        this.fContainerDialogField.doFillIntoGrid(inner, 2);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getLabelControl(null), widthHint);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), widthHint);
        LayoutUtil.setHorizontalGrabbing((Control)this.fContainerDialogField.getTextControl(null));
        this.fContainerDialogField.postSetFocusOnDialogField(parent.getDisplay());
        NewContainerDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.updateStatus((IStatus)this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fFolder = null;
        String pathStr = this.fContainerDialogField.getText();
        if (pathStr.length() == 0) {
            this.fContainerFieldStatus.setError(PHPUIMessages.getString("NewContainerDialog_error_enterpath"));
            return;
        }
        IPath path = this.fCurrProject.getFullPath().append(pathStr);
        IWorkspace workspace = this.fCurrProject.getWorkspace();
        IStatus pathValidation = workspace.validatePath(path.toString(), 2);
        if (!pathValidation.isOK()) {
            this.fContainerFieldStatus.setError(MessageFormat.format(PHPUIMessages.getString("NewContainerDialog_error_invalidpath"), pathValidation.getMessage()));
            return;
        }
        IFolder folder = this.fCurrProject.getFolder(pathStr);
        if (this.isFolderExisting(folder)) {
            this.fContainerFieldStatus.setError(PHPUIMessages.getString("NewContainerDialog_error_pathexists"));
            return;
        }
        this.fContainerFieldStatus.setOK();
        this.fFolder = folder;
    }

    private boolean isFolderExisting(IFolder folder) {
        int i = 0;
        while (i < this.fExistingFolders.length) {
            if (folder.getFullPath().equals((Object)this.fExistingFolders[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IFolder getFolder() {
        return this.fFolder;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    private class SourceContainerAdapter
    implements IDialogFieldListener {
        private SourceContainerAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewContainerDialog.this.doStatusLineUpdate();
        }
    }
}

