/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElement;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElementLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.ZipFileSelectionDialog;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.php.internal.ui.wizards.fields.SelectionButtonDialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewVariableEntryDialog
extends StatusDialog {
    private final int IDX_EXTEND = 0;
    private ListDialogField fVariablesList;
    private boolean fCanExtend;
    private boolean fIsValidSelection;
    private IPath[] fResultPaths;
    private SelectionButtonDialogField fConfigButton;

    public NewVariableEntryDialog(Shell parent) {
        super(parent);
        this.setTitle(PHPUIMessages.getString("NewVariableEntryDialog_title"));
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.updateStatus((IStatus)new StatusInfo(4, ""));
        String[] buttonLabels = new String[]{PHPUIMessages.getString("NewVariableEntryDialog_vars_extend")};
        VariablesAdapter adapter = new VariablesAdapter();
        IPVariableElementLabelProvider labelProvider = new IPVariableElementLabelProvider(false);
        this.fVariablesList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
        this.fVariablesList.setDialogFieldListener(adapter);
        this.fVariablesList.setLabelText(PHPUIMessages.getString("NewVariableEntryDialog_vars_label"));
        this.fVariablesList.enableButton(0, false);
        this.fVariablesList.setViewerSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IPVariableElement && e2 instanceof IPVariableElement) {
                    return ((IPVariableElement)e1).getName().compareTo(((IPVariableElement)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fConfigButton = new SelectionButtonDialogField(8);
        this.fConfigButton.setLabelText(PHPUIMessages.getString("NewVariableEntryDialog_configbutton_label"));
        this.fConfigButton.setDialogFieldListener(adapter);
        this.initializeElements();
        this.fCanExtend = false;
        this.fIsValidSelection = false;
        this.fResultPaths = null;
    }

    private void initializeElements() {
        String[] entries = PHPProjectOptions.getIncludePathVariableNames();
        ArrayList<IPVariableElement> elements = new ArrayList<IPVariableElement>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String name = entries[i];
            IPath entryPath = PHPProjectOptions.getIncludePathVariable((String)name);
            if (entryPath != null) {
                elements.add(new IPVariableElement(name, entryPath, IncludePathVariableManager.instance().isReserved(name)));
            }
            ++i;
        }
        this.fVariablesList.setElements(elements);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.php.help.adding_elements_to_a_project_s_include_path");
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        this.fVariablesList.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fVariablesList.getLabelControl(null), 2);
        GridData listData = (GridData)this.fVariablesList.getListControl(null).getLayoutData();
        listData.grabExcessHorizontalSpace = true;
        listData.heightHint = this.convertHeightInCharsToPixels(10);
        Composite lowerComposite = new Composite(composite, 0);
        lowerComposite.setLayoutData((Object)new GridData(256));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        lowerComposite.setLayout((Layout)layout);
        this.fConfigButton.doFillIntoGrid(lowerComposite, 1);
        NewVariableEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public IPath[] getResult() {
        return this.fResultPaths;
    }

    private void doDoubleClick() {
        if (this.fIsValidSelection) {
            this.okPressed();
        } else if (this.fCanExtend) {
            this.extendButtonPressed();
        }
    }

    private void doSelectionChanged() {
        boolean isValidSelection = true;
        boolean canExtend = false;
        StatusInfo status = new StatusInfo();
        List selected = this.fVariablesList.getSelectedElements();
        int nSelected = selected.size();
        if (nSelected > 0) {
            this.fResultPaths = new Path[nSelected];
            int i = 0;
            while (i < nSelected) {
                IPVariableElement curr = (IPVariableElement)selected.get(i);
                this.fResultPaths[i] = new Path(curr.getName());
                if (!curr.getPath().toFile().exists()) {
                    status.setError(PHPUIMessages.getString("NewVariableEntryDialog_variable_non_existent_location"));
                    isValidSelection = false;
                } else if (!curr.getPath().toFile().isFile()) {
                    status.setInfo(PHPUIMessages.getString("NewVariableEntryDialog_info_isfolder"));
                    canExtend = true;
                }
                ++i;
            }
        } else {
            isValidSelection = false;
            status.setInfo(PHPUIMessages.getString("NewVariableEntryDialog_info_noselection"));
        }
        if (isValidSelection && nSelected > 1) {
            String str = MessageFormat.format(PHPUIMessages.getString("NewVariableEntryDialog_info_selected"), String.valueOf(nSelected));
            status.setInfo(str);
        }
        this.fCanExtend = nSelected == 1 && canExtend;
        this.fVariablesList.enableButton(0, this.fCanExtend);
        this.updateStatus((IStatus)status);
        this.fIsValidSelection = isValidSelection;
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(isValidSelection);
        }
    }

    private IPath[] chooseExtensions(IPVariableElement elem) {
        File file = elem.getPath().toFile();
        ZipFileSelectionDialog dialog = new ZipFileSelectionDialog(this.getShell(), true, true);
        dialog.setTitle(PHPUIMessages.getString("NewVariableEntryDialog_ExtensionDialog_title"));
        dialog.setMessage(MessageFormat.format(PHPUIMessages.getString("NewVariableEntryDialog_ExtensionDialog_description"), elem.getName()));
        dialog.setInput(file);
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            IPath[] paths = new IPath[selected.length];
            int i = 0;
            while (i < selected.length) {
                IPath filePath = Path.fromOSString((String)((File)selected[i]).getPath());
                Path resPath = new Path(elem.getName());
                int k = elem.getPath().segmentCount();
                while (k < filePath.segmentCount()) {
                    resPath = resPath.append(filePath.segment(k));
                    ++k;
                }
                paths[i] = resPath;
                ++i;
            }
            return paths;
        }
        return null;
    }

    protected final void extendButtonPressed() {
        IPath[] extendedPaths;
        List selected = this.fVariablesList.getSelectedElements();
        if (selected.size() == 1 && (extendedPaths = this.chooseExtensions((IPVariableElement)selected.get(0))) != null) {
            this.fResultPaths = extendedPaths;
            super.buttonPressed(0);
        }
    }

    protected final void configButtonPressed() {
        String id = "org.eclipse.php.ui.preferences.IncludePathVariables";
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, null).open();
        this.initializeElements();
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    NewVariableEntryDialog.this.extendButtonPressed();
                }
            }
        }

        public void selectionChanged(ListDialogField field) {
            NewVariableEntryDialog.this.doSelectionChanged();
        }

        public void doubleClicked(ListDialogField field) {
            NewVariableEntryDialog.this.doDoubleClick();
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == NewVariableEntryDialog.this.fConfigButton) {
                NewVariableEntryDialog.this.configButtonPressed();
            }
        }
    }
}

