/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectOutline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.StandardPHPElementContentProvider;
import org.eclipse.php.internal.ui.SuperClassTreeContentProvider;
import org.eclipse.php.internal.ui.explorer.PHPTreeViewer;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlinePart;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.widgets.Control;

public class ProjectOutlineContentProvider
extends StandardPHPElementContentProvider
implements ModelListener,
IWorkspaceModelListener {
    public static final int INCLUDES = 1;
    public static final int CONSTANTS = 2;
    public static final int CLASSES = 3;
    public static final int FUNCTIONS = 4;
    private final ProjectOutlinePart fPart;
    private IProject fStoredProject;
    private PHPTreeViewer fViewer;
    private OutlineNode[] groupNodes;
    private OutlineNode[] nodes;
    private Timer timer;
    private ITreeContentProvider superClassContentProvider = new SuperClassTreeContentProvider(this);

    public ProjectOutlineContentProvider(ProjectOutlinePart part, boolean provideMembers) {
        this.fPart = part;
        this.fViewer = part.getViewer();
    }

    public static int getNodeType(Object outlineNode) {
        if (outlineNode instanceof OutlineNode) {
            return ((OutlineNode)outlineNode).getType();
        }
        return -1;
    }

    public void dispose() {
        PHPWorkspaceModelManager.getInstance().removeWorkspaceModelListener((IWorkspaceModelListener)this);
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.dispose();
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData fileData) {
        this.postAdd(fileData);
    }

    public void fileDataChanged(PHPFileData fileData) {
        this.postRefresh(fileData, true);
    }

    public void fileDataRemoved(PHPFileData fileData) {
        this.postRemove(fileData);
    }

    public Object[] getChildrenInternal(Object parentElement) {
        if (parentElement instanceof IProject) {
            IProject project = (IProject)parentElement;
            if (this.groupNodes == null || project != this.fStoredProject) {
                this.groupNodes = this.getOutlineChildren(project);
                this.fStoredProject = project;
            }
            return this.groupNodes;
        }
        if (parentElement instanceof OutlineNode) {
            OutlineNode outlineNode = (OutlineNode)parentElement;
            return outlineNode.getChildren();
        }
        if (parentElement instanceof PHPCodeData) {
            ArrayList children = new ArrayList(Arrays.asList(super.getChildrenInternal(parentElement)));
            children.addAll(Arrays.asList(this.superClassContentProvider.getChildren(parentElement)));
            return children.toArray();
        }
        return super.getChildrenInternal(parentElement);
    }

    private OutlineNode[] getOutlineChildren(IProject project) {
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        if (this.nodes == null) {
            this.nodes = new OutlineNode[]{new OutlineNode(2, "Constants", projectModel, this.fPart), new OutlineNode(3, "Classes", projectModel, this.fPart), new OutlineNode(4, "Functions", projectModel, this.fPart)};
        } else {
            int i = 0;
            while (i < this.nodes.length) {
                this.nodes[i].setModel(projectModel);
                ++i;
            }
        }
        return this.nodes;
    }

    public boolean hasChildrenInternal(Object element) {
        if (element instanceof IProject) {
            return true;
        }
        if (element instanceof OutlineNode) {
            OutlineNode outlineNode = (OutlineNode)element;
            return outlineNode.hasChildren();
        }
        if (element instanceof PHPCodeData && this.superClassContentProvider.hasChildren(element)) {
            return true;
        }
        return super.hasChildrenInternal(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (PHPTreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            PHPWorkspaceModelManager.getInstance().addWorkspaceModelListener((IWorkspaceModelListener)this);
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
        } else if (oldInput != null && newInput == null) {
            PHPWorkspaceModelManager.getInstance().removeWorkspaceModelListener((IWorkspaceModelListener)this);
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        }
        this.postRefresh(newInput, true);
    }

    protected Object internalGetParent(Object element) {
        Object parent;
        if (element instanceof PHPCodeData && (parent = this.superClassContentProvider.getParent(element)) != null) {
            return parent;
        }
        parent = super.internalGetParent(element);
        if (parent == this.fViewer.getInput() || parent instanceof PHPFileData) {
            if (this.groupNodes == null) {
                this.groupNodes = this.getOutlineChildren(this.fStoredProject);
            }
            int i = 0;
            while (i < this.groupNodes.length) {
                if (this.groupNodes[i].getType() == 3 && element instanceof PHPClassData) {
                    return this.groupNodes[i];
                }
                if (this.groupNodes[i].getType() == 4 && element instanceof PHPFunctionData) {
                    return this.groupNodes[i];
                }
                if (this.groupNodes[i].getType() == 2 && element instanceof PHPConstantData) {
                    return this.groupNodes[i];
                }
                ++i;
            }
        }
        return parent;
    }

    private void postAdd(final PHPFileData fileData) {
        if (this.fViewer == null || this.fViewer.getControl() == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (ProjectOutlineContentProvider.this.fViewer == null) {
                    return;
                }
                Control control = ProjectOutlineContentProvider.this.fViewer.getControl();
                if (control == null || control.isDisposed() || !control.isVisible()) {
                    return;
                }
                IResource res = PHPModelUtil.getResource((Object)fileData);
                if (res == null) {
                    return;
                }
                if (res.getProject() != ProjectOutlineContentProvider.this.fStoredProject) {
                    return;
                }
                PHPProjectModel model = PHPWorkspaceModelManager.getInstance().getModelForProject(res.getProject());
                int i = 0;
                while (i < ProjectOutlineContentProvider.this.groupNodes.length) {
                    OutlineNode outlineNode = ProjectOutlineContentProvider.this.groupNodes[i];
                    if (model != outlineNode.getModel()) {
                        outlineNode.setModel(model);
                    }
                    Object[] toUpdate = outlineNode.addChildren(fileData);
                    ProjectOutlineContentProvider.this.fViewer.add(outlineNode, toUpdate);
                    ++i;
                }
                i = 0;
                while (i < ProjectOutlineContentProvider.this.treeProviders.length) {
                    IPHPTreeContentProvider provider = ProjectOutlineContentProvider.this.treeProviders[i];
                    Object[] children = provider.getChildren(ProjectOutlineContentProvider.this.fStoredProject);
                    int j = 0;
                    while (j < children.length) {
                        ProjectOutlineContentProvider.this.fViewer.refresh(children[j], true);
                        ++j;
                    }
                    ++i;
                }
            }
        };
        this.fViewer.getControl().getDisplay().asyncExec(runnable);
    }

    private void postRemove(final PHPFileData fileData) {
        if (this.fViewer == null || this.fViewer.getControl() == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                if (ProjectOutlineContentProvider.this.fViewer == null) {
                    return;
                }
                Control control = ProjectOutlineContentProvider.this.fViewer.getControl();
                if (control == null || control.isDisposed() || !control.isVisible()) {
                    return;
                }
                IResource res = PHPModelUtil.getResource((Object)fileData);
                if (res == null) {
                    return;
                }
                if (res.getProject() != ProjectOutlineContentProvider.this.fStoredProject) {
                    return;
                }
                PHPProjectModel model = PHPWorkspaceModelManager.getInstance().getModelForProject(res.getProject());
                int i = 0;
                while (i < ProjectOutlineContentProvider.this.groupNodes.length) {
                    OutlineNode outlineNode = ProjectOutlineContentProvider.this.groupNodes[i];
                    if (model != outlineNode.getModel()) {
                        outlineNode.setModel(model);
                    }
                    Object[] toUpdate = outlineNode.removeChildren(fileData);
                    ProjectOutlineContentProvider.this.fViewer.remove(outlineNode, toUpdate);
                    ++i;
                }
                i = 0;
                while (i < ProjectOutlineContentProvider.this.treeProviders.length) {
                    IPHPTreeContentProvider provider = ProjectOutlineContentProvider.this.treeProviders[i];
                    Object[] children = provider.getChildren(ProjectOutlineContentProvider.this.fStoredProject);
                    int j = 0;
                    while (j < children.length) {
                        ProjectOutlineContentProvider.this.fViewer.refresh(children[j], true);
                        ++j;
                    }
                    ++i;
                }
            }
        };
        this.fViewer.getControl().getDisplay().asyncExec(runnable);
    }

    public void postRefresh(final Object root, boolean updateLabels) {
        if (this.fViewer == null || this.fViewer.getControl() == null) {
            return;
        }
        final Runnable runnable = new Runnable(){

            public void run() {
                if (ProjectOutlineContentProvider.this.fViewer == null) {
                    return;
                }
                Control control = ProjectOutlineContentProvider.this.fViewer.getControl();
                if (control == null || control.isDisposed() || !control.isVisible()) {
                    return;
                }
                IResource res = PHPModelUtil.getResource((Object)root);
                if (res == null) {
                    return;
                }
                if (res.getProject() != ProjectOutlineContentProvider.this.fStoredProject) {
                    return;
                }
                PHPProjectModel model = null;
                model = PHPWorkspaceModelManager.getInstance().getModelForProject(res.getProject());
                int i = 0;
                while (i < ProjectOutlineContentProvider.this.groupNodes.length) {
                    OutlineNode outlineNode = ProjectOutlineContentProvider.this.groupNodes[i];
                    if (model != outlineNode.getModel()) {
                        outlineNode.setModel(model);
                    }
                    outlineNode.loadChildren();
                    ProjectOutlineContentProvider.this.fViewer.refresh(outlineNode, true);
                    ++i;
                }
                i = 0;
                while (i < ProjectOutlineContentProvider.this.treeProviders.length) {
                    IPHPTreeContentProvider provider = ProjectOutlineContentProvider.this.treeProviders[i];
                    Object[] children = provider.getChildren(ProjectOutlineContentProvider.this.fStoredProject);
                    if (children != null) {
                        int j = 0;
                        while (j < children.length) {
                            ProjectOutlineContentProvider.this.fViewer.refresh(children[j], true);
                            ++j;
                        }
                    }
                    ++i;
                }
                ISelection currentSelection = ProjectOutlineContentProvider.this.fViewer.getSelection();
                if (currentSelection.isEmpty()) {
                    ProjectOutlineContentProvider.this.fViewer.setSelection(ProjectOutlineContentProvider.this.fViewer.getStoredSelection(), false);
                }
            }
        };
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.schedule(new TimerTask(){

            public void run() {
                ProjectOutlineContentProvider.this.fViewer.getControl().getDisplay().asyncExec(runnable);
            }
        }, 1000L);
    }

    public void projectModelAdded(IProject project) {
        if (this.fPart.isInCurrentProject(project)) {
            this.postRefresh(project, true);
        }
    }

    public void projectModelChanged(IProject project) {
    }

    public void projectModelRemoved(IProject project) {
        if (this.fPart.isInCurrentProject(project)) {
            this.postRefresh(project, true);
        }
    }

    static /* synthetic */ Object[] access$0() {
        return StandardPHPElementContentProvider.NO_CHILDREN;
    }

    public static class OutlineNode
    implements Comparable {
        private final Set children = new TreeSet();
        private final ProjectOutlinePart part;
        private final String text;
        private final int type;
        private PHPProjectModel model;

        public OutlineNode(int type, String text, PHPProjectModel model, ProjectOutlinePart part) {
            this.type = type;
            this.text = text;
            this.model = model;
            this.part = part;
        }

        public int compareTo(Object other) {
            if (this == other) {
                return 0;
            }
            if (other instanceof OutlineNode) {
                OutlineNode otherNode = (OutlineNode)other;
                return this.type - otherNode.type;
            }
            return 0;
        }

        public Object[] getChildren() {
            if (this.model == null) {
                return ProjectOutlineContentProvider.access$0();
            }
            return this.children.toArray();
        }

        public PHPProjectModel getModel() {
            return this.model;
        }

        public String getText() {
            return this.text;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasChildren() {
            if (this.model == null) {
                return false;
            }
            return this.children.size() > 0;
        }

        PHPCodeData[] addChildren(PHPFileData newData) {
            PHPCodeData[] newChildren = new PHPCodeData[]{};
            if (newData != null) {
                switch (this.type) {
                    case 3: {
                        newChildren = newData.getClasses();
                        break;
                    }
                    case 4: {
                        newChildren = newData.getFunctions();
                        break;
                    }
                    case 2: {
                        newChildren = newData.getConstants();
                    }
                }
            }
            int i = 0;
            while (i < newChildren.length) {
                this.children.add(newChildren[i]);
                ++i;
            }
            return newChildren;
        }

        PHPCodeData[] removeChildren(PHPFileData oldData) {
            PHPCodeData[] oldChildren = new PHPCodeData[]{};
            if (oldData != null) {
                switch (this.type) {
                    case 3: {
                        oldChildren = oldData.getClasses();
                        break;
                    }
                    case 4: {
                        oldChildren = oldData.getFunctions();
                        break;
                    }
                    case 2: {
                        oldChildren = oldData.getConstants();
                    }
                }
            }
            int i = 0;
            while (i < oldChildren.length) {
                this.children.remove(oldChildren[i]);
                ++i;
            }
            return oldChildren;
        }

        void loadChildren() {
            if (this.model == null) {
                return;
            }
            this.children.clear();
            Object[] aChildren = ProjectOutlineContentProvider.access$0();
            switch (this.type) {
                case 3: {
                    if (this.part.isShowAll()) {
                        aChildren = this.model.getClasses();
                        break;
                    }
                    aChildren = this.model.getPHPUserModel().getClasses();
                    break;
                }
                case 4: {
                    if (this.part.isShowAll()) {
                        aChildren = this.model.getFunctions();
                        break;
                    }
                    aChildren = this.model.getPHPUserModel().getFunctions();
                    break;
                }
                case 2: {
                    aChildren = this.part.isShowAll() ? this.model.getConstants() : this.model.getPHPUserModel().getConstants();
                }
            }
            int i = 0;
            while (i < aChildren.length) {
                this.children.add(aChildren[i]);
                ++i;
            }
        }

        public void resetChildren() {
            this.children.clear();
        }

        public void setModel(PHPProjectModel model) {
            this.model = model;
        }
    }
}

