/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectOutline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.SuperClassLabelProvider;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.util.AppearanceAwareLabelProvider;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.swt.graphics.Image;

public class ProjectOutlineLabelProvider
extends AppearanceAwareLabelProvider {
    protected ILabelProvider superClassLabelProviderFragment = new SuperClassLabelProvider((ILabelProvider)this);

    public ProjectOutlineLabelProvider(int textFlags, int imageFlags, ITreeContentProvider cp) {
        super(textFlags, imageFlags);
    }

    public String getText(Object element) {
        if (element instanceof PHPCodeData) {
            String text = this.superClassLabelProviderFragment.getText(element);
            if (text != null) {
                return text;
            }
            return super.getText(element);
        }
        if (element instanceof ProjectOutlineContentProvider.OutlineNode) {
            ProjectOutlineContentProvider.OutlineNode outlineNode = (ProjectOutlineContentProvider.OutlineNode)element;
            return outlineNode.getText();
        }
        return super.getText(element);
    }

    public String getTooltipText(Object element) {
        PHPCodeData codeData;
        UserData userData;
        String postfix = "";
        if (element instanceof PHPCodeData && (userData = (codeData = (PHPCodeData)element).getUserData()) != null) {
            postfix = " (" + userData.getFileName() + ")";
        }
        String text = PHPElementLabels.getTooltipTextLabel(element);
        return String.valueOf(text) + postfix;
    }

    public Image getImage(Object element) {
        Image image;
        if (element instanceof PHPCodeData && (image = this.superClassLabelProviderFragment.getImage(element)) != null) {
            return image;
        }
        return super.getImage(element);
    }
}

