/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.search.IPHPSearchConstants;
import org.eclipse.php.internal.ui.search.IPHPSearchScope;
import org.eclipse.php.internal.ui.search.Messages;
import org.eclipse.php.internal.ui.search.PHPSearchQuery;
import org.eclipse.php.internal.ui.search.PHPSearchScopeFactory;
import org.eclipse.php.internal.ui.search.PatternQuerySpecification;
import org.eclipse.php.internal.ui.search.SearchUtil;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class PHPSearchPage
extends DialogPage
implements ISearchPage,
IPHPSearchConstants {
    public static String EXTENSION_POINT_ID = "org.eclipse.php.ui.PHPSearchPage";
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "PHPSearchPage";
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private final List fPreviousSearchPatterns;
    private SearchPatternData fInitialData;
    private PHPCodeData fPhpElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private Button[] fSearchFor;
    private String[] fSearchForText = new String[]{PHPUIMessages.getString("SearchPage_searchFor_class"), PHPUIMessages.getString("SearchPage_searchFor_function"), PHPUIMessages.getString("SearchPage_searchFor_constant")};

    public PHPSearchPage() {
        this.fPreviousSearchPatterns = new ArrayList();
    }

    public PHPSearchPage(String title) {
        super(title);
        this.fPreviousSearchPatterns = new ArrayList();
    }

    public PHPSearchPage(String title, ImageDescriptor image) {
        super(title, image);
        this.fPreviousSearchPatterns = new ArrayList();
    }

    public boolean performAction() {
        return this.performNewSearch();
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Control expressionComposite = this.createExpression(result);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        Control searchFor = this.createSearchFor(result);
        searchFor.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        SelectionAdapter phpElementInitializer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (PHPSearchPage.this.getSearchFor() == PHPSearchPage.this.fInitialData.getSearchFor()) {
                    PHPSearchPage.this.fPhpElement = PHPSearchPage.this.fInitialData.getPHPElement();
                } else {
                    PHPSearchPage.this.fPhpElement = null;
                }
                PHPSearchPage.this.doPatternModified();
            }
        };
        this.fSearchFor[0].addSelectionListener((SelectionListener)phpElementInitializer);
        this.fSearchFor[1].addSelectionListener((SelectionListener)phpElementInitializer);
        this.fSearchFor[2].addSelectionListener((SelectionListener)phpElementInitializer);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.php.help.searching_for_php_elements");
    }

    private boolean performNewSearch() {
        SearchPatternData data = this.getPatternData();
        IPHPSearchScope scope = null;
        String scopeDescription = "";
        PHPSearchScopeFactory factory = PHPSearchScopeFactory.getInstance();
        int searchScope = this.getContainer().getSelectedScope();
        switch (searchScope) {
            case 0: {
                scopeDescription = PHPUIMessages.getString("WorkspaceScope");
                scope = factory.createWorkspaceSearchScope(this.getSearchFor());
                break;
            }
            case 1: {
                scopeDescription = PHPUIMessages.getString("SelectionScope");
                scope = factory.createSelectedPHPSearchScope(this.getSearchFor(), this.getContainer().getSelection());
                break;
            }
            case 3: {
                scope = factory.createSelectedPHPProjectSearchScope(this.getSearchFor(), this.getContainer().getSelection());
                IProject[] projects = PHPSearchScopeFactory.getInstance().getProjects(scope);
                if (projects.length >= 1) {
                    if (projects.length == 1) {
                        scopeDescription = Messages.format(PHPUIMessages.getString("EnclosingProjectScope"), projects[0].getName());
                        break;
                    }
                    scopeDescription = Messages.format(PHPUIMessages.getString("EnclosingProjectsScope"), projects[0].getName());
                    break;
                }
                scopeDescription = Messages.format(PHPUIMessages.getString("EnclosingProjectScope"), "");
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = Messages.format(PHPUIMessages.getString("WorkingSetScope"), SearchUtil.toString(workingSets));
                scope = factory.createWorkingSetSearchScope(this.getSearchFor(), this.getContainer().getSelectedWorkingSets());
            }
        }
        PatternQuerySpecification querySpec = null;
        querySpec = new PatternQuerySpecification(data.getPattern(), data.getSearchFor(), data.isCaseSensitive(), scope, scopeDescription);
        data.setPHPElement(null);
        PHPSearchQuery textSearchJob = new PHPSearchQuery(querySpec);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)textSearchJob);
        return true;
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = ((SearchPatternData)this.fPreviousSearchPatterns.get(i)).getPattern();
            ++i;
        }
        return patterns;
    }

    private int getSearchFor() {
        int i = 0;
        while (i < this.fSearchFor.length) {
            if (this.fSearchFor[i].getSelection()) {
                return i;
            }
            ++i;
        }
        Assert.isTrue((boolean)false, (String)"shouldNeverHappen");
        return -1;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData findInPrevious(String pattern) {
        for (SearchPatternData element : this.fPreviousSearchPatterns) {
            if (!pattern.equals(element.getPattern())) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getPattern();
        SearchPatternData match = this.findInPrevious(pattern);
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getSearchFor(), 3, pattern, this.fCaseSensitive.getSelection(), this.fPhpElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    public boolean isValid() {
        return true;
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 16384);
        label.setText(PHPUIMessages.getString("SearchPage_expression_label"));
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.fPattern = new Combo(result, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPSearchPage.this.handlePatternSelected();
                PHPSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PHPSearchPage.this.doPatternModified();
                PHPSearchPage.this.updateOKStatus();
            }
        });
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        this.fCaseSensitive = new Button(result, 32);
        this.fCaseSensitive.setText(PHPUIMessages.getString("SearchPage_expression_caseSensitive"));
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPSearchPage.this.fIsCaseSensitive = PHPSearchPage.this.fCaseSensitive.getSelection();
            }
        });
        this.fCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    final void updateOKStatus() {
        boolean isValid = this.isValidSearchPattern();
        this.getContainer().setPerformActionEnabled(isValid);
    }

    private boolean isValidSearchPattern() {
        return this.getPattern().length() != 0;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private void doPatternModified() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.getPattern()) && this.fInitialData.getPHPElement() != null && this.fInitialData.getSearchFor() == this.getSearchFor()) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
            this.fPhpElement = this.fInitialData.getPHPElement();
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
            this.fPhpElement = null;
        }
    }

    private void handlePatternSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData initialData = (SearchPatternData)this.fPreviousSearchPatterns.get(selectionIndex);
        this.setSearchFor(initialData.getSearchFor());
        this.fPattern.setText(initialData.getPattern());
        this.fIsCaseSensitive = initialData.isCaseSensitive();
        this.fPhpElement = initialData.getPHPElement();
        this.fCaseSensitive.setEnabled(this.fPhpElement == null);
        this.fCaseSensitive.setSelection(initialData.isCaseSensitive());
        if (initialData.getWorkingSets() != null) {
            this.getContainer().setSelectedWorkingSets(initialData.getWorkingSets());
        } else {
            this.getContainer().setSelectedScope(initialData.getScope());
        }
        this.fInitialData = initialData;
    }

    private void setSearchFor(int searchFor) {
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].setSelection(searchFor == i);
            ++i;
        }
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(PHPUIMessages.getString("SearchPage_searchFor_label"));
        result.setLayout((Layout)new GridLayout(3, true));
        this.fSearchFor = new Button[this.fSearchForText.length];
        int i = 0;
        while (i < this.fSearchForText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fSearchForText[i]);
            button.setSelection(i == 1);
            button.setLayoutData((Object)new GridData());
            this.fSearchFor[i] = button;
            ++i;
        }
        Label filler = new Label((Composite)result, 0);
        filler.setVisible(false);
        filler.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return result;
    }

    private void initSelections() {
        PHPCodeData[] elements;
        ISelection sel = this.getContainer().getSelection();
        SearchPatternData initData = null;
        if (sel instanceof ITextSelection) {
            IEditorPart activePart = this.getActiveEditor();
            PHPStructuredEditor structuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)activePart);
            if (structuredEditor != null) {
                try {
                    PHPCodeData[] elements2 = SelectionConverter.codeResolve(structuredEditor);
                    if (elements2 != null && elements2.length > 0) {
                        initData = this.determineInitValuesFrom(elements2[0]);
                    }
                }
                catch (Exception exception) {}
            }
            if (initData == null) {
                initData = this.trySimpleTextSelection((ITextSelection)sel);
            }
        } else if (sel instanceof IStructuredSelection && (elements = SelectionConverter.getElements((IStructuredSelection)sel)) != null && elements.length > 0) {
            initData = this.determineInitValuesFrom(elements[0]);
        }
        if (initData == null) {
            initData = this.getDefaultInitValues();
        }
        this.fInitialData = initData;
        this.fPhpElement = initData.getPHPElement();
        this.fCaseSensitive.setSelection(initData.isCaseSensitive());
        this.fCaseSensitive.setEnabled(this.fPhpElement == null);
        this.setSearchFor(initData.getSearchFor());
        this.fPattern.setText(initData.getPattern());
    }

    private SearchPatternData determineInitValuesFrom(PHPCodeData codeData) {
        if (codeData instanceof PHPClassData) {
            return new SearchPatternData(0, 3, false, codeData.getName(), codeData);
        }
        if (codeData instanceof PHPFunctionData) {
            return new SearchPatternData(1, 3, false, codeData.getName(), codeData);
        }
        if (codeData instanceof PHPConstantData) {
            return new SearchPatternData(2, 3, true, codeData.getName(), codeData);
        }
        return new SearchPatternData(0, 3, false, codeData.getName(), codeData);
    }

    private SearchPatternData trySimpleTextSelection(ITextSelection selection) {
        String selectedText = selection.getText();
        if (selectedText != null && selectedText.length() > 0) {
            int i = 0;
            while (i < selectedText.length() && !PHPSearchPage.isLineDelimiterChar(selectedText.charAt(i))) {
                ++i;
            }
            if (i > 0) {
                return new SearchPatternData(1, 3, this.fIsCaseSensitive, selectedText.substring(0, i), null);
            }
        }
        return null;
    }

    private static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    private SearchPatternData getDefaultInitValues() {
        if (!this.fPreviousSearchPatterns.isEmpty()) {
            return (SearchPatternData)this.fPreviousSearchPatterns.get(0);
        }
        return new SearchPatternData(1, 3, this.fIsCaseSensitive, "", null);
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = PHPUiPlugin.getActivePage();
        if (activePage != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = PHPUiPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = (SearchPatternData)this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private static class SearchPatternData {
        private int searchFor;
        private int limitTo;
        private String pattern;
        private boolean isCaseSensitive;
        private PHPCodeData phpElement;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchPatternData(int searchFor, int limitTo, boolean isCaseSensitive, String pattern, PHPCodeData phpElement) {
            this(searchFor, limitTo, pattern, isCaseSensitive, phpElement, 0, null);
        }

        public SearchPatternData(int searchFor, int limitTo, String pattern, boolean isCaseSensitive, PHPCodeData phpElement, int scope, IWorkingSet[] workingSets) {
            this.searchFor = searchFor;
            this.limitTo = limitTo;
            this.pattern = pattern;
            this.isCaseSensitive = isCaseSensitive;
            this.phpElement = phpElement;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public void setPHPElement(PHPCodeData phpElement) {
            this.phpElement = phpElement;
        }

        public PHPCodeData getPHPElement() {
            return this.phpElement;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getScope() {
            return this.scope;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public void store(IDialogSettings settings) {
            settings.put("searchFor", this.searchFor);
            settings.put("scope", this.scope);
            settings.put("pattern", this.pattern);
            settings.put("limitTo", this.limitTo);
            settings.put("phpElement", this.phpElement != null ? this.phpElement.getName() : "");
            settings.put("isCaseSensitive", this.isCaseSensitive);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getId();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }

        public static SearchPatternData create(IDialogSettings settings) {
            String pattern = settings.get("pattern");
            if (pattern.length() == 0) {
                return null;
            }
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            try {
                int searchFor = settings.getInt("searchFor");
                int scope = settings.getInt("scope");
                int limitTo = settings.getInt("limitTo");
                boolean isCaseSensitive = settings.getBoolean("isCaseSensitive");
                return new SearchPatternData(searchFor, limitTo, pattern, isCaseSensitive, null, scope, workingSets);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

