/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.search.IPHPSearchScope;

public class PHPSearchScope
implements IPHPSearchScope {
    protected static final IPath[] EMPTY_PATHS = new IPath[0];
    protected HashSet fullProjects;
    protected HashSet partialProjects;
    protected HashMap paths;
    protected int searchFor;

    public PHPSearchScope(int searchFor) {
        this.searchFor = searchFor;
        this.fullProjects = new HashSet(5);
        this.partialProjects = new HashSet(5);
        this.paths = new HashMap();
    }

    public IProject[] getAllEnclosingProjects() {
        IProject[] allEnclosingProjects = new IProject[this.fullProjects.size()];
        IProject[] partialEnclosingProjects = new IProject[this.partialProjects.size()];
        this.fullProjects.toArray(allEnclosingProjects);
        this.partialProjects.toArray(partialEnclosingProjects);
        IProject[] projects = new IProject[allEnclosingProjects.length + partialEnclosingProjects.length];
        System.arraycopy(allEnclosingProjects, 0, projects, 0, allEnclosingProjects.length);
        System.arraycopy(partialEnclosingProjects, 0, projects, allEnclosingProjects.length, partialEnclosingProjects.length);
        return projects;
    }

    public IProject[] getFullScopeProjects() {
        IProject[] projects = new IProject[this.fullProjects.size()];
        this.fullProjects.toArray(projects);
        return projects;
    }

    public IProject[] getPartialScopeProjects() {
        IProject[] projects = new IProject[this.partialProjects.size()];
        this.partialProjects.toArray(projects);
        return projects;
    }

    public IPath[] getPartialResourcesPaths(IProject project) {
        List allPaths = (List)this.paths.get(project);
        if (allPaths == null) {
            return EMPTY_PATHS;
        }
        IPath[] allPathsArr = new IPath[allPaths.size()];
        allPaths.toArray(allPathsArr);
        return allPathsArr;
    }

    public boolean isInScope(CodeData codeData) {
        CodeData adaptable = codeData;
        IFile file = (IFile)adaptable.getAdapter(IResource.class);
        Iterator iterator = this.fullProjects.iterator();
        while (iterator.hasNext()) {
            if (!((IProject)iterator.next()).exists(file.getFullPath())) continue;
            return true;
        }
        for (Map.Entry entry : this.paths.entrySet()) {
            List values = (List)entry.getValue();
            if (!values.contains(file.getFullPath())) continue;
            return true;
        }
        return false;
    }

    public void add(IProject project) {
        if (project.isAccessible()) {
            this.fullProjects.add(project);
        }
        this.partialProjects.remove(project);
        this.paths.remove(project);
    }

    public void add(IResource resource) {
        ArrayList<IPath> list;
        IProject project = resource.getProject();
        if (!this.fullProjects.contains(project)) {
            this.partialProjects.add(project);
        }
        if ((list = (ArrayList<IPath>)this.paths.get(project)) == null) {
            list = new ArrayList<IPath>(5);
            this.paths.put(project, list);
        }
        list.add(resource.getFullPath());
    }

    public int getSearchFor() {
        return this.searchFor;
    }
}

