/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search.decorators;

import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.util.Visitor;
import org.eclipse.php.internal.ui.search.decorators.IPHPDataLeafMarker;
import org.eclipse.php.internal.ui.search.decorators.PHPClassDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPFileDataDecorator;

public abstract class PHPDataDecorator
implements IPHPDataLeafMarker {
    private PHPCodeData source;
    private IProject project;
    private boolean isLeaf;

    public PHPDataDecorator(PHPCodeData source, IProject project, boolean isLeaf) {
        this.source = source;
        this.project = project;
        this.isLeaf = isLeaf;
    }

    public PHPDataDecorator(PHPCodeData source, IProject project) {
        this(source, project, true);
    }

    public void setContainer(PHPCodeData container) {
        this.source.setContainer(container);
    }

    public PHPCodeData getContainer() {
        PHPCodeData sourceContainer = this.source.getContainer();
        if (sourceContainer instanceof PHPClassData) {
            return new PHPClassDataDecorator((PHPClassData)sourceContainer, this.project, false);
        }
        if (sourceContainer instanceof PHPFileData) {
            return new PHPFileDataDecorator((PHPFileData)sourceContainer, this.project, false);
        }
        return sourceContainer;
    }

    public PHPDocBlock getDocBlock() {
        return this.source.getDocBlock();
    }

    public String getName() {
        return this.source.getName();
    }

    public String getDescription() {
        return this.source.getDescription();
    }

    public boolean isUserCode() {
        return this.source.isUserCode();
    }

    public UserData getUserData() {
        return this.source.getUserData();
    }

    public void accept(Visitor v) {
        this.source.accept(v);
    }

    public int compareTo(CodeData arg0) {
        return this.source.compareTo((Object)arg0);
    }

    public Object getAdapter(Class adapter) {
        return this.source.getAdapter(adapter);
    }

    public PHPCodeData getSource() {
        return this.source;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean equals(Object other) {
        if (other instanceof PHPDataDecorator) {
            return this.hashCode() == ((PHPDataDecorator)other).hashCode();
        }
        return false;
    }

    public int hashCode() {
        UserData userData = this.getUserData();
        return (String.valueOf(userData.getStartPosition()) + userData.getFileName()).hashCode() + this.getClass().hashCode();
    }
}

