/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.hover;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;

public class PHPEditorTextHoverDescriptor {
    private static final String PHP_EDITOR_TEXT_HOVER_EXTENSION_POINT = "org.eclipse.php.ui.phpEditorTextHovers";
    private static final String HOVER_TAG = "hover";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String ACTIVATE_PLUG_IN_ATTRIBUTE = "activate";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    public static final String NO_MODIFIER = "0";
    public static final String DISABLED_TAG = "!";
    public static final String VALUE_SEPARATOR = ";";
    private int fStateMask;
    private String fModifierString;
    private boolean fIsEnabled;
    private IConfigurationElement fElement;

    public static PHPEditorTextHoverDescriptor[] getContributedHovers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHP_EDITOR_TEXT_HOVER_EXTENSION_POINT);
        Arrays.sort(elements, new Comparator(){

            public int compare(Object o1, Object o2) {
                IConfigurationElement e1 = (IConfigurationElement)o1;
                IConfigurationElement e2 = (IConfigurationElement)o2;
                int p1 = 0;
                int p2 = 0;
                try {
                    p1 = Integer.valueOf(e1.getAttribute(PHPEditorTextHoverDescriptor.PRIORITY_ATTRIBUTE));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    p2 = Integer.valueOf(e2.getAttribute(PHPEditorTextHoverDescriptor.PRIORITY_ATTRIBUTE));
                }
                catch (NumberFormatException numberFormatException) {}
                return (int)Math.signum(p2 - p1);
            }
        });
        PHPEditorTextHoverDescriptor[] hoverDescs = PHPEditorTextHoverDescriptor.createDescriptors(elements);
        PHPEditorTextHoverDescriptor.initializeFromPreferences(hoverDescs);
        return hoverDescs;
    }

    public static int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = EditorUtility.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    private PHPEditorTextHoverDescriptor(IConfigurationElement element) {
        Assert.isNotNull((Object)element);
        this.fElement = element;
    }

    public IPHPTextHover createTextHover() {
        boolean isHoversPlugInActivated;
        String pluginId = this.fElement.getNamespaceIdentifier();
        boolean bl = isHoversPlugInActivated = Platform.getBundle((String)pluginId).getState() == 32;
        if (isHoversPlugInActivated || this.canActivatePlugIn()) {
            try {
                return (IPHPTextHover)this.fElement.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException x) {
                Logger.logException((String)PHPUIMessages.getString("PHPTextHover_createTextHover"), (Throwable)x);
            }
        }
        return null;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getHoverClassName() {
        return this.fElement.getAttribute(CLASS_ATTRIBUTE);
    }

    public String getLabel() {
        String label = this.fElement.getAttribute(LABEL_ATTRIBUTE);
        if (label != null) {
            return label;
        }
        label = this.getHoverClassName();
        int lastDot = label.lastIndexOf(46);
        if (lastDot >= 0 && lastDot < label.length() - 1) {
            return label.substring(lastDot + 1);
        }
        return label;
    }

    public String getDescription() {
        return this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
    }

    public boolean canActivatePlugIn() {
        return Boolean.valueOf(this.fElement.getAttribute(ACTIVATE_PLUG_IN_ATTRIBUTE));
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass()) || this.getId() == null) {
            return false;
        }
        return this.getId().equals(((PHPEditorTextHoverDescriptor)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private static PHPEditorTextHoverDescriptor[] createDescriptors(IConfigurationElement[] elements) {
        ArrayList<PHPEditorTextHoverDescriptor> result = new ArrayList<PHPEditorTextHoverDescriptor>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (HOVER_TAG.equals(element.getName())) {
                PHPEditorTextHoverDescriptor desc = new PHPEditorTextHoverDescriptor(element);
                result.add(desc);
            }
            ++n2;
        }
        return result.toArray(new PHPEditorTextHoverDescriptor[result.size()]);
    }

    private static void initializeFromPreferences(PHPEditorTextHoverDescriptor[] hovers) {
        String compiledTextHoverModifiers = PreferenceConstants.getPreferenceStore().getString("org.eclipse.php.uihoverModifiers");
        StringTokenizer tokenizer = new StringTokenizer(compiledTextHoverModifiers, VALUE_SEPARATOR);
        HashMap<String, String> idToModifier = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifier.put(id, tokenizer.nextToken());
        }
        String compiledTextHoverModifierMasks = PreferenceConstants.getPreferenceStore().getString("org.eclipse.php.uihoverModifierMasks");
        tokenizer = new StringTokenizer(compiledTextHoverModifierMasks, VALUE_SEPARATOR);
        HashMap<String, String> idToModifierMask = new HashMap<String, String>(tokenizer.countTokens() / 2);
        while (tokenizer.hasMoreTokens()) {
            String id = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            idToModifierMask.put(id, tokenizer.nextToken());
        }
        int i = 0;
        while (i < hovers.length) {
            String modifierString = (String)idToModifier.get(hovers[i].getId());
            boolean enabled = true;
            if (modifierString == null) {
                modifierString = DISABLED_TAG;
            }
            if (modifierString.startsWith(DISABLED_TAG)) {
                enabled = false;
                modifierString = modifierString.substring(1);
            }
            if (modifierString.equals(NO_MODIFIER)) {
                modifierString = "";
            }
            hovers[i].fModifierString = modifierString;
            hovers[i].fIsEnabled = enabled;
            hovers[i].fStateMask = PHPEditorTextHoverDescriptor.computeStateMask(modifierString);
            if (hovers[i].fStateMask == -1) {
                try {
                    hovers[i].fStateMask = Integer.parseInt((String)idToModifierMask.get(hovers[i].getId()));
                }
                catch (NumberFormatException numberFormatException) {
                    hovers[i].fStateMask = -1;
                }
                int stateMask = hovers[i].fStateMask;
                hovers[i].fModifierString = stateMask == -1 ? "" : EditorUtility.getModifierString(stateMask);
            }
            ++i;
        }
    }

    public int getStateMask() {
        return this.fStateMask;
    }

    public String getModifierString() {
        return this.fModifierString;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }
}

