/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.treecontent;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;

class IncludeModelPathRootConverter {
    IncludeModelPathRootConverter() {
    }

    public static String toString(IPhpModel model) {
        return String.valueOf(model.getID().replace('/', '?').replace(File.separatorChar, '!').replace(':', ';'));
    }

    static IPhpModel toPhpModel(String pathRoot, IProject[] projectsToFindIn) {
        String id = pathRoot.replace('?', '/').replace('!', File.separatorChar).replace(';', ':');
        int i = 0;
        while (i < projectsToFindIn.length) {
            IPhpModel model;
            PHPIncludePathModelManager includeModelManager;
            PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(projectsToFindIn[i]);
            if (projectModel != null && (includeModelManager = (PHPIncludePathModelManager)projectModel.getModel("CompositeIncludePathModel")) != null && (model = includeModelManager.getModel(id)) != null) {
                return model;
            }
            ++i;
        }
        return null;
    }

    public static IPhpModel from(String pathRoot, IProject project) {
        return IncludeModelPathRootConverter.toPhpModel(pathRoot, new IProject[]{project});
    }

    public static IPhpModel from(String pathRoot) {
        return IncludeModelPathRootConverter.toPhpModel(pathRoot, ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }
}

