/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.treecontent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.IncludePathModelListener;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.treecontent.IncludeModelPathRootConverter;
import org.eclipse.php.internal.ui.treecontent.IncludesNode;
import org.eclipse.php.internal.ui.treecontent.PHPTreeNode;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.graphics.Image;

public class IncludePathTreeContent
implements IPHPTreeContentProvider,
IWorkspaceModelListener {
    private static final String INCLUDE_PATHS_NODE_ID = "org.eclipse.php.ui.treecontent.IncludesNode";
    private static final String INCLUDE_PATHS_NODE_NAME = "Include Paths";
    static final IPath INCLUDE_PATHS_ROOT_PATH = new Path("\u0000IncludePaths");
    static final ElementTree includePathTree = new ElementTree();
    private static final Map<IProject, IncludesNode> projectNodes = new HashMap<IProject, IncludesNode>();
    private TreeViewer treeViewer;
    private Map<IProject, PHPProjectOptions> projectOptions;

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        return element instanceof PHPTreeNode;
    }

    public synchronized Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            return this.getProjectChildren((IProject)parentElement);
        }
        if (parentElement instanceof PHPTreeNode && INCLUDE_PATHS_NODE_ID.equals(((PHPTreeNode)parentElement).getId())) {
            return IncludePathTreeContent.getTreeNodeChildren((PHPTreeNode)parentElement);
        }
        if (parentElement instanceof PHPIncludePathModel || parentElement instanceof PhpModelProxy) {
            return IncludePathTreeContent.getIncludeModelChildren((IPhpModel)parentElement);
        }
        if (parentElement instanceof IFolder) {
            return IncludePathTreeContent.getFolderChildren((IFolder)parentElement);
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (includePathTree == null) {
            return null;
        }
        if (element instanceof PHPFileData) {
            return IncludePathTreeContent.getFileParent((PHPFileData)element);
        }
        if (element instanceof IFolder) {
            return IncludePathTreeContent.getFolderParent((IFolder)element);
        }
        if (element instanceof PHPIncludePathModel) {
            PHPIncludePathModel includeModel = (PHPIncludePathModel)element;
            return IncludePathTreeContent.getIncludeModelParent(includeModel);
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public void dispose() {
        for (Map.Entry<IProject, IncludesNode> entry : projectNodes.entrySet()) {
            IProject project = entry.getKey();
            IncludesNode node = entry.getValue();
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)node);
            PHPProjectOptions options = PHPProjectOptions.forProject((IProject)project);
            options.removeOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)node);
        }
    }

    public String getText(Object element) {
        if (element instanceof PHPTreeNode) {
            return this.getNodeText((PHPTreeNode)element);
        }
        if (element instanceof PHPIncludePathModel) {
            return this.getIncludeModelText((PHPIncludePathModel)element);
        }
        if (element instanceof PhpModelProxy) {
            PhpModelProxy proxy = (PhpModelProxy)element;
            return this.getProjectModelText(proxy);
        }
        if (element instanceof PHPFileData) {
            return this.getFileText((PHPFileData)element);
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof PHPTreeNode) {
            PHPTreeNode treeNode = (PHPTreeNode)element;
            return treeNode.getImage();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private static void createFileNode(CodeData fileData, IPath fileTreeLocation) {
        includePathTree.createElement(fileTreeLocation, (Object)fileData);
    }

    private IncludesNode createIncludePathsNode(IProject project) {
        PHPIncludePathModelManager includeModelManager;
        Image image = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_LIBRARY);
        IncludesNode treeNode = new IncludesNode(INCLUDE_PATHS_NODE_NAME, image, INCLUDE_PATHS_NODE_ID, project, this);
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)treeNode);
        projectNodes.put(project, treeNode);
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        if (projectModel != null && (includeModelManager = (PHPIncludePathModelManager)projectModel.getModel("CompositeIncludePathModel")) != null) {
            includeModelManager.addIncludePathModelListener((IncludePathModelListener)treeNode);
        }
        PHPProjectOptions options = PHPProjectOptions.forProject((IProject)project);
        options.addOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)treeNode);
        if (this.projectOptions == null) {
            this.projectOptions = new HashMap<IProject, PHPProjectOptions>();
        }
        this.projectOptions.put(project, options);
        return treeNode;
    }

    private void updateIncludePathsNode(IncludesNode treeNode) {
        IProject project = (IProject)treeNode.getData();
        PHPProjectOptions options = PHPProjectOptions.forProject((IProject)project);
        if (options == null) {
            return;
        }
        options.addOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)treeNode);
    }

    private static void createIncludePathTree(IPath modelPath, IPhpModel includePathModel) {
        CodeData[] fileDatas;
        IPath includeModelLocation = PHPModelUtil.getIncludeModelLocation((IPhpModel)includePathModel);
        CodeData[] codeDataArray = fileDatas = includePathModel.getFileDatas();
        int n = fileDatas.length;
        int n2 = 0;
        while (n2 < n) {
            CodeData fileData = codeDataArray[n2];
            String fileName = fileData.getName();
            Path fileLocation = new Path(fileName);
            IPath fileTreeLocation = modelPath.append(fileLocation.removeFirstSegments(includeModelLocation.segmentCount()));
            if (!includePathTree.includes(fileTreeLocation)) {
                IPath existingIncludePathFolderNode = IncludePathTreeContent.findExistingIncludePathFolderNode(modelPath, fileTreeLocation);
                IncludePathTreeContent.createMissingIncludePathFolderNodes(fileTreeLocation, existingIncludePathFolderNode);
                IncludePathTreeContent.createFileNode(fileData, fileTreeLocation);
            }
            ++n2;
        }
    }

    private static void createMissingIncludePathFolderNodes(IPath fileTreeLocation, IPath existingIncludePathFolder) {
        IPath missingDirectoryTreeLocation = existingIncludePathFolder;
        do {
            missingDirectoryTreeLocation = missingDirectoryTreeLocation.append(fileTreeLocation.segment(missingDirectoryTreeLocation.segmentCount()));
            includePathTree.createElement(missingDirectoryTreeLocation, (Object)((Workspace)ResourcesPlugin.getWorkspace()).newResource(missingDirectoryTreeLocation, 2));
        } while (missingDirectoryTreeLocation.segmentCount() < fileTreeLocation.segmentCount());
    }

    private static IPath findExistingIncludePathFolderNode(IPath modelPath, IPath fileTreeLocation) {
        IPath existingFolderTreeLocation = fileTreeLocation;
        while ((existingFolderTreeLocation = existingFolderTreeLocation.removeLastSegments(1)).segmentCount() > modelPath.segmentCount() && !includePathTree.includes(existingFolderTreeLocation)) {
        }
        return existingFolderTreeLocation;
    }

    static IPhpModel findModel(PHPFileData fileData) {
        IncludePathTreeContent.validateRoot();
        IPath[] modelPaths = includePathTree.getChildren(INCLUDE_PATHS_ROOT_PATH);
        IResource res = PHPModelUtil.getResource((Object)fileData);
        Path filePath = new Path(fileData.getName());
        String filePathString = filePath.toOSString();
        if (res != null) {
            IPath location = res.getLocation();
            filePathString = location != null ? location.toOSString() : res.getLocationURI().toString();
        }
        int i = 0;
        while (i < modelPaths.length) {
            IPath modelLocation;
            IPhpModel model = IncludeModelPathRootConverter.from(modelPaths[i].segment(1));
            if (model != null && (modelLocation = PHPModelUtil.getIncludeModelLocation((IPhpModel)model)) != null && (filePathString.startsWith(modelLocation.toOSString()) || filePath.isAbsolute() && filePath.segment(0).equals(model.getID()))) {
                return model;
            }
            ++i;
        }
        return null;
    }

    private static Object[] getTreeChildrenElements(IPath parentPath) {
        IPath[] childrenPaths = includePathTree.getChildren(parentPath);
        Object[] childrenElements = new Object[childrenPaths.length];
        int i = 0;
        while (i < childrenPaths.length) {
            childrenElements[i] = includePathTree.getElementData(childrenPaths[i]);
            ++i;
        }
        return childrenElements;
    }

    private static Object[] getFolderChildren(IFolder resource) {
        IPath resourcePath = resource.getFullPath();
        if (includePathTree.includes(resource.getFullPath())) {
            return IncludePathTreeContent.getPathChildren(resourcePath);
        }
        return NO_CHILDREN;
    }

    public static Object[] getIncludeModelChildren(IPhpModel includePathModel) {
        IPath modelPath = INCLUDE_PATHS_ROOT_PATH.append(IncludeModelPathRootConverter.toString(includePathModel));
        if (!includePathTree.includes(modelPath)) {
            IncludePathTreeContent.validateRoot();
            includePathTree.createElement(modelPath, (Object)includePathModel);
        }
        return IncludePathTreeContent.getPathChildren(modelPath);
    }

    private static Object getIncludeModelParent(PHPIncludePathModel includeModel) {
        IPath modelPath = INCLUDE_PATHS_ROOT_PATH.append(IncludeModelPathRootConverter.toString((IPhpModel)includeModel));
        if (includePathTree.includes(modelPath)) {
            for (IncludesNode includePathNode : projectNodes.values()) {
                Object[] children = IncludePathTreeContent.getTreeNodeChildren(includePathNode);
                int j = 0;
                while (j < children.length) {
                    if (children[j] == includeModel) {
                        return includePathNode;
                    }
                    ++j;
                }
            }
        }
        return null;
    }

    private static Object getFolderParent(IFolder folder) {
        IPath folderPath = folder.getFullPath();
        if (includePathTree.includes(folderPath)) {
            return includePathTree.getElementData(folderPath.removeLastSegments(1));
        }
        return null;
    }

    private static Object getFileParent(PHPFileData fileData) {
        String fileName = fileData.getName();
        Path fileLocation = new Path(fileName);
        if (!includePathTree.includes(INCLUDE_PATHS_ROOT_PATH)) {
            return null;
        }
        IPath[] modelPaths = includePathTree.getChildren(INCLUDE_PATHS_ROOT_PATH);
        int i = 0;
        while (i < modelPaths.length) {
            IPath fileTreeLocation;
            Object elementData = includePathTree.getElementData(modelPaths[i]);
            IPath includeLocation = PHPModelUtil.getIncludeModelLocation((IPhpModel)((IPhpModel)elementData));
            if ((fileName.startsWith(includeLocation.toOSString()) || fileName.startsWith(includeLocation.makeAbsolute().toString())) && includePathTree.includes(fileTreeLocation = modelPaths[i].append(fileLocation.removeFirstSegments(includeLocation.segmentCount())))) {
                IPath parentTreeLocation = fileTreeLocation.removeLastSegments(1);
                return includePathTree.getElementData(parentTreeLocation);
            }
            ++i;
        }
        return null;
    }

    private static Object[] getPathChildren(IPath parentPath) {
        IPath modelPath = parentPath.uptoSegment(2);
        if (!includePathTree.includes(modelPath)) {
            return NO_CHILDREN;
        }
        Object model = includePathTree.getElementData(modelPath);
        if (!(model instanceof PHPIncludePathModel) && !(model instanceof PhpModelProxy)) {
            return NO_CHILDREN;
        }
        IncludePathTreeContent.createIncludePathTree(modelPath, (IPhpModel)model);
        return IncludePathTreeContent.getTreeChildrenElements(parentPath);
    }

    private Object[] getProjectChildren(IProject project) {
        PHPWorkspaceModelManager.getInstance().addWorkspaceModelListener(project.getName(), (IWorkspaceModelListener)this);
        PHPProjectOptions options = PHPProjectOptions.forProject((IProject)project);
        if (options != null) {
            return new Object[]{this.getTreeNode(project)};
        }
        return NO_CHILDREN;
    }

    private String getProjectModelText(PhpModelProxy proxy) {
        return proxy.getID();
    }

    private String getNodeText(PHPTreeNode treeNode) {
        return treeNode.getText();
    }

    private String getFileText(PHPFileData fileData) {
        IPath[] modelPaths = includePathTree.getChildren(includePathTree.getRoot());
        int i = 0;
        while (i < modelPaths.length) {
            PHPIncludePathModel includePathModel = (PHPIncludePathModel)includePathTree.getElementData(modelPaths[i]);
            IPath includePath = PHPModelUtil.getIncludeModelLocation((IPhpModel)includePathModel);
            if (fileData.getName().startsWith(includePath.toOSString())) {
                return new Path(fileData.getName()).lastSegment();
            }
            ++i;
        }
        return null;
    }

    private String getIncludeModelText(PHPIncludePathModel includePathModel) {
        String id = includePathModel.getID();
        IPath location = IncludePathVariableManager.instance().getIncludePathVariable(includePathModel.getID());
        if (location != null) {
            return String.valueOf(id) + " (" + IncludePathVariableManager.instance().getIncludePathVariable(includePathModel.getID()).toOSString() + ")";
        }
        return id;
    }

    private IncludesNode getTreeNode(IProject project) {
        IncludesNode treeNode = projectNodes.get(project);
        if (treeNode == null) {
            if (!project.isAccessible()) {
                return null;
            }
            treeNode = this.createIncludePathsNode(project);
        } else {
            this.updateIncludePathsNode(treeNode);
        }
        Object[] models = IncludePathTreeContent.getTreeNodeChildren(treeNode);
        if (models.length > 0) {
            int i = 0;
            while (i < models.length) {
                IncludePathTreeContent.getIncludeModelChildren((IPhpModel)models[i]);
                ++i;
            }
        }
        return treeNode;
    }

    private static Object[] getTreeNodeChildren(PHPTreeNode treeNode) {
        IProject project = null;
        for (Map.Entry<IProject, IncludesNode> entry : projectNodes.entrySet()) {
            if (entry.getValue() != treeNode) continue;
            project = entry.getKey();
            break;
        }
        if (project == null) {
            return NO_CHILDREN;
        }
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        if (projectModel == null) {
            return NO_CHILDREN;
        }
        PHPIncludePathModelManager includeModelManager = (PHPIncludePathModelManager)projectModel.getModel("CompositeIncludePathModel");
        if (includeModelManager == null) {
            return NO_CHILDREN;
        }
        IPhpModel[] models = includeModelManager.listModels();
        ArrayList<IPhpModel> filteredModels = new ArrayList<IPhpModel>(models.length);
        int i = 0;
        while (i < models.length) {
            IPath modelLocation = PHPModelUtil.getIncludeModelLocation((IPhpModel)models[i]);
            if (modelLocation != null) {
                filteredModels.add(models[i]);
            }
            ++i;
        }
        return filteredModels.toArray();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    private static void validateRoot() {
        if (!includePathTree.includes(INCLUDE_PATHS_ROOT_PATH)) {
            includePathTree.createElement(INCLUDE_PATHS_ROOT_PATH, (Object)INCLUDE_PATHS_ROOT_PATH.segment(1));
        }
    }

    public void projectModelAdded(IProject project) {
        PHPIncludePathModelManager includeModelManager;
        IncludesNode treeNode = this.getTreeNode(project);
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        if (projectModel != null && (includeModelManager = (PHPIncludePathModelManager)projectModel.getModel("CompositeIncludePathModel")) != null) {
            includeModelManager.addIncludePathModelListener((IncludePathModelListener)treeNode);
        }
        treeNode.refresh();
    }

    public void projectModelChanged(IProject project) {
        this.projectModelAdded(project);
    }

    public void projectModelRemoved(IProject project) {
        PHPIncludePathModelManager includeModelManager;
        IncludesNode treeNode = this.getTreeNode(project);
        PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        if (projectModel != null && (includeModelManager = (PHPIncludePathModelManager)projectModel.getModel("CompositeIncludePathModel")) != null) {
            includeModelManager.removeIncludePathModelListener((IncludePathModelListener)treeNode);
        }
        if (this.projectOptions != null) {
            PHPProjectOptions options = this.projectOptions.get(project);
            if (options != null && projectNodes != null) {
                IncludesNode node = projectNodes.get(project);
                PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)node);
                options.removeOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)node);
            }
            this.projectOptions.remove(project);
        }
        if (projectNodes != null) {
            projectNodes.remove(project);
        }
        includePathTree.getDataTree().empty();
    }
}

