/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PHPElementLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_PARAMETER_NAMES = 2;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int I_POST_QUALIFIED = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int T_CONTAINER_QUALIFIED = 16384;
    public static final int T_POST_QUALIFIED = 32768;
    public static final int CU_QUALIFIED = 65536;
    public static final int CU_POST_QUALIFIED = 131072;
    public static final int P_QUALIFIED = 0x400000;
    public static final int P_POST_QUALIFIED = 0x800000;
    public static final int ROOT_VARIABLE = 0x1000000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int P_COMPRESSED = 0x20000000;
    public static final int REFERENCED_ROOT_POST_QUALIFIED = 0x40000000;
    public static final long T_TYPE_PARAMETERS = 0x200000L;
    public static final long CF_POST_QUALIFIED = 0x10000000L;
    public static final long CF_QUALIFIED = 0x8000000L;
    public static final long I_FULLY_QUALIFIED = 1024L;
    public static final long D_QUALIFIED = 0x1000000L;
    public static final long D_POST_QUALIFIED = 0x2000000L;
    public static final int ALL_FULLY_QUALIFIED = 37824544;
    public static final int ALL_POST_QUALIFIED = 75665728;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 75808;
    public static final int DEFAULT_POST_QUALIFIED = 168256;
    public static final String CONCAT_STRING = " - ";
    public static final String COMMA_STRING = ", ";
    public static final String DECL_STRING = " : ";
    public static final String DEFAULT_FOLDER = "(source)";
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;

    static {
        fgPkgNameLength = -1;
    }

    public static String getElementLabel(Object element, long flags) {
        StringBuffer buf = new StringBuffer(60);
        PHPElementLabels.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void getElementLabel(Object element, long flags, StringBuffer buf) {
        IContainer root = null;
        if (element instanceof PHPCodeData) {
            root = PHPModelUtil.getPHPFolderRoot((PHPCodeData)((PHPCodeData)element));
        }
        if (root != null && PHPElementLabels.getFlag(flags, 0x10000000L)) {
            PHPElementLabels.getPHPFolderRootLabel(root, 0x2000000L, buf);
            buf.append(CONCAT_STRING);
        }
        if (element instanceof PHPFunctionData) {
            PHPElementLabels.getMethodLabel((PHPFunctionData)element, flags, buf);
        } else if (element instanceof PHPVariableData) {
            PHPElementLabels.getFieldLabel((PHPVariableData)element, flags, buf);
        } else if (element instanceof PHPClassData) {
            PHPElementLabels.getTypeLabel((PHPClassData)element, flags, buf);
        } else if (element instanceof PHPConstantData) {
            buf.append(((PHPConstantData)element).getName());
        } else if (element instanceof PHPClassConstData) {
            buf.append(((PHPClassConstData)element).getName());
        } else if (element instanceof PHPClassData.PHPSuperClassNameData) {
            buf.append(((PHPClassData.PHPSuperClassNameData)element).getName());
        } else if (element instanceof PHPFileData) {
            PHPElementLabels.getCompilationUnitLabel((PHPFileData)element, flags, buf);
        } else if (element instanceof PHPIncludeFileData) {
            PHPElementLabels.getIncludeFileLabel((PHPIncludeFileData)element, flags, buf);
        } else if (element instanceof IFolder) {
            PHPElementLabels.getPHPFolderLabel((IContainer)((IFolder)element), flags, buf);
        } else if (element instanceof PHPProjectModel) {
            IProject project = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)element);
            buf.append(project.getName());
        } else if (element instanceof PHPWorkspaceModelManager) {
            buf.append("PHP Model");
        } else if (element instanceof IResource) {
            buf.append(((IResource)element).getName());
        } else if (element instanceof IPhpModel) {
            buf.append(((IPhpModel)element).getID());
        }
        if (root != null && PHPElementLabels.getFlag(flags, 0x8000000L)) {
            buf.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderRootLabel(root, 0x2000000L, buf);
        }
    }

    private static boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static void getPHPFolderLabel(IContainer folder, long flags, StringBuffer buf) {
        if (PHPElementLabels.getFlag(flags, 0x400000L)) {
            PHPElementLabels.getPHPFolderRootLabel(folder.getParent(), 0x2000000L, buf);
            buf.append('/');
        }
        if (folder instanceof IProject) {
            IPath path = folder.getFullPath();
            IPath projectPath = folder.getProject().getFullPath();
            if ((path = path.removeFirstSegments(projectPath.segmentCount())).segmentCount() > 0) {
                buf.append(path.toString());
            } else {
                buf.append(DEFAULT_FOLDER);
            }
        } else if (PHPElementLabels.getFlag(flags, 0x20000000L) && fgPkgNameLength >= 0) {
            String name = folder.getName();
            int start = 0;
            int dot = name.indexOf(46, start);
            while (dot > 0) {
                if (dot - start > fgPkgNameLength - 1) {
                    buf.append(fgPkgNamePrefix);
                    if (fgPkgNameChars > 0) {
                        buf.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                    }
                    buf.append(fgPkgNamePostfix);
                } else {
                    buf.append(name.substring(start, dot + 1));
                }
                start = dot + 1;
                dot = name.indexOf(46, start);
            }
            buf.append(name.substring(start));
        } else {
            buf.append(folder.getName());
        }
        if (PHPElementLabels.getFlag(flags, 0x800000L)) {
            buf.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderRootLabel(folder.getParent(), 0x2000000L, buf);
        }
    }

    public static void getPHPFolderRootLabel(IContainer root, long flags, StringBuffer buf) {
        PHPElementLabels.getFolderLabel(root, flags, buf);
    }

    private static void getFolderLabel(IContainer root, long flags, StringBuffer buf) {
        IContainer resource = root;
        boolean rootQualified = PHPElementLabels.getFlag(flags, 0x2000000L);
        if (rootQualified) {
            buf.append(root.getFullPath().makeRelative().toString());
        } else {
            if (resource != null) {
                buf.append(resource.getProjectRelativePath().toString());
            } else {
                buf.append(root.getName());
            }
            if (PHPElementLabels.getFlag(flags, 0x4000000L)) {
                buf.append(CONCAT_STRING);
                buf.append(root.getParent().getName());
            }
        }
    }

    public static void getMethodLabel(PHPFunctionData method, long flags, StringBuffer buf) {
        String rt;
        buf.append(method.getName());
        if (PHPElementLabels.getFlag(flags, 3L)) {
            PHPFunctionData.PHPFunctionParameter[] parameters = method.getParameters();
            buf.append('(');
            int nParams = parameters != null && PHPElementLabels.getFlag(flags, 1L) ? parameters.length : 0;
            int i = 0;
            while (i < nParams) {
                if (i > 0) {
                    buf.append(COMMA_STRING);
                    buf.append(" ");
                }
                if (PHPElementLabels.getFlag(flags, 1L)) {
                    String t = parameters[i].getClassType();
                    t = t == null ? "" : String.valueOf(t) + " ";
                    buf.append(t);
                }
                if (PHPElementLabels.getFlag(flags, 2L)) {
                    buf.append("$" + parameters[i].getName());
                    String defaultValue = parameters[i].getDefaultValue();
                    if (defaultValue != null && !defaultValue.equals("")) {
                        buf.append(" = " + defaultValue);
                    }
                }
                ++i;
            }
            buf.append(')');
        }
        if (PHPElementLabels.getFlag(flags, 16L)) {
            rt = method.getReturnType();
            buf.insert(0, String.valueOf(rt) + DECL_STRING);
        }
        if (PHPElementLabels.getFlag(flags, 8L)) {
            rt = method.getReturnType();
            buf.append(DECL_STRING);
            buf.append(rt);
        }
        if (PHPElementLabels.getFlag(flags, 64L)) {
            buf.append(CONCAT_STRING);
            PHPCodeData container = method.getContainer();
            PHPClassData containerClass = null;
            if (container != null && container instanceof PHPClassData) {
                containerClass = (PHPClassData)container;
            }
            PHPElementLabels.getTypeLabel(containerClass, 0x2000L | flags & 0x20000000L, buf);
        }
    }

    public static void getTypeLabel(PHPClassData type, long flags, StringBuffer buf) {
        IContainer folder;
        IFile file;
        if (type == null) {
            return;
        }
        if (PHPElementLabels.getFlag(flags, 8192L) && (file = (IFile)PHPModelUtil.getResource((Object)type)) != null && !((folder = file.getParent()) instanceof IProject)) {
            PHPElementLabels.getPHPFolderLabel(folder, flags & 0x20000000L, buf);
            buf.append('.');
        }
        String typeName = type.getName();
        buf.append(typeName);
        if (PHPElementLabels.getFlag(flags, 32768L)) {
            IFile file2 = (IFile)PHPModelUtil.getResource((Object)type);
            IContainer folder2 = file2.getParent();
            buf.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderLabel(folder2, flags & 0x20000000L, buf);
        }
    }

    public static void getFieldLabel(PHPVariableData field, long flags, StringBuffer buf) {
        buf.append(field.getName());
        if (PHPElementLabels.getFlag(flags, 4096L)) {
            buf.append(CONCAT_STRING);
            PHPCodeData container = field.getContainer();
            PHPClassData containerClass = null;
            if (container != null && container instanceof PHPClassData) {
                containerClass = (PHPClassData)container;
            }
            PHPElementLabels.getTypeLabel(containerClass, 0x2000L | flags & 0x20000000L, buf);
        }
    }

    public static void getIncludeFileLabel(PHPIncludeFileData data, long flags, StringBuffer buf) {
        IContainer folder;
        IFile file;
        if (PHPElementLabels.getFlag(flags, 65536L) && (file = (IFile)PHPModelUtil.getResource((Object)data)) != null && !((folder = file.getParent()) instanceof IProject)) {
            buf.append(folder.getName());
            buf.append('.');
        }
        buf.append(data.getName());
        if (PHPElementLabels.getFlag(flags, 131072L)) {
            file = (IFile)PHPModelUtil.getResource((Object)data);
            folder = file.getParent();
            buf.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderLabel(folder, 0L, buf);
        }
    }

    public static void getCompilationUnitLabel(PHPFileData cu, long flags, StringBuffer buf) {
        IContainer folder;
        IFile file;
        if (PHPElementLabels.getFlag(flags, 65536L) && (file = (IFile)PHPModelUtil.getResource((Object)cu)) != null && !((folder = file.getParent()) instanceof IProject)) {
            buf.append(folder.getName());
            buf.append('.');
        }
        Path path = new Path(cu.getName());
        IFile resourceFile = null;
        try {
            resourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (resourceFile != null && resourceFile.exists()) {
            buf.append(cu.getComparableName());
        } else {
            int indexOfZip = cu.getName().indexOf(".zip");
            if (indexOfZip != -1) {
                buf.append(cu.getComparableName());
            } else {
                buf.append(cu.getComparableName());
            }
        }
        if (PHPElementLabels.getFlag(flags, 131072L)) {
            IFile file2 = (IFile)PHPModelUtil.getResource((Object)cu);
            IContainer folder2 = file2.getParent();
            buf.append(CONCAT_STRING);
            PHPElementLabels.getPHPFolderLabel(folder2, 0L, buf);
        }
    }

    public static String getElementTooltipText(Object element) {
        StringBuffer buf = new StringBuffer(60);
        if (element instanceof PHPFunctionData) {
            PHPElementLabels.getMethodTooltipText((PHPFunctionData)element, buf);
        } else if (element instanceof PHPClassData) {
            PHPElementLabels.getClassTooltipText((PHPClassData)element, buf);
        } else if (element instanceof PHPConstantData) {
            buf.append(((PHPConstantData)element).getName());
        }
        return buf.toString();
    }

    public static void getClassTooltipText(PHPClassData classData, StringBuffer buf) {
        if (classData == null) {
            return;
        }
        buf.append(classData.getName());
        if (classData.getDocBlock() != null) {
            buf.append("\n" + classData.getDocBlock().getShortDescription());
        }
    }

    public static void getMethodTooltipText(PHPFunctionData method, StringBuffer buf) {
        buf.append(method.getName());
        buf.append('(');
        PHPFunctionData.PHPFunctionParameter[] parameters = method.getParameters();
        int i = 0;
        while (i < parameters.length) {
            if (i > 0) {
                buf.append(COMMA_STRING);
            }
            buf.append(parameters[i].getClassType());
            buf.append(" $" + parameters[i].getName());
            String defaultValue = parameters[i].getDefaultValue();
            if (!defaultValue.equals("")) {
                buf.append(" = " + defaultValue);
            }
            ++i;
        }
        buf.append(')');
        buf.append(DECL_STRING);
        buf.append(method.getReturnType());
        if (method.getDocBlock() != null) {
            buf.append("\n" + method.getDocBlock().getShortDescription());
        }
    }

    public static String getTextLabel(Object obj, long flags) {
        if (obj instanceof PHPCodeData || obj instanceof PHPProjectModel || obj instanceof IPhpModel) {
            return PHPElementLabels.getElementLabel(obj, flags);
        }
        if (obj instanceof IAdaptable) {
            IWorkbenchAdapter wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class);
            if (wbadapter != null) {
                return wbadapter.getLabel(obj);
            }
        } else if (obj != null && obj.equals("constants")) {
            return obj.toString();
        }
        return "";
    }

    public static String getTooltipTextLabel(Object obj) {
        if (obj instanceof PHPCodeData || obj instanceof PHPProjectModel) {
            return PHPElementLabels.getElementTooltipText(obj);
        }
        if (obj instanceof IAdaptable) {
            IWorkbenchAdapter wbadapter = (IWorkbenchAdapter)((IAdaptable)obj).getAdapter(IWorkbenchAdapter.class);
            if (wbadapter != null) {
                return wbadapter.getLabel(obj);
            }
        } else if (obj != null && obj.equals("constants")) {
            return obj.toString();
        }
        return "";
    }
}

