/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.util.PHPElementImageProvider;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.StorageLabelProvider;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class PHPUILabelProvider
extends LabelProvider
implements IColorProvider {
    protected PHPElementImageProvider fImageLabelProvider = new PHPElementImageProvider();
    protected StorageLabelProvider fStorageLabelProvider = new StorageLabelProvider();
    private int fImageFlags;
    private int fTextFlags;
    IPHPTreeContentProvider[] treeProviders;

    public PHPUILabelProvider() {
        this(3, 11);
    }

    public PHPUILabelProvider(int textFlags, int imageFlags) {
        this.fImageFlags = imageFlags;
        this.fTextFlags = textFlags;
    }

    public void setTreeProviders(IPHPTreeContentProvider[] providers) {
        this.treeProviders = providers;
    }

    public final void setTextFlags(int textFlags) {
        this.fTextFlags = textFlags;
    }

    public final void setImageFlags(int imageFlags) {
        this.fImageFlags = imageFlags;
    }

    public final int getImageFlags() {
        return this.fImageFlags;
    }

    public final int getTextFlags() {
        return this.fTextFlags;
    }

    protected int evaluateImageFlags(Object element) {
        return this.getImageFlags();
    }

    protected int evaluateTextFlags(Object element) {
        return this.getTextFlags();
    }

    public Image getImage(Object element) {
        Image result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        if (result == null && this.treeProviders != null) {
            int i = 0;
            while (i < this.treeProviders.length && result == null) {
                result = this.treeProviders[i].getImage(element);
                ++i;
            }
        }
        if (result == null && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        String result = PHPElementLabels.getTextLabel(element, this.evaluateTextFlags(element));
        if (result.length() == 0 && this.treeProviders != null) {
            int i = 0;
            while (i < this.treeProviders.length) {
                result = this.treeProviders[i].getText(element);
                if (result != null && result.length() > 0) break;
                ++i;
            }
            if (result == null) {
                result = "";
            }
        }
        if (result.length() == 0 && element instanceof IStorage) {
            result = this.fStorageLabelProvider.getText(element);
        }
        return result;
    }

    public void dispose() {
        this.fStorageLabelProvider.dispose();
        this.fImageLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

