/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.PropertyTesters;

import java.net.URI;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.ui.containers.LocalFileStorageEditorInput;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PHPLaunchPropertyTester
extends PropertyTester {
    private static final Object PHP_SOURCE_ID = "org.eclipse.php.core.phpsource";
    private static final String SCRIPT_ID = "script";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        List list;
        if (receiver instanceof List && (list = (List)receiver).size() > 0) {
            String launchType = args.length > 0 ? args[0].toString() : "";
            IFile file = null;
            Object obj = list.get(0);
            if (obj instanceof FileEditorInput) {
                FileEditorInput editorInput = (FileEditorInput)list.get(0);
                file = editorInput.getFile();
            } else if (obj instanceof IFile) {
                file = (IFile)obj;
            } else if (SCRIPT_ID.equalsIgnoreCase(launchType)) {
                if (obj instanceof LocalFileStorageEditorInput) {
                    LocalFileStorageEditorInput editorInput = (LocalFileStorageEditorInput)obj;
                    IPath fullPath = editorInput.getStorage().getFullPath();
                    file = ExternalFilesRegistry.getInstance().getFileEntry(fullPath.toOSString());
                    if (file == null) {
                        return false;
                    }
                } else if (obj instanceof IURIEditorInput || obj instanceof NonExistingPHPFileEditorInput) {
                    IPath fullPath = null;
                    fullPath = obj instanceof IURIEditorInput ? URIUtil.toPath((URI)((IURIEditorInput)obj).getURI()) : ((NonExistingPHPFileEditorInput)obj).getPath();
                    file = ExternalFilesRegistry.getInstance().getFileEntry(fullPath.toOSString());
                }
            }
            try {
                if (file != null && file.getProject() != null && !file.getProject().hasNature("org.eclipse.php.core.PHPNature") && !SCRIPT_ID.equalsIgnoreCase(launchType)) {
                    return false;
                }
            }
            catch (CoreException coreException) {}
            try {
                return file.getContentDescription().getContentType().getId().equals(PHP_SOURCE_ID);
            }
            catch (ResourceException resourceException) {
                return PHPModelUtil.isPhpFile((IFile)file);
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

