/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.breakpoint.provider;

import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.ui.editor.input.IPlatformIndependentPathEditorInput;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.util.StatusLineMessageTimerManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;

public class PHPBreakpointProvider
implements IBreakpointProvider,
IExecutableExtension {
    public IStatus addBreakpoint(IDocument document, IEditorInput input, int editorLineNumber, int offset) throws CoreException {
        int pos = PHPBreakpointProvider.getValidPosition(document, editorLineNumber);
        try {
            editorLineNumber = document.getLineOfOffset(pos) + 1;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return new Status(4, PHPDebugUIPlugin.getID(), "Invalid breakpoint locationgetRawPath();");
        }
        Status status = null;
        IBreakpoint point = null;
        if (pos >= 0) {
            IResource res = this.getResourceFromInput(input);
            if (res != null && input instanceof IFileEditorInput) {
                try {
                    Integer lineNumberInt = new Integer(editorLineNumber);
                    IMarker[] breakpoints = res.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    int i = 0;
                    while (i < breakpoints.length) {
                        if (breakpoints[i].getAttributes().get("lineNumber").equals(lineNumberInt)) {
                            throw new BadLocationException();
                        }
                        ++i;
                    }
                    point = PHPDebugTarget.createBreakpoint((IResource)res, (int)editorLineNumber);
                }
                catch (BadLocationException badLocationException) {}
            } else if (input instanceof IURIEditorInput || input instanceof NonExistingPHPFileEditorInput) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                String pathName = null;
                pathName = input instanceof IPlatformIndependentPathEditorInput ? ((IPlatformIndependentPathEditorInput)input).getPath() : (input instanceof IURIEditorInput ? (res instanceof ExternalFileWrapper ? res.getFullPath().toOSString() : URIUtil.toPath((URI)((IURIEditorInput)input).getURI()).toOSString()) : ((NonExistingPHPFileEditorInput)input).getPath().toString());
                if (res instanceof IWorkspaceRoot) {
                    attributes.put("org.eclipse.php.debug.core.Storage_Type", "org.eclipse.php.debug.core.Remote");
                } else {
                    attributes.put("org.eclipse.php.debug.core.Storage_Type", "org.eclipse.php.debug.core.External");
                }
                attributes.put("org.eclipse.php.debug.core.Storage_File", pathName);
                attributes.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", pathName);
                try {
                    Integer lineNumberInt = new Integer(editorLineNumber);
                    IMarker[] breakpoints = res.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    int i = 0;
                    while (i < breakpoints.length) {
                        if (breakpoints[i].getAttributes().get("lineNumber").equals(lineNumberInt)) {
                            throw new BadLocationException();
                        }
                        ++i;
                    }
                    point = PHPDebugTarget.createBreakpoint((IResource)res, (int)editorLineNumber, attributes);
                }
                catch (BadLocationException badLocationException) {}
            } else if (input instanceof IStorageEditorInput) {
                String fileName;
                IStorage storage = ((IStorageEditorInput)input).getStorage();
                HashMap<String, String> attributes = new HashMap<String, String>();
                String secondaryId = storage.getFullPath().toOSString();
                attributes.put("org.eclipse.wst.sse.ui.extensions.breakpoint.path", secondaryId);
                if (storage instanceof LocalFileStorage) {
                    IProject project;
                    attributes.put("org.eclipse.php.debug.core.Storage_Type", "org.eclipse.php.debug.core.Include");
                    fileName = ((LocalFileStorage)storage).getName();
                    String incDir = ((LocalFileStorage)storage).getIncBaseDirName();
                    if (incDir != null) {
                        fileName = secondaryId.substring(incDir.length() + 1);
                    }
                    attributes.put("org.eclipse.php.debug.core.Project", (project = ((LocalFileStorage)storage).getProject()) != null ? project.getName() : "");
                    attributes.put("org.eclipse.php.debug.core.Include_Path_Basedir", incDir != null ? incDir : "");
                } else {
                    attributes.put("org.eclipse.php.debug.core.Storage_Type", "org.eclipse.php.debug.core.Remote");
                    fileName = storage.getName();
                }
                attributes.put("org.eclipse.php.debug.core.Storage_File", fileName);
                point = PHPDebugTarget.createBreakpoint((IResource)res, (int)editorLineNumber, attributes);
            }
        }
        if (point == null) {
            StatusLineMessageTimerManager.setErrorMessage((String)PHPDebugUIMessages.ErrorCreatingBreakpoint_1, (long)1000L, (boolean)true);
        }
        if (status == null) {
            status = new Status(0, PHPDebugUIPlugin.getID(), 0, MessageFormat.format(PHPDebugUIMessages.BreakpointCreated_1, new Object[0]), null);
        }
        return status;
    }

    public IResource getResource(IEditorInput input) {
        return this.getResourceFromInput(input);
    }

    private IResource getResourceFromInput(IEditorInput input) {
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null || !resource.exists()) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    public static int getValidPosition(IDocument idoc, int editorLineNumber) {
        int result = -1;
        if (idoc != null) {
            int startOffset = 0;
            int endOffset = 0;
            try {
                String partitionType = null;
                boolean phpPartitionVisited = false;
                do {
                    IRegion line = idoc.getLineInformation(editorLineNumber - 1);
                    startOffset = line.getOffset();
                    endOffset = Math.max(line.getOffset(), line.getOffset() + line.getLength());
                    ITypedRegion[] partitions = null;
                    partitions = idoc.computePartitioning(startOffset, endOffset - startOffset);
                    int i = 0;
                    while (i < partitions.length) {
                        partitionType = partitions[i].getType();
                        if (partitionType.equals("org.eclipse.php.PHP_DEFAULT")) {
                            phpPartitionVisited = true;
                            startOffset = partitions[i].getOffset();
                            String linePart = idoc.get(startOffset, partitions[i].getLength()).trim();
                            if (Pattern.matches(".*[a-zA-Z0-0_]+.*", linePart) && !linePart.trim().toLowerCase().equals("<?php")) {
                                result = startOffset;
                                break;
                            }
                        }
                        ++i;
                    }
                    ++editorLineNumber;
                } while ((!phpPartitionVisited || PHPStructuredTextPartitioner.isPHPPartitionType(partitionType)) && result == -1);
            }
            catch (BadLocationException badLocationException) {
                result = -1;
            }
        }
        return result;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    public void setSourceEditingTextTools(ISourceEditingTextTools tools) {
    }
}

