/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.ui.treecontent.IncludesNode;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PHPUILabelProvider;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PathMapperEntryDialog
extends StatusDialog {
    private PathMapper.Mapping fEditData;
    private Text fRemotePathText;
    private Button fWorkspacePathBtn;
    private Button fExternalPathBtn;
    private Text fWorkspacePathText;
    private Text fExternalPathText;
    private Button fWorkspacePathBrowseBtn;
    private Button fExternalPathBrowseBtn;

    public PathMapperEntryDialog(Shell parent) {
        this(parent, null);
    }

    public PathMapperEntryDialog(Shell parent, PathMapper.Mapping editData) {
        super(parent);
        if (editData != null) {
            this.fEditData = editData.clone();
            this.setTitle("Edit Path Mapping");
        } else {
            this.setTitle("Add new Path Mapping");
        }
    }

    public PathMapper.Mapping getResult() {
        return this.fEditData;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Label label = new Label(parent, 0);
        label.setText("Path on Server:");
        this.fRemotePathText = new Text(parent, 2048);
        this.fRemotePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapperEntryDialog.this.validate();
            }
        });
        GridData layoutData = new GridData(768);
        layoutData.widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fRemotePathText.setLayoutData((Object)layoutData);
        Composite typeSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        typeSelectionGroup.setLayout((Layout)layout);
        typeSelectionGroup.setLayoutData((Object)new GridData(1808));
        this.fWorkspacePathBtn = new Button(typeSelectionGroup, 16);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fWorkspacePathBtn.setLayoutData((Object)layoutData);
        this.fWorkspacePathBtn.setText("Path in &Workspace");
        this.fWorkspacePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = PathMapperEntryDialog.this.fWorkspacePathBtn.getSelection();
                PathMapperEntryDialog.this.fWorkspacePathText.setEnabled(enabled);
                PathMapperEntryDialog.this.fWorkspacePathBrowseBtn.setEnabled(enabled);
                PathMapperEntryDialog.this.fExternalPathText.setEnabled(!enabled);
                PathMapperEntryDialog.this.fExternalPathBrowseBtn.setEnabled(!enabled);
            }
        });
        this.fWorkspacePathText = new Text(typeSelectionGroup, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = pixelConverter.convertWidthInCharsToPixels(1);
        this.fWorkspacePathText.setLayoutData((Object)layoutData);
        this.fWorkspacePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapperEntryDialog.this.validate();
            }
        });
        this.fWorkspacePathBrowseBtn = new Button(typeSelectionGroup, 0);
        this.fWorkspacePathBrowseBtn.setText("&Browse");
        this.fWorkspacePathBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceBrowseDialog dialog = new WorkspaceBrowseDialog(PathMapperEntryDialog.this.getShell());
                if (dialog.open() == 0) {
                    Object selectedElement = dialog.getSelectedElement();
                    PathMapperEntryDialog.this.fWorkspacePathText.setData(null);
                    if (selectedElement instanceof IResource) {
                        IResource resource = (IResource)selectedElement;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)PathEntry.Type.WORKSPACE);
                        PathMapperEntryDialog.this.fWorkspacePathText.setText(resource.getFullPath().toString());
                    } else if (selectedElement instanceof IIncludePathEntry) {
                        IIncludePathEntry includePathEntry = (IIncludePathEntry)selectedElement;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)(includePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER));
                        if (includePathEntry.getEntryKind() == 4) {
                            IPath incPath = IncludePathVariableManager.instance().resolveVariablePath(includePathEntry.getPath().toString());
                            if (incPath != null) {
                                PathMapperEntryDialog.this.fWorkspacePathText.setText(incPath.toOSString());
                            }
                        } else {
                            PathMapperEntryDialog.this.fWorkspacePathText.setText(includePathEntry.getPath().toOSString());
                        }
                    } else if (selectedElement instanceof WorkspaceBrowseDialog.IPFile) {
                        WorkspaceBrowseDialog.IPFile ipFile = (WorkspaceBrowseDialog.IPFile)selectedElement;
                        IIncludePathEntry includePathEntry = ipFile.includePathEntry;
                        PathMapperEntryDialog.this.fWorkspacePathText.setData((Object)(includePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER));
                        PathMapperEntryDialog.this.fWorkspacePathText.setText(ipFile.file.getAbsolutePath());
                    }
                }
            }
        });
        this.fExternalPathBtn = new Button(typeSelectionGroup, 16);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fExternalPathBtn.setLayoutData((Object)layoutData);
        this.fExternalPathBtn.setText("Path in &File System");
        this.fExternalPathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = PathMapperEntryDialog.this.fExternalPathBtn.getSelection();
                PathMapperEntryDialog.this.fExternalPathText.setEnabled(enabled);
                PathMapperEntryDialog.this.fExternalPathBrowseBtn.setEnabled(enabled);
                PathMapperEntryDialog.this.fWorkspacePathText.setEnabled(!enabled);
                PathMapperEntryDialog.this.fWorkspacePathBrowseBtn.setEnabled(!enabled);
            }
        });
        this.fExternalPathText = new Text(typeSelectionGroup, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = pixelConverter.convertWidthInCharsToPixels(1);
        this.fExternalPathText.setLayoutData((Object)layoutData);
        this.fExternalPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PathMapperEntryDialog.this.validate();
            }
        });
        this.fExternalPathBrowseBtn = new Button(typeSelectionGroup, 0);
        this.fExternalPathBrowseBtn.setText("&Browse");
        this.fExternalPathBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(PathMapperEntryDialog.this.getShell());
                String path = dialog.open();
                if (path != null) {
                    PathMapperEntryDialog.this.fExternalPathText.setText(path);
                }
            }
        });
        PathMapperEntryDialog.applyDialogFont((Control)parent);
        this.initializeValues();
        return parent;
    }

    protected void initializeValues() {
        this.fWorkspacePathBtn.setSelection(true);
        this.fExternalPathBtn.setSelection(false);
        if (this.fEditData != null) {
            this.fRemotePathText.setText(this.fEditData.remotePath.toString());
            if (this.fEditData.type == PathEntry.Type.EXTERNAL) {
                this.fExternalPathBtn.setSelection(true);
                this.fWorkspacePathBtn.setSelection(false);
                this.fExternalPathText.setText(this.fEditData.localPath.toString());
            } else {
                this.fWorkspacePathText.setData((Object)this.fEditData.type);
                this.fWorkspacePathText.setText(this.fEditData.localPath.toString());
            }
        }
        this.fWorkspacePathBtn.notifyListeners(13, new Event());
        this.fExternalPathBtn.notifyListeners(13, new Event());
    }

    protected void setError(String error) {
        this.updateStatus((IStatus)new StatusInfo(4, error));
    }

    protected void validate() {
        PathMapper.Mapping mapping = new PathMapper.Mapping();
        String remotePathStr = this.fRemotePathText.getText().trim();
        if (remotePathStr.length() == 0) {
            this.setError("Path on server must not be empty!");
            return;
        }
        try {
            mapping.remotePath = new VirtualPath(remotePathStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setError("Path on server is illegal or not absolute!");
            return;
        }
        if (this.fWorkspacePathBtn.getSelection()) {
            String workspacePath = this.fWorkspacePathText.getText().trim();
            if (workspacePath.length() == 0) {
                this.setError("Path in workspace must not be empty!");
                return;
            }
            boolean pathExistsInWorkspace = false;
            mapping.type = (PathEntry.Type)this.fWorkspacePathText.getData();
            if (mapping.type == PathEntry.Type.INCLUDE_FOLDER || mapping.type == PathEntry.Type.INCLUDE_VAR) {
                pathExistsInWorkspace = new File(workspacePath).exists();
            } else {
                boolean bl = pathExistsInWorkspace = ResourcesPlugin.getWorkspace().getRoot().findMember(workspacePath) != null;
            }
            if (!pathExistsInWorkspace) {
                this.setError(NLS.bind((String)"Path ''{0}'' doesn't exist in workspace!", (Object)workspacePath));
                return;
            }
            try {
                mapping.localPath = new VirtualPath(workspacePath);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setError("Path in workspace is illegal or not absolute!");
                return;
            }
        }
        String externalPath = this.fExternalPathText.getText().trim();
        if (externalPath.length() == 0) {
            this.setError("Path in file system must not be empty!");
            return;
        }
        if (!new File(externalPath).exists()) {
            this.setError(NLS.bind((String)"Path ''{0}'' doesn't exist in file system!", (Object)externalPath));
            return;
        }
        try {
            mapping.type = PathEntry.Type.EXTERNAL;
            mapping.localPath = new VirtualPath(externalPath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setError("Path in file system is illegal or not absolute!");
            return;
        }
        this.fEditData = mapping;
        this.updateStatus(Status.OK_STATUS);
    }

    class WorkspaceBrowseDialog
    extends StatusDialog {
        private TreeViewer fViewer;
        private Object selectedElement;

        public WorkspaceBrowseDialog(Shell parent) {
            super(parent);
            this.setTitle("Select Workspace Resource");
        }

        public Object getSelectedElement() {
            return this.selectedElement;
        }

        protected Control createDialogArea(Composite parent) {
            parent = (Composite)super.createDialogArea(parent);
            parent.setLayoutData((Object)new GridData(1808));
            PixelConverter pixelConverter = new PixelConverter((Control)parent);
            this.fViewer = new TreeViewer(parent, 2820);
            GridData layoutData = new GridData(1808);
            layoutData.widthHint = pixelConverter.convertWidthInCharsToPixels(70);
            layoutData.heightHint = pixelConverter.convertHeightInCharsToPixels(20);
            this.fViewer.getControl().setLayoutData((Object)layoutData);
            this.fViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    WorkspaceBrowseDialog.this.validate();
                }
            });
            this.fViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            return parent;
        }

        protected void validate() {
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
            Object element = selection.getFirstElement();
            if (element == null || element instanceof IncludesNode) {
                this.updateStatus((IStatus)new StatusInfo(4, ""));
                return;
            }
            this.selectedElement = element;
            this.updateStatus(Status.OK_STATUS);
        }

        class ContentProvider
        implements ITreeContentProvider {
            ContentProvider() {
            }

            public Object[] getChildren(Object parentElement) {
                try {
                    if (parentElement instanceof IContainer) {
                        IProject project;
                        PHPProjectOptions options;
                        IResource[] members;
                        LinkedList<IResource> r = new LinkedList<IResource>();
                        IContainer container = (IContainer)parentElement;
                        IResource[] iResourceArray = members = container.members();
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource member = iResourceArray[n2];
                            if (member instanceof IContainer && member.isAccessible()) {
                                r.add(member);
                            }
                            ++n2;
                        }
                        if (parentElement instanceof IProject && (options = PHPProjectOptions.forProject((IProject)(project = (IProject)parentElement))) != null) {
                            IIncludePathEntry[] includePath = options.readRawIncludePath();
                            r.addAll((Collection)Arrays.asList(includePath));
                        }
                        return r.toArray();
                    }
                    if (parentElement instanceof IIncludePathEntry) {
                        IIncludePathEntry includePathEntry = (IIncludePathEntry)parentElement;
                        IPath path = includePathEntry.getPath();
                        File file = null;
                        if (includePathEntry.getEntryKind() == 1) {
                            file = path.toFile();
                        } else if (includePathEntry.getEntryKind() == 4 && (path = IncludePathVariableManager.instance().resolveVariablePath(path.toString())) != null) {
                            file = path.toFile();
                        }
                        if (file != null) {
                            return this.getChildren(new IPFile(includePathEntry, file));
                        }
                    } else if (parentElement instanceof IPFile) {
                        IPFile ipFile = (IPFile)parentElement;
                        File file = ipFile.file;
                        if (file.isDirectory()) {
                            File[] dirs = file.listFiles(new FileFilter(){

                                public boolean accept(File pathname) {
                                    return pathname.isDirectory();
                                }
                            });
                            ArrayList<IPFile> r = new ArrayList<IPFile>(dirs.length);
                            File[] fileArray = dirs;
                            int n = dirs.length;
                            int n3 = 0;
                            while (n3 < n) {
                                File dir = fileArray[n3];
                                r.add(new IPFile(ipFile.includePathEntry, dir));
                                ++n3;
                            }
                            return r.toArray();
                        }
                    }
                }
                catch (CoreException coreException) {}
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getParent();
                }
                if (element instanceof IPFile) {
                    IPFile ipFile = (IPFile)element;
                    return new IPFile(ipFile.includePathEntry, ipFile.file.getParentFile());
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        class IPFile {
            IIncludePathEntry includePathEntry;
            File file;

            IPFile(IIncludePathEntry includePathEntry, File file) {
                this.includePathEntry = includePathEntry;
                this.file = file;
            }

            public int hashCode() {
                return this.file.hashCode() + 13 * this.includePathEntry.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof IPFile)) {
                    return false;
                }
                IPFile other = (IPFile)obj;
                return other.file.equals(this.file) && other.includePathEntry.equals(this.includePathEntry);
            }
        }

        class LabelProvider
        extends PHPUILabelProvider {
            LabelProvider() {
            }

            public Image getImage(Object element) {
                if (element instanceof IIncludePathEntry) {
                    IIncludePathEntry includePathEntry = (IIncludePathEntry)element;
                    if (includePathEntry.getEntryKind() == 4) {
                        return PHPPluginImages.get((String)"org.eclipse.php.ui.envvar_obj.gif");
                    }
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.library_obj.gif");
                }
                if (element instanceof IPFile) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof IIncludePathEntry) {
                    IIncludePathEntry includePathEntry = (IIncludePathEntry)element;
                    return includePathEntry.getPath().toOSString();
                }
                if (element instanceof IPFile) {
                    return ((IPFile)element).file.getName();
                }
                return super.getText(element);
            }
        }
    }
}

