/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class WorkbenchOptionsBlock
extends AbstractPHPPreferencePageBlock {
    private Button fOpenInBrowser;
    private Button fOpenDebugViews;
    private PreferencePage propertyPage;
    private RadioGroupFieldEditor fSwitchPerspField;
    private RadioGroupFieldEditor fAllowMultipleLnchField;

    public void setCompositeAddon(Composite parent) {
        Composite composite = this.addPageContents(parent);
        this.addWorkspacePreferenceSubsection(composite);
    }

    public void initializeValues(PreferencePage propertyPage) {
        this.propertyPage = propertyPage;
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        this.fOpenDebugViews.setSelection(prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS));
        this.fOpenInBrowser.setSelection(prefs.getBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER));
        this.fAllowMultipleLnchField.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fAllowMultipleLnchField.load();
        this.fSwitchPerspField.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fSwitchPerspField.load();
    }

    public boolean performOK(boolean isProjectSpecific) {
        this.savePreferences();
        return true;
    }

    public void performApply(boolean isProjectSpecific) {
        this.performOK(isProjectSpecific);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        this.fOpenInBrowser.setSelection(prefs.getDefaultBoolean(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER));
        this.fOpenDebugViews.setSelection(prefs.getDefaultBoolean(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS));
        this.fAllowMultipleLnchField.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fAllowMultipleLnchField.load();
        this.fSwitchPerspField.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.fSwitchPerspField.load();
    }

    private void addWorkspacePreferenceSubsection(Composite composite) {
        this.fAllowMultipleLnchField = new RadioGroupFieldEditor("allowMultipleLaunches", PHPDebugUIMessages.PHPLaunchingPreferencePage_multipleMessage, 3, (String[][])new String[][]{{PHPDebugUIMessages.PHPLaunchingPreferencePage_Always, "always"}, {PHPDebugUIMessages.PHPLaunchingPreferencePage_Never, "never"}, {PHPDebugUIMessages.PHPLaunchingPreferencePage_Prompt, "prompt"}}, composite, true);
        this.fSwitchPerspField = new RadioGroupFieldEditor("switchBackToPHPPerspective", PHPDebugUIMessages.PHPLaunchingPreferencePage_switchToPHPMessage, 3, (String[][])new String[][]{{PHPDebugUIMessages.PHPLaunchingPreferencePage_Always, "always"}, {PHPDebugUIMessages.PHPLaunchingPreferencePage_Never, "never"}, {PHPDebugUIMessages.PHPLaunchingPreferencePage_Prompt, "prompt"}}, composite, true);
        Group group = new Group(composite, 0);
        group.setText(PHPDebugUIMessages.WorkbenchOptionsBlock_workbench_options);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        this.fOpenInBrowser = this.addCheckBox((Composite)group, PHPDebugUIMessages.PhpDebugPreferencePage_11, PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, 0);
        this.fOpenDebugViews = this.addCheckBox((Composite)group, PHPDebugUIMessages.PhpDebugPreferencePage_7, PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, 0);
    }

    private void savePreferences() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        prefs.setValue(PHPDebugCorePreferenceNames.OPEN_IN_BROWSER, this.fOpenInBrowser.getSelection());
        prefs.setValue(PHPDebugCorePreferenceNames.OPEN_DEBUG_VIEWS, this.fOpenDebugViews.getSelection());
        PHPDebugPlugin.getDefault().savePluginPreferences();
        this.fAllowMultipleLnchField.store();
        this.fSwitchPerspField.store();
    }
}

