/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.watch;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.ui.Logger;
import org.w3c.dom.Node;

public class XDebugWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String expressionText;
    private IWatchExpressionListener watchListener;
    private DBGpTarget debugTarget;
    private Job evalJob;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.expressionText = expression;
        this.watchListener = listener;
        IDebugTarget target = context.getDebugTarget();
        if (target instanceof DBGpTarget) {
            this.debugTarget = (DBGpTarget)target;
            if (!this.debugTarget.isSuspended()) {
                this.watchListener.watchEvaluationFinished(null);
            } else {
                this.evalJob = new EvaluationRunnable();
                this.evalJob.schedule();
            }
        } else {
            this.watchListener.watchEvaluationFinished(null);
        }
    }

    private final class EvaluationRunnable
    extends Job {
        public EvaluationRunnable() {
            super("XDEbugEvaluationRunnable");
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                XDebugWatchExpressionResult watchResult = new XDebugWatchExpressionResult();
                watchResult.evaluate();
                XDebugWatchExpressionDelegate.this.watchListener.watchEvaluationFinished((IWatchExpressionResult)watchResult);
            }
            catch (Exception e) {
                Logger.logException(e);
                XDebugWatchExpressionDelegate.this.watchListener.watchEvaluationFinished(null);
            }
            return Status.OK_STATUS;
        }
    }

    private class XDebugWatchExpressionResult
    implements IWatchExpressionResult {
        private boolean hasErrors = false;
        private IValue evalResult;

        private XDebugWatchExpressionResult() {
        }

        public IValue getValue() {
            return this.evalResult;
        }

        public void evaluate() {
            String stackLevel = "0";
            String testExp = XDebugWatchExpressionDelegate.this.expressionText.trim();
            Node result = null;
            result = XDebugWatchExpressionDelegate.this.debugTarget.eval(testExp);
            if (result != null) {
                DBGpVariable tempVar = new DBGpVariable(XDebugWatchExpressionDelegate.this.debugTarget, result, stackLevel);
                this.evalResult = null;
                try {
                    this.evalResult = tempVar.getValue();
                    if (this.evalResult == null) {
                        this.hasErrors = true;
                    }
                }
                catch (Exception exception) {
                    this.hasErrors = true;
                }
            } else {
                this.hasErrors = true;
            }
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public String[] getErrorMessages() {
            if (this.hasErrors) {
                return new String[]{"Failed to evaluation Expression"};
            }
            return null;
        }

        public String getExpressionText() {
            return XDebugWatchExpressionDelegate.this.expressionText;
        }

        public DebugException getException() {
            return null;
        }
    }
}

