/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PHPCorePlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.php.core";
    public static final int INTERNAL_ERROR = 10001;
    private static PHPCorePlugin plugin;
    public static final boolean isDebugMode;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.php.core/debug");
        isDebugMode = value != null && value.equalsIgnoreCase("true");
    }

    public PHPCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Job delayedJob = new Job("Initializing PHP Toolkit"){

            protected IStatus run(IProgressMonitor monitor) {
                PHPWorkspaceModelManager.getInstance().startup();
                IncludePathVariableManager.instance().startUp();
                return Status.OK_STATUS;
            }
        };
        delayedJob.setPriority(30);
        delayedJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            PHPWorkspaceModelManager.getInstance().shutdown();
        }
        finally {
            super.stop(context);
            plugin = null;
        }
    }

    public static PHPCorePlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        PHPCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PHPCorePlugin.log((IStatus)new Status(4, ID, 10001, "PHPCore plugin internal error", e));
    }

    public static void logErrorMessage(String message) {
        PHPCorePlugin.log((IStatus)new Status(4, ID, 10001, message, null));
    }

    public static void setIncludePathVariable(String name, IPath path, IProgressMonitor monitor) {
        IncludePathVariableManager.instance().putVariable(name, path);
    }

    public static String getPluginId() {
        return ID;
    }
}

