/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import org.eclipse.php.internal.core.ast.binding.Attribute;
import org.eclipse.php.internal.core.ast.binding.ProgramScope;
import org.eclipse.php.internal.core.ast.binding.Scope;
import org.eclipse.php.internal.core.ast.binding.ScopeBase;
import org.eclipse.php.internal.core.ast.binding.ScopeType;

public class GlobalScope
extends ScopeBase {
    public final Scope parentScope;
    public GlobalScope childScope;

    protected GlobalScope(int start, Scope parentScope, GlobalScope childScope, ProgramScope programScope) {
        super(start, programScope);
        assert (parentScope != null);
        this.parentScope = parentScope;
    }

    public static GlobalScope createRootScope(int start, ProgramScope programScope) {
        GlobalScope globalScope = new GlobalScope(start, programScope, null, programScope);
        return globalScope;
    }

    public GlobalScope enterScope(int start) {
        GlobalScope globalScope;
        this.childScope = globalScope = new GlobalScope(start, this, null, this.programScope);
        this.length = start - this.start;
        return globalScope;
    }

    public Scope getChild() {
        return this.childScope;
    }

    public Scope getParent() {
        return this.parentScope;
    }

    public Scope getScope(int offset) {
        switch (this.compareTo(offset)) {
            case 0: {
                return this;
            }
            case -1: {
                return this.getChild();
            }
            case 1: {
                return this.getParent();
            }
        }
        throw new IllegalArgumentException();
    }

    protected int compareTo(int offset) {
        return this.start <= offset ? (this.start + this.length > offset ? 0 : 1) : -1;
    }

    public ScopeType getScopeType() {
        return ScopeType.GLOBAL_SCOPE;
    }

    public Attribute lookup(String identifier) {
        return null;
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Scope");
        this.appendInterval(buffer);
        buffer.append(">");
        super.toString(buffer, String.valueOf(tab) + "\t");
        buffer.append("\n");
        Scope child = this.getChild();
        if (child != null) {
            child.toString(buffer, String.valueOf(tab) + "\t");
        }
        buffer.append(tab).append("</Scope>\n");
    }
}

