/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding.proposal;

import org.eclipse.php.internal.core.ast.binding.proposal.ResolvedVariable;
import org.eclipse.php.internal.core.ast.binding.proposal.VariableResolver;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Variable;

public class GlobalVariableResolver
implements VariableResolver {
    private static final GlobalVariableResolver _resolver = new GlobalVariableResolver();

    private GlobalVariableResolver() {
    }

    public static GlobalVariableResolver getResolver() {
        return _resolver;
    }

    public ResolvedVariable resolveName(String name) {
        return ResolvedVariable.getBinding(ResolvedVariable.ScopeKind.GLOBAL, name);
    }

    public ResolvedVariable resolveName(Variable var) {
        Expression varname = var.getVariableName();
        if (var.isDollared() && varname instanceof Identifier) {
            return this.resolveName(((Identifier)varname).getName());
        }
        return ResolvedVariable.UNKNOWN;
    }

    public VariableResolver addGlobalNames(String[] names) {
        return this;
    }

    public VariableResolver addGlobalNames(Variable[] names) {
        return this;
    }
}

