/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding.proposal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.php.internal.core.ast.binding.proposal.ResolvedVariable;
import org.eclipse.php.internal.core.ast.binding.proposal.VariableResolver;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableResolver
implements VariableResolver {
    private static final HashSet<String> _supers = new HashSet();
    private final HashSet<String> _globals;
    private final HashSet<String> _undetermined;
    private final boolean _indeterminate;

    public LocalVariableResolver() {
        String[] names;
        String[] stringArray = names = new String[]{"_GET", "_POST", "_FILES", "_COOKIE", "_REQUEST", "_SESSION", "_SERVER", "_ENV", "GLOBALS"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            _supers.add(n3);
            ++n2;
        }
        this._globals = new HashSet();
        this._undetermined = new HashSet();
        this._indeterminate = false;
    }

    public LocalVariableResolver(Collection<String> globals) {
        String[] names;
        String[] stringArray = names = new String[]{"_GET", "_POST", "_FILES", "_COOKIE", "_REQUEST", "_SESSION", "_SERVER", "_ENV", "GLOBALS"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            _supers.add(n3);
            ++n2;
        }
        this._globals = new HashSet<String>(globals);
        this._undetermined = new HashSet();
        this._indeterminate = false;
    }

    public LocalVariableResolver(LocalVariableResolver x, LocalVariableResolver y) {
        String[] names;
        String[] stringArray = names = new String[]{"_GET", "_POST", "_FILES", "_COOKIE", "_REQUEST", "_SESSION", "_SERVER", "_ENV", "GLOBALS"};
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            _supers.add(n3);
            ++n2;
        }
        boolean bl = this._indeterminate = x._indeterminate || y._indeterminate;
        if (this._indeterminate) {
            this._globals = new HashSet<String>(x._globals);
            this._globals.retainAll(y._globals);
            this._undetermined = new HashSet();
        } else {
            this._globals = new HashSet<String>(x._globals);
            this._globals.retainAll(y._globals);
            this._undetermined = new HashSet<String>(x._globals);
            this._undetermined.addAll(y._globals);
            this._undetermined.removeAll(this._globals);
            this._undetermined.addAll(x._undetermined);
            this._undetermined.addAll(y._undetermined);
        }
    }

    public LocalVariableResolver(LocalVariableResolver v, String[] names) {
        String[] names2;
        String[] stringArray = names2 = new String[]{"_GET", "_POST", "_FILES", "_COOKIE", "_REQUEST", "_SESSION", "_SERVER", "_ENV", "GLOBALS"};
        int n = names2.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            _supers.add(n3);
            ++n2;
        }
        this._globals = new HashSet<String>(v._globals);
        this._undetermined = new HashSet<String>(v._undetermined);
        boolean i = v._indeterminate;
        stringArray = names;
        n = names.length;
        n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s == null) {
                i = true;
            } else {
                this._globals.add(s);
                this._undetermined.remove(s);
            }
            ++n2;
        }
        this._indeterminate = i;
        if (this._indeterminate) {
            this._undetermined.clear();
        }
    }

    @Override
    public ResolvedVariable resolveName(Variable var) {
        Expression varname = var.getVariableName();
        if (var.isDollared() && varname instanceof Identifier) {
            return this.resolveName(((Identifier)varname).getName());
        }
        return ResolvedVariable.UNKNOWN;
    }

    @Override
    public VariableResolver addGlobalNames(String[] names) {
        Vector<String> newnames = new Vector<String>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (!this._globals.contains(n3)) {
                newnames.add(n3);
            }
            ++n2;
        }
        if (newnames.isEmpty()) {
            return this;
        }
        return new LocalVariableResolver(this, newnames.toArray(new String[newnames.size()]));
    }

    @Override
    public VariableResolver addGlobalNames(Variable[] names) {
        String[] snames = new String[names.length];
        int i = 0;
        while (i < names.length) {
            Variable var = names[i];
            Expression varname = var.getVariableName();
            snames[i] = var.isDollared() && varname instanceof Identifier ? ((Identifier)varname).getName() : null;
            ++i;
        }
        return this.addGlobalNames(snames);
    }

    @Override
    public ResolvedVariable resolveName(String name) {
        if (name == null) {
            return ResolvedVariable.UNKNOWN;
        }
        if (_supers.contains(name) || this._globals.contains(name)) {
            return ResolvedVariable.getBinding(ResolvedVariable.ScopeKind.GLOBAL, name);
        }
        if (this._indeterminate || this._undetermined.contains(name)) {
            return ResolvedVariable.getBinding(ResolvedVariable.ScopeKind.UNDETERMINED, name);
        }
        return ResolvedVariable.getBinding(ResolvedVariable.ScopeKind.LOCAL, name);
    }

    public String toString() {
        String r = "LocalVariableResolver: " + super.toString() + " " + (this._indeterminate ? "INDETERMINATE" : "determinate") + " ";
        r = String.valueOf(r) + "Globals(";
        for (String g : this._globals) {
            r = String.valueOf(r) + g + ",";
        }
        r = String.valueOf(r) + ") Undetermined (";
        for (String u : this._undetermined) {
            r = String.valueOf(r) + u + ",";
        }
        return String.valueOf(r) + ")";
    }
}

