/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding.proposal;

import java.util.Hashtable;

public class ResolvedVariable {
    public static final ResolvedVariable UNKNOWN = new ResolvedVariable();
    private static final Hashtable<String, ResolvedVariable> _globals = new Hashtable();
    private static final Hashtable<String, ResolvedVariable> _locals = new Hashtable();
    private static Hashtable<String, ResolvedVariable> _undetermined = null;
    private final String _name;
    private final ScopeKind _scope;

    private ResolvedVariable(ScopeKind kind, String name) {
        assert (name != null) : "ResolvedVariable created with null name.";
        this._scope = kind;
        this._name = name;
        switch (kind) {
            case GLOBAL: {
                _globals.put(this._name, this);
                break;
            }
            case LOCAL: {
                _locals.put(this._name, this);
                break;
            }
            case UNDETERMINED: {
                if (_undetermined == null) {
                    _undetermined = new Hashtable();
                }
                _undetermined.put(this._name, this);
            }
        }
    }

    private ResolvedVariable() {
        this._name = null;
        this._scope = null;
    }

    public String getName() {
        return this._name;
    }

    public ScopeKind getScope() {
        return this._scope;
    }

    public String toString() {
        return "(" + (Object)((Object)this._scope) + "," + this._name + ")";
    }

    public static ResolvedVariable getBinding(ScopeKind scope, String name) {
        ResolvedVariable r;
        if (name == null) {
            return UNKNOWN;
        }
        switch (scope) {
            case GLOBAL: {
                r = _globals.get(name);
                break;
            }
            case LOCAL: {
                r = _locals.get(name);
                break;
            }
            case UNDETERMINED: {
                if (_undetermined == null) {
                    r = null;
                    break;
                }
                r = _undetermined.get(name);
                break;
            }
            default: {
                throw new AssertionError((Object)"Nonexistent scope value");
            }
        }
        if (r == null) {
            return new ResolvedVariable(scope, name);
        }
        return r;
    }

    public static void printContents() {
        System.out.println("Globals:");
        for (ResolvedVariable r : _globals.values()) {
            System.out.println("  " + r);
        }
        System.out.println("Locals:");
        for (ResolvedVariable r : _locals.values()) {
            System.out.println("  " + r);
        }
        System.out.println("Undetermined:");
        if (_undetermined == null) {
            System.out.println("  None.");
        } else {
            for (ResolvedVariable r : _undetermined.values()) {
                System.out.println("  " + r);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScopeKind {
        GLOBAL,
        LOCAL,
        UNDETERMINED;

    }
}

